/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.builder;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.PostBuildHandler;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class BPMPostBuildHandler
implements PostBuildHandler {
    protected static Logger logger = LoggerFactory.getLogger(BPMPostBuildHandler.class);
    @Inject
    private DDEditorService deploymentDescriptorService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    public void process(BuildResults buildResults) {
        String rootPathString = buildResults.getParameter("RootPath");
        if (rootPathString == null) {
            return;
        }
        Path ddPath = this.ioService.get(URI.create(rootPathString + "/src/main/resources/META-INF/kie-deployment-descriptor.xml"));
        if (this.ioService.exists(ddPath)) {
            org.uberfire.backend.vfs.Path deploymentDescriptorPath = Paths.convert((Path)ddPath);
            DeploymentDescriptorModel ddModel = (DeploymentDescriptorModel)this.deploymentDescriptorService.load(deploymentDescriptorPath);
            buildResults.addParameter("RuntimeStrategy", ddModel.getRuntimeStrategy());
        } else {
            logger.debug("Deployment descriptor not found {}", (Object)ddPath);
        }
    }

    public void setDeploymentDescriptorService(DDEditorService deploymentDescriptorService) {
        this.deploymentDescriptorService = deploymentDescriptorService;
    }

    public void setIoService(IOService ioService) {
        this.ioService = ioService;
    }
}

