/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.casemgmt.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jbpm.workbench.wi.backend.server.casemgmt.service.CaseProjectServiceImpl;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseProjectServiceImplTest {
    @Mock
    IOService ioService;
    @Mock
    DDEditorService ddEditorService;
    @Mock
    org.uberfire.backend.vfs.Path kmodulePath;
    @Mock
    org.uberfire.backend.vfs.Path projectPath;
    @Mock
    Path ddPath;
    @Mock
    KieProject kieProject;
    private CaseProjectServiceImpl caseProjectService;

    @BeforeClass
    public static void setupOnce() {
        System.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        System.setProperty("org.uberfire.nio.git.ssh.enabled", "false");
    }

    @AfterClass
    public static void cleanOnce() {
        System.clearProperty("org.uberfire.nio.git.daemon.enabled");
        System.clearProperty("org.uberfire.nio.git.ssh.enabled");
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.kmodulePath.toURI()).thenReturn((Object)"default://p0/Evaluation/src/main/resources/META-INF/kmodule.xml");
        Mockito.when((Object)this.projectPath.toURI()).thenReturn((Object)"default://p0/Evaluation");
        Mockito.when((Object)this.ddPath.toUri()).thenReturn((Object)URI.create("default://p0/Evaluation/src/main/resources/META-INF/kie-deployment-descriptor.xml"));
        Mockito.when((Object)this.ddPath.getParent()).thenReturn(Mockito.mock(Path.class));
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fileSystem.supportedFileAttributeViews()).thenReturn(new HashSet());
        Mockito.when((Object)this.ddPath.getFileSystem()).thenReturn((Object)fileSystem);
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)this.ddPath);
        Mockito.when((Object)this.ddEditorService.load((org.uberfire.backend.vfs.Path)Mockito.any())).thenReturn((Object)new DeploymentDescriptorModel());
        Mockito.when((Object)this.kieProject.getKModuleXMLPath()).thenReturn((Object)this.kmodulePath);
        Mockito.when((Object)this.kieProject.getRootPath()).thenReturn((Object)this.projectPath);
        this.caseProjectService = new CaseProjectServiceImpl(this.ddEditorService, this.ioService);
    }

    @Test
    public void testConfigureNewCaseProject() {
        ArgumentCaptor ddArgumentCaptor = ArgumentCaptor.forClass(DeploymentDescriptorModel.class);
        DirectoryStream directoryStream = (DirectoryStream)Mockito.mock(DirectoryStream.class);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(), (DirectoryStream.Filter)Mockito.any())).thenReturn((Object)directoryStream);
        Mockito.when((Object)directoryStream.iterator()).thenReturn(new ArrayList().iterator());
        this.caseProjectService.configureNewCaseProject((Project)this.kieProject);
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)Mockito.any(), ddArgumentCaptor.capture(), (Metadata)Mockito.any(), (String)Mockito.eq((Object)"Updated with case project configuration"));
        DeploymentDescriptorModel updatedDD = (DeploymentDescriptorModel)ddArgumentCaptor.getValue();
        Assert.assertNotNull((Object)updatedDD);
        Assert.assertEquals((Object)"PER_CASE", (Object)updatedDD.getRuntimeStrategy());
        List marshallingStrategies = updatedDD.getMarshallingStrategies();
        Assert.assertEquals((long)2L, (long)marshallingStrategies.size());
        Map<String, String> mappedStrategies = marshallingStrategies.stream().collect(Collectors.toMap(ItemObjectModel::getValue, ItemObjectModel::getResolver));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        List workItemHandlers = updatedDD.getWorkItemHandlers();
        Assert.assertEquals((long)1L, (long)workItemHandlers.size());
        ItemObjectModel startCaseHandler = (ItemObjectModel)workItemHandlers.get(0);
        Assert.assertEquals((Object)"mvel", (Object)startCaseHandler.getResolver());
        Assert.assertEquals((Object)"StartCaseInstance", (Object)startCaseHandler.getName());
        Assert.assertEquals((Object)"new org.jbpm.casemgmt.impl.wih.StartCaseWorkItemHandler(ksession);", (Object)startCaseHandler.getValue());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.any(), (byte[])Mockito.any(byte[].class), new OpenOption[0]);
    }

    @Test
    public void testConfigureNewCaseProjectWithPackages() {
        ArgumentCaptor ddArgumentCaptor = ArgumentCaptor.forClass(DeploymentDescriptorModel.class);
        Path packagePath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)packagePath.toUri()).thenReturn((Object)URI.create("default://p0/Evaluation/src/main/resources/org"));
        DirectoryStream directoryStream = (DirectoryStream)Mockito.mock(DirectoryStream.class);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(), (DirectoryStream.Filter)Mockito.any())).thenReturn((Object)directoryStream);
        Mockito.when((Object)directoryStream.iterator()).thenReturn(Arrays.asList(packagePath).iterator());
        this.caseProjectService.configureNewCaseProject((Project)this.kieProject);
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)Mockito.any(), ddArgumentCaptor.capture(), (Metadata)Mockito.any(), (String)Mockito.eq((Object)"Updated with case project configuration"));
        DeploymentDescriptorModel updatedDD = (DeploymentDescriptorModel)ddArgumentCaptor.getValue();
        Assert.assertNotNull((Object)updatedDD);
        Assert.assertEquals((Object)"PER_CASE", (Object)updatedDD.getRuntimeStrategy());
        List marshallingStrategies = updatedDD.getMarshallingStrategies();
        Assert.assertEquals((long)2L, (long)marshallingStrategies.size());
        Map<String, String> mappedStrategies = marshallingStrategies.stream().collect(Collectors.toMap(ItemObjectModel::getValue, ItemObjectModel::getResolver));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).write((Path)Mockito.any(), (byte[])Mockito.any(byte[].class), new OpenOption[0]);
    }

    @Test
    public void testConfigureNewPackage() {
        Path packagePath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)packagePath.toUri()).thenReturn((Object)URI.create("default://p0/Evaluation/src/main/resources/org"));
        DirectoryStream directoryStream = (DirectoryStream)Mockito.mock(DirectoryStream.class);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(), (DirectoryStream.Filter)Mockito.any())).thenReturn((Object)directoryStream);
        Mockito.when((Object)directoryStream.iterator()).thenReturn(Arrays.asList(packagePath).iterator());
        Package pkg = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)pkg.getProjectRootPath()).thenReturn((Object)this.projectPath);
        Mockito.when((Object)pkg.getPackageMainResourcesPath()).thenReturn((Object)this.projectPath);
        NewPackageEvent event = new NewPackageEvent(pkg);
        this.caseProjectService.configurePackage(event);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.any(), (byte[])Mockito.any(byte[].class), new OpenOption[0]);
    }

    @Test
    public void testConfigureNewCaseProjectNoDeploymentDescriptor() {
        ArgumentCaptor ddArgumentCaptor = ArgumentCaptor.forClass(DeploymentDescriptorModel.class);
        DirectoryStream directoryStream = (DirectoryStream)Mockito.mock(DirectoryStream.class);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(), (DirectoryStream.Filter)Mockito.any())).thenReturn((Object)directoryStream);
        Mockito.when((Object)directoryStream.iterator()).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)this.ioService.exists(this.ddPath)).thenReturn((Object)false);
        this.caseProjectService.configureNewCaseProject((Project)this.kieProject);
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)Mockito.any(), ddArgumentCaptor.capture(), (Metadata)Mockito.any(), (String)Mockito.eq((Object)"Updated with case project configuration"));
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).createIfNotExists((org.uberfire.backend.vfs.Path)Mockito.any());
        DeploymentDescriptorModel updatedDD = (DeploymentDescriptorModel)ddArgumentCaptor.getValue();
        Assert.assertNotNull((Object)updatedDD);
        Assert.assertEquals((Object)"PER_CASE", (Object)updatedDD.getRuntimeStrategy());
        List marshallingStrategies = updatedDD.getMarshallingStrategies();
        Assert.assertEquals((long)2L, (long)marshallingStrategies.size());
        Map<String, String> mappedStrategies = marshallingStrategies.stream().collect(Collectors.toMap(ItemObjectModel::getValue, ItemObjectModel::getResolver));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        List workItemHandlers = updatedDD.getWorkItemHandlers();
        Assert.assertEquals((long)1L, (long)workItemHandlers.size());
        ItemObjectModel startCaseHandler = (ItemObjectModel)workItemHandlers.get(0);
        Assert.assertEquals((Object)"mvel", (Object)startCaseHandler.getResolver());
        Assert.assertEquals((Object)"StartCaseInstance", (Object)startCaseHandler.getName());
        Assert.assertEquals((Object)"new org.jbpm.casemgmt.impl.wih.StartCaseWorkItemHandler(ksession);", (Object)startCaseHandler.getValue());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.any(), (byte[])Mockito.any(byte[].class), new OpenOption[0]);
    }
}

