/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.casemgmt.service;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.jbpm.workbench.wi.backend.server.casemgmt.service.CaseProjectServiceImpl;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class CaseProjectServiceImplTest {
    @Mock
    IOService ioService;
    @Mock
    DDEditorService ddEditorService;
    @Mock
    org.uberfire.backend.vfs.Path kmodulePath;
    @Mock
    org.uberfire.backend.vfs.Path projectPath;
    @Mock
    Path ddPath;
    @Mock
    KieModule kieModule;
    @Mock
    private Appender mockAppender;
    @Captor
    private ArgumentCaptor<LoggingEvent> captorLoggingEvent;
    private CaseProjectServiceImpl caseProjectService;

    @BeforeClass
    public static void setupOnce() {
        System.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        System.setProperty("org.uberfire.nio.git.ssh.enabled", "false");
    }

    @AfterClass
    public static void cleanOnce() {
        System.clearProperty("org.uberfire.nio.git.daemon.enabled");
        System.clearProperty("org.uberfire.nio.git.ssh.enabled");
    }

    @Before
    public void setup() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.addAppender(this.mockAppender);
        Mockito.when((Object)this.kmodulePath.toURI()).thenReturn((Object)"default://p0/Evaluation/src/main/resources/META-INF/kmodule.xml");
        Mockito.when((Object)this.projectPath.toURI()).thenReturn((Object)"default://p0/Evaluation");
        Mockito.when((Object)this.ddPath.toUri()).thenReturn((Object)URI.create("default://p0/Evaluation/src/main/resources/META-INF/kie-deployment-descriptor.xml"));
        Mockito.when((Object)this.ddPath.getParent()).thenReturn(Mockito.mock(Path.class));
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fileSystem.supportedFileAttributeViews()).thenReturn(new HashSet());
        Mockito.when((Object)this.ddPath.getFileSystem()).thenReturn((Object)fileSystem);
        Mockito.when((Object)this.ioService.get((URI)Mockito.any())).thenReturn((Object)this.ddPath);
        Mockito.when((Object)this.ddEditorService.load((org.uberfire.backend.vfs.Path)Mockito.any())).thenReturn((Object)new DeploymentDescriptorModel());
        Mockito.when((Object)this.kieModule.getKModuleXMLPath()).thenReturn((Object)this.kmodulePath);
        Mockito.when((Object)this.kieModule.getRootPath()).thenReturn((Object)this.projectPath);
        this.caseProjectService = new CaseProjectServiceImpl(this.ddEditorService, this.ioService);
    }

    @After
    public void tearDown() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.detachAppender(this.mockAppender);
    }

    @Test
    public void testConfigureNewCaseProject() {
        ArgumentCaptor ddArgumentCaptor = ArgumentCaptor.forClass(DeploymentDescriptorModel.class);
        DirectoryStream directoryStream = (DirectoryStream)Mockito.mock(DirectoryStream.class);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(), (DirectoryStream.Filter)Mockito.any())).thenReturn((Object)directoryStream);
        Mockito.when((Object)directoryStream.iterator()).thenReturn(new ArrayList().iterator());
        Branch branch = (Branch)Mockito.mock(Branch.class);
        ((Branch)Mockito.doReturn((Object)this.projectPath).when((Object)branch)).getPath();
        this.caseProjectService.configureNewCaseProject(new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), branch, (Module)this.kieModule));
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)Mockito.any(), ddArgumentCaptor.capture(), (Metadata)Mockito.any(), (String)Mockito.eq((Object)"Updated with case project configuration"));
        DeploymentDescriptorModel updatedDD = (DeploymentDescriptorModel)ddArgumentCaptor.getValue();
        Assert.assertNotNull((Object)updatedDD);
        Assert.assertEquals((Object)"PER_CASE", (Object)updatedDD.getRuntimeStrategy());
        List marshallingStrategies = updatedDD.getMarshallingStrategies();
        Assert.assertEquals((long)2L, (long)marshallingStrategies.size());
        Map<String, String> mappedStrategies = marshallingStrategies.stream().collect(Collectors.toMap(ItemObjectModel::getValue, ItemObjectModel::getResolver));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        List workItemHandlers = updatedDD.getWorkItemHandlers();
        Assert.assertEquals((long)1L, (long)workItemHandlers.size());
        ItemObjectModel startCaseHandler = (ItemObjectModel)workItemHandlers.get(0);
        Assert.assertEquals((Object)"mvel", (Object)startCaseHandler.getResolver());
        Assert.assertEquals((Object)"StartCaseInstance", (Object)startCaseHandler.getName());
        Assert.assertEquals((Object)"new org.jbpm.casemgmt.impl.wih.StartCaseWorkItemHandler(ksession);", (Object)startCaseHandler.getValue());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)5))).write((Path)Mockito.any(), (byte[])Mockito.any(byte[].class), new OpenOption[0]);
    }

    @Test
    public void testConfigureNewCaseProjectWithPackages() {
        ArgumentCaptor ddArgumentCaptor = ArgumentCaptor.forClass(DeploymentDescriptorModel.class);
        Path packagePath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)packagePath.toUri()).thenReturn((Object)URI.create("default://p0/Evaluation/src/main/resources/org"));
        DirectoryStream directoryStream = (DirectoryStream)Mockito.mock(DirectoryStream.class);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(), (DirectoryStream.Filter)Mockito.any())).thenReturn((Object)directoryStream);
        Mockito.when((Object)directoryStream.iterator()).thenReturn(Arrays.asList(packagePath).iterator());
        Branch branch = (Branch)Mockito.mock(Branch.class);
        ((Branch)Mockito.doReturn((Object)this.projectPath).when((Object)branch)).getPath();
        this.caseProjectService.configureNewCaseProject(new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), branch, (Module)this.kieModule));
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)Mockito.any(), ddArgumentCaptor.capture(), (Metadata)Mockito.any(), (String)Mockito.eq((Object)"Updated with case project configuration"));
        DeploymentDescriptorModel updatedDD = (DeploymentDescriptorModel)ddArgumentCaptor.getValue();
        Assert.assertNotNull((Object)updatedDD);
        Assert.assertEquals((Object)"PER_CASE", (Object)updatedDD.getRuntimeStrategy());
        List marshallingStrategies = updatedDD.getMarshallingStrategies();
        Assert.assertEquals((long)2L, (long)marshallingStrategies.size());
        Map<String, String> mappedStrategies = marshallingStrategies.stream().collect(Collectors.toMap(ItemObjectModel::getValue, ItemObjectModel::getResolver));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)5))).write((Path)Mockito.any(), (byte[])Mockito.any(byte[].class), new OpenOption[0]);
    }

    @Test
    public void testConfigureNewCaseProjectNoDeploymentDescriptor() {
        ArgumentCaptor ddArgumentCaptor = ArgumentCaptor.forClass(DeploymentDescriptorModel.class);
        DirectoryStream directoryStream = (DirectoryStream)Mockito.mock(DirectoryStream.class);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(), (DirectoryStream.Filter)Mockito.any())).thenReturn((Object)directoryStream);
        Mockito.when((Object)directoryStream.iterator()).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)this.ioService.exists(this.ddPath)).thenReturn((Object)false);
        Branch branch = (Branch)Mockito.mock(Branch.class);
        ((Branch)Mockito.doReturn((Object)this.projectPath).when((Object)branch)).getPath();
        this.caseProjectService.configureNewCaseProject(new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), branch, (Module)this.kieModule));
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)Mockito.any(), ddArgumentCaptor.capture(), (Metadata)Mockito.any(), (String)Mockito.eq((Object)"Updated with case project configuration"));
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).createIfNotExists((org.uberfire.backend.vfs.Path)Mockito.any());
        DeploymentDescriptorModel updatedDD = (DeploymentDescriptorModel)ddArgumentCaptor.getValue();
        Assert.assertNotNull((Object)updatedDD);
        Assert.assertEquals((Object)"PER_CASE", (Object)updatedDD.getRuntimeStrategy());
        List marshallingStrategies = updatedDD.getMarshallingStrategies();
        Assert.assertEquals((long)2L, (long)marshallingStrategies.size());
        Map<String, String> mappedStrategies = marshallingStrategies.stream().collect(Collectors.toMap(ItemObjectModel::getValue, ItemObjectModel::getResolver));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        List workItemHandlers = updatedDD.getWorkItemHandlers();
        Assert.assertEquals((long)1L, (long)workItemHandlers.size());
        ItemObjectModel startCaseHandler = (ItemObjectModel)workItemHandlers.get(0);
        Assert.assertEquals((Object)"mvel", (Object)startCaseHandler.getResolver());
        Assert.assertEquals((Object)"StartCaseInstance", (Object)startCaseHandler.getName());
        Assert.assertEquals((Object)"new org.jbpm.casemgmt.impl.wih.StartCaseWorkItemHandler(ksession);", (Object)startCaseHandler.getValue());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)5))).write((Path)Mockito.any(), (byte[])Mockito.any(byte[].class), new OpenOption[0]);
    }

    @Test
    public void testConfigureNewCaseProjectErrorWritingDotFile() {
        Mockito.when((Object)this.ioService.write((Path)Mockito.any(), Mockito.anyString(), new OpenOption[0])).thenThrow(IllegalArgumentException.class);
        ArgumentCaptor ddArgumentCaptor = ArgumentCaptor.forClass(DeploymentDescriptorModel.class);
        DirectoryStream directoryStream = (DirectoryStream)Mockito.mock(DirectoryStream.class);
        Mockito.when((Object)this.ioService.newDirectoryStream((Path)Mockito.any(), (DirectoryStream.Filter)Mockito.any())).thenReturn((Object)directoryStream);
        Mockito.when((Object)directoryStream.iterator()).thenReturn(new ArrayList().iterator());
        Branch branch = (Branch)Mockito.mock(Branch.class);
        ((Branch)Mockito.doReturn((Object)this.projectPath).when((Object)branch)).getPath();
        this.caseProjectService.configureNewCaseProject(new WorkspaceProject((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class), (Repository)Mockito.mock(Repository.class), branch, (Module)this.kieModule));
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)Mockito.any(), ddArgumentCaptor.capture(), (Metadata)Mockito.any(), (String)Mockito.eq((Object)"Updated with case project configuration"));
        DeploymentDescriptorModel updatedDD = (DeploymentDescriptorModel)ddArgumentCaptor.getValue();
        Assert.assertNotNull((Object)updatedDD);
        Assert.assertEquals((Object)"PER_CASE", (Object)updatedDD.getRuntimeStrategy());
        List marshallingStrategies = updatedDD.getMarshallingStrategies();
        Assert.assertEquals((long)2L, (long)marshallingStrategies.size());
        Map<String, String> mappedStrategies = marshallingStrategies.stream().collect(Collectors.toMap(ItemObjectModel::getValue, ItemObjectModel::getResolver));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertTrue((boolean)mappedStrategies.containsKey("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();"));
        Assert.assertEquals((Object)"mvel", (Object)mappedStrategies.get("new org.jbpm.document.marshalling.DocumentMarshallingStrategy();"));
        List workItemHandlers = updatedDD.getWorkItemHandlers();
        Assert.assertEquals((long)1L, (long)workItemHandlers.size());
        ItemObjectModel startCaseHandler = (ItemObjectModel)workItemHandlers.get(0);
        Assert.assertEquals((Object)"mvel", (Object)startCaseHandler.getResolver());
        Assert.assertEquals((Object)"StartCaseInstance", (Object)startCaseHandler.getName());
        Assert.assertEquals((Object)"new org.jbpm.casemgmt.impl.wih.StartCaseWorkItemHandler(ksession);", (Object)startCaseHandler.getValue());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)5))).write((Path)Mockito.any(), (byte[])Mockito.any(byte[].class), new OpenOption[0]);
        ((Appender)Mockito.verify((Object)this.mockAppender, (VerificationMode)Mockito.times((int)1))).doAppend(this.captorLoggingEvent.capture());
        LoggingEvent loggingEvent = (LoggingEvent)this.captorLoggingEvent.getValue();
        Assert.assertEquals((Object)loggingEvent.getLevel(), (Object)Level.ERROR);
        Assert.assertEquals((Object)loggingEvent.getFormattedMessage(), (Object)"Unable to write caseproject marker (dot) file: null");
    }
}

