/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.dd;

import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Module;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;

@ApplicationScoped
public class DDConfigUpdaterHelper {
    private KieModuleService moduleService;
    private IOService ioService;
    private PersistenceDescriptorService pdService;

    public DDConfigUpdaterHelper() {
    }

    @Inject
    public DDConfigUpdaterHelper(KieModuleService moduleService, @Named(value="ioStrategy") IOService ioService, PersistenceDescriptorService pdService) {
        this.moduleService = moduleService;
        this.pdService = pdService;
        this.ioService = ioService;
    }

    public boolean isPersistenceFile(Path path) {
        KieModule kieModule;
        if (path.getFileName().equals("persistence.xml") && (kieModule = (KieModule)this.moduleService.resolveModule(path)) != null && kieModule.getRootPath() != null) {
            String persistenceURI = kieModule.getRootPath().toURI() + "/src/main/resources/META-INF/persistence.xml";
            return persistenceURI.equals(path.toURI());
        }
        return false;
    }

    public boolean hasPersistenceFile(Path path) {
        KieModule kieModule = (KieModule)this.moduleService.resolveModule(path);
        if (kieModule != null && kieModule.getRootPath() != null) {
            String persistenceURI = kieModule.getRootPath().toURI() + "/src/main/resources/META-INF/persistence.xml";
            Path persistencePath = PathFactory.newPath((String)"persistence.xml", (String)persistenceURI);
            return this.ioService.exists(Paths.convert((Path)persistencePath));
        }
        return false;
    }

    public String buildJPAMarshallingStrategyValue(KieModule kieModule) {
        PersistenceDescriptorModel pdModel = this.pdService.load((Module)kieModule);
        if (pdModel != null) {
            return "new org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy(\"" + pdModel.getPersistenceUnit().getName() + "\", classLoader)";
        }
        return null;
    }

    public void addJPAMarshallingStrategy(DeploymentDescriptor dd, Path path) {
        KieModule kieModule = (KieModule)this.moduleService.resolveModule(path);
        String marshalingValue = null;
        if (kieModule != null && (marshalingValue = this.buildJPAMarshallingStrategyValue(kieModule)) != null) {
            ArrayList<ObjectModel> marshallingStrategies = new ArrayList<ObjectModel>();
            ObjectModel objectModel = new ObjectModel();
            objectModel.setResolver("mvel");
            objectModel.setIdentifier(marshalingValue);
            marshallingStrategies.add(objectModel);
            ((DeploymentDescriptorImpl)dd).setMarshallingStrategies(marshallingStrategies);
        }
    }
}

