/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.jbpm.workbench.ks.events.KieServerDataSetRegistered;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.ks.integration.event.ServerInstanceRegistered;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.common.rest.KieServerHttpRequestException;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.concurrent.Managed;

@ApplicationScoped
public class KieServerDataSetManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerDataSetManager.class);
    private ExecutorService executorService;
    private DataSetDefRegistry dataSetDefRegistry;
    private KieServerIntegration kieServerIntegration;
    private Event<KieServerDataSetRegistered> event;

    @Inject
    public KieServerDataSetManager(DataSetDefRegistry dataSetDefRegistry, KieServerIntegration kieServerIntegration, Event<KieServerDataSetRegistered> event, @Managed ExecutorService executorService) {
        this.dataSetDefRegistry = dataSetDefRegistry;
        this.kieServerIntegration = kieServerIntegration;
        this.event = event;
        this.executorService = executorService;
    }

    public void registerInKieServer(@Observes ServerInstanceRegistered serverInstanceRegistered) {
        ServerInstance serverInstance = serverInstanceRegistered.getServerInstance();
        String serverInstanceId = serverInstance.getServerInstanceId();
        String serverTemplateId = serverInstance.getServerTemplateId();
        LOGGER.info("Server instance '{}' connected, registering data sets", (Object)serverInstanceId);
        List dataSetDefs = this.dataSetDefRegistry.getDataSetDefs(false);
        LOGGER.debug("Found {} data sets to register", (Object)dataSetDefs.size());
        if (dataSetDefs.isEmpty()) {
            return;
        }
        this.executorService.execute(() -> {
            try {
                LOGGER.debug("Registering data set definitions on connected server instance '{}'", (Object)serverInstanceId);
                Set<QueryDefinition> queryDefinitions = dataSetDefs.stream().filter(dataSetDef -> dataSetDef.getProvider().getName().equals("REMOTE")).map(dataSetDef -> QueryDefinition.builder().name(dataSetDef.getUUID()).expression(((SQLDataSetDef)dataSetDef).getDbSQL()).source(((SQLDataSetDef)dataSetDef).getDataSource()).target(dataSetDef.getName().contains("-") ? dataSetDef.getName().substring(0, dataSetDef.getName().indexOf("-")) : "CUSTOM").build()).collect(Collectors.toSet());
                this.registerQueriesWithRetry(serverTemplateId, serverInstanceId, queryDefinitions);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to register query definition on '{}' due to {}", new Object[]{serverInstanceId, e.getMessage(), e});
            }
        });
    }

    protected void registerQueriesWithRetry(String serverTemplateId, String serverInstanceId, Set<QueryDefinition> queryDefinitions) throws Exception {
        long waitLimit = 300000L;
        long elapsed = 0L;
        try {
            QueryServicesClient queryClient = (QueryServicesClient)this.kieServerIntegration.getAdminServerClient(serverTemplateId, serverInstanceId).getServicesClient(QueryServicesClient.class);
            while (elapsed < waitLimit) {
                try {
                    Iterator<QueryDefinition> definitionIt = queryDefinitions.iterator();
                    while (definitionIt.hasNext()) {
                        QueryDefinition definition = definitionIt.next();
                        queryClient.replaceQuery(definition);
                        LOGGER.info("Query definition {} (type {}) successfully registered on kie server '{}'", new Object[]{definition.getName(), definition.getTarget(), serverInstanceId});
                        definitionIt.remove();
                    }
                    this.event.fire((Object)new KieServerDataSetRegistered(serverInstanceId, serverTemplateId));
                    return;
                }
                catch (KieServicesException | KieServerHttpRequestException e) {
                    Thread.sleep(500L);
                    queryClient = (QueryServicesClient)this.kieServerIntegration.getAdminServerClientCheckEndpoints(serverTemplateId).getServicesClient(QueryServicesClient.class);
                    LOGGER.debug("Cannot reach KIE Server, elapsed time while waiting '{}', max time '{}' error {}", new Object[]{elapsed += 500L, waitLimit, e.getMessage()});
                }
            }
            LOGGER.warn("Timeout while trying to register query definitions on '{}'", (Object)serverInstanceId);
        }
        catch (KieServicesException ex) {
            LOGGER.info("Not possible to register queries on server {} most likely due to BPM capability missing (details {})", (Object)serverInstanceId, (Object)ex.getMessage());
        }
    }
}

