/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.event.Event;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.ks.integration.event.ServerInstanceRegistered;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=Parameterized.class)
public class KieServerIntegrationServerTemplateTest {
    @Parameterized.Parameter(value=0)
    public String serverTemplateId1;
    @Parameterized.Parameter(value=1)
    public String serverTemplateId2;
    @Mock
    SpecManagementService specManagementService;
    @Mock
    KieServices kieServices;
    @Mock
    Event<ServerInstanceRegistered> serverInstanceRegisteredEvent;
    @InjectMocks
    KieServerIntegration kieServerIntegration;

    public static ContainerSpec newContainerSpec() {
        ContainerSpec spec = new ContainerSpec();
        spec.setId("id");
        spec.setContainerName("name");
        spec.setStatus(KieContainerStatus.STARTED);
        spec.setReleasedId(new ReleaseId("groupId", "artifactId", "1.0"));
        return spec;
    }

    @Parameterized.Parameters(name="Server Template 1: {0}, Server Template 2: {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"test-kie-server", "test-kie-server2"}, {"test-kie-server2", "test-kie-server"}, {"test-kie-server1", "test-kie-server2"}, {"test-kie-server2", "test-kie-server1"}, {"test-kie-server|", "test-kie-server"}, {"test-kie-server", "test-kie-server|"});
    }

    public static void assertServerInstanceFailedEndpoint(KieServerIntegration kieServerIntegration, ServerInstance serverInstance) {
        KieServicesClient serverClient = kieServerIntegration.getServerClient(serverInstance.getServerTemplateId());
        LoadBalancer loadBalancer = ((AbstractKieServicesClientImpl)serverClient).getLoadBalancer();
        Assert.assertTrue((boolean)loadBalancer.getFailedEndpoints().contains(serverInstance.getUrl()));
    }

    public static void assertContainerFailedEndpoint(KieServerIntegration kieServerIntegration, ServerInstance serverInstance, String containerId) {
        KieServicesClient serverClient = kieServerIntegration.getServerClient(serverInstance.getServerTemplateId(), containerId);
        LoadBalancer loadBalancer = ((AbstractKieServicesClientImpl)serverClient).getLoadBalancer();
        Assert.assertTrue((boolean)loadBalancer.getFailedEndpoints().contains(serverInstance.getUrl()));
    }

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.kieServices.newKieContainer((org.kie.api.builder.ReleaseId)Mockito.any())).thenReturn(Mockito.mock(KieContainer.class));
    }

    @Test
    public void testSimilarKieServerName() {
        String serverInstanceId1 = this.serverTemplateId1 + "@1";
        String serverInstanceId2 = this.serverTemplateId2 + "@1";
        ContainerSpec containerSpec = KieServerIntegrationServerTemplateTest.newContainerSpec();
        ServerInstance serverInstance1 = new ServerInstance();
        serverInstance1.setServerTemplateId(this.serverTemplateId1);
        serverInstance1.setUrl("http://1");
        serverInstance1.setServerInstanceId(serverInstanceId1);
        ServerTemplate serverTemplate1 = new ServerTemplate(this.serverTemplateId1, this.serverTemplateId1);
        serverTemplate1.addServerInstance((ServerInstanceKey)serverInstance1);
        serverTemplate1.addContainerSpec(containerSpec);
        ServerInstance serverInstance2 = new ServerInstance();
        serverInstance2.setServerTemplateId(this.serverTemplateId2);
        serverInstance2.setUrl("http://2");
        serverInstance2.setServerInstanceId(serverInstanceId2);
        ServerTemplate serverTemplate2 = new ServerTemplate(this.serverTemplateId2, this.serverTemplateId2);
        serverTemplate2.addServerInstance((ServerInstanceKey)serverInstance2);
        serverTemplate2.addContainerSpec(containerSpec);
        Mockito.when((Object)this.specManagementService.getServerTemplate(this.serverTemplateId1)).thenReturn((Object)serverTemplate1);
        Mockito.when((Object)this.specManagementService.getServerTemplate(this.serverTemplateId2)).thenReturn((Object)serverTemplate2);
        this.kieServerIntegration.onServerInstanceConnected(new ServerInstanceConnected(serverInstance2));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerTemplatesClients().get(this.serverTemplateId2));
        Assert.assertEquals((long)2L, (long)((Map)this.kieServerIntegration.getServerTemplatesClients().get(this.serverTemplateId2)).size());
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get(this.serverTemplateId2)).get("_SERVER_TEMPLATE_MAIN_CLIENT_"));
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get(this.serverTemplateId2)).get(containerSpec.getId()));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerInstancesById().get(serverInstanceId2));
        this.kieServerIntegration.onServerInstanceConnected(new ServerInstanceConnected(serverInstance1));
        Assert.assertEquals((long)2L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerTemplatesClients().get(this.serverTemplateId1));
        Assert.assertEquals((long)2L, (long)((Map)this.kieServerIntegration.getServerTemplatesClients().get(this.serverTemplateId1)).size());
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get(this.serverTemplateId1)).get("_SERVER_TEMPLATE_MAIN_CLIENT_"));
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get(this.serverTemplateId1)).get(containerSpec.getId()));
        Assert.assertEquals((long)2L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerInstancesById().get(serverInstanceId1));
        this.kieServerIntegration.onServerInstanceDisconnected(new ServerInstanceDisconnected(serverInstanceId1));
        Assert.assertEquals((long)2L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        KieServerIntegrationServerTemplateTest.assertServerInstanceFailedEndpoint(this.kieServerIntegration, serverInstance1);
        KieServerIntegrationServerTemplateTest.assertContainerFailedEndpoint(this.kieServerIntegration, serverInstance1, containerSpec.getId());
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNull(this.kieServerIntegration.getServerInstancesById().get(serverInstanceId1));
        Assert.assertNotNull(this.kieServerIntegration.getServerInstancesById().get(serverInstanceId2));
        this.kieServerIntegration.onServerInstanceDisconnected(new ServerInstanceDisconnected(serverInstanceId2));
        Assert.assertEquals((long)2L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        KieServerIntegrationServerTemplateTest.assertServerInstanceFailedEndpoint(this.kieServerIntegration, serverInstance2);
        KieServerIntegrationServerTemplateTest.assertContainerFailedEndpoint(this.kieServerIntegration, serverInstance2, containerSpec.getId());
        Assert.assertEquals((long)0L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNull(this.kieServerIntegration.getServerInstancesById().get(serverInstanceId1));
        Assert.assertNull(this.kieServerIntegration.getServerInstancesById().get(serverInstanceId2));
        this.kieServerIntegration.onServerTemplateDeleted(new ServerTemplateDeleted(this.serverTemplateId1));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        this.kieServerIntegration.onServerTemplateDeleted(new ServerTemplateDeleted(this.serverTemplateId2));
        Assert.assertEquals((long)0L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
    }
}

