/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.enterprise.event.Event;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.ks.integration.KieServerIntegrationServerTemplateTest;
import org.jbpm.workbench.ks.integration.event.ServerInstanceRegistered;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.impl.client.KieServicesClientProvider;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerIntegrationClientsTest {
    @Mock
    SpecManagementService specManagementService;
    @Mock
    KieServices kieServices;
    @Mock
    Event<ServerInstanceRegistered> serverInstanceRegisteredEvent;
    @Spy
    @InjectMocks
    KieServerIntegration kieServerIntegration;

    @Before
    public void setup() {
        Mockito.when((Object)this.kieServices.newKieContainer((ReleaseId)Mockito.any())).thenReturn(Mockito.mock(KieContainer.class));
    }

    @Test
    public void testServerTemplateClients() {
        String serverTemplateId = "kie-server-test";
        String serverInstanceId1 = "kie-server-test@1";
        String serverInstanceId2 = "kie-server-test@2";
        ContainerSpec containerSpec = KieServerIntegrationServerTemplateTest.newContainerSpec();
        ServerInstance serverInstance1 = new ServerInstance();
        serverInstance1.setServerTemplateId("kie-server-test");
        serverInstance1.setUrl("http://1");
        serverInstance1.setServerInstanceId("kie-server-test@1");
        ServerTemplate serverTemplate = new ServerTemplate("kie-server-test", "kie-server-test");
        serverTemplate.addContainerSpec(containerSpec);
        ServerInstance serverInstance2 = new ServerInstance();
        serverInstance2.setServerTemplateId("kie-server-test");
        serverInstance2.setUrl("http://2");
        serverInstance2.setServerInstanceId("kie-server-test@2");
        serverTemplate.addServerInstance((ServerInstanceKey)serverInstance2);
        Mockito.when((Object)this.specManagementService.getServerTemplate("kie-server-test")).thenReturn((Object)serverTemplate);
        this.kieServerIntegration.onServerInstanceConnected(new ServerInstanceConnected(serverInstance2));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test"));
        Assert.assertEquals((long)2L, (long)((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).size());
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).get("_SERVER_TEMPLATE_MAIN_CLIENT_"));
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).get(containerSpec.getId()));
        Assert.assertNotNull((Object)this.kieServerIntegration.getServerClient("kie-server-test", "not-existing"));
        Assert.assertEquals(((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).get("_SERVER_TEMPLATE_MAIN_CLIENT_"), (Object)this.kieServerIntegration.getServerClient("kie-server-test", "not-existing"));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@2"));
        serverTemplate.addServerInstance((ServerInstanceKey)serverInstance1);
        this.kieServerIntegration.onServerInstanceConnected(new ServerInstanceConnected(serverInstance1));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test"));
        Assert.assertEquals((long)2L, (long)((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).size());
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).get("_SERVER_TEMPLATE_MAIN_CLIENT_"));
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).get(containerSpec.getId()));
        Assert.assertEquals((long)2L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@1"));
        this.kieServerIntegration.onServerInstanceDisconnected(new ServerInstanceDisconnected("kie-server-test@1"));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        KieServerIntegrationServerTemplateTest.assertServerInstanceFailedEndpoint(this.kieServerIntegration, serverInstance1);
        KieServerIntegrationServerTemplateTest.assertContainerFailedEndpoint(this.kieServerIntegration, serverInstance1, containerSpec.getId());
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@1"));
        Assert.assertNotNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@2"));
        this.kieServerIntegration.onServerInstanceDisconnected(new ServerInstanceDisconnected("kie-server-test@2"));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        KieServerIntegrationServerTemplateTest.assertServerInstanceFailedEndpoint(this.kieServerIntegration, serverInstance2);
        KieServerIntegrationServerTemplateTest.assertContainerFailedEndpoint(this.kieServerIntegration, serverInstance2, containerSpec.getId());
        Assert.assertEquals((long)0L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@1"));
        Assert.assertNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@2"));
        this.kieServerIntegration.onServerTemplateDeleted(new ServerTemplateDeleted("kie-server-test"));
        Assert.assertEquals((long)0L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
    }

    @Test
    public void testCreateAvailableClients() throws Exception {
        String serverTemplateId = "kie-server-test";
        ServerTemplate serverTemplate = new ServerTemplate("kie-server-test", "kie-server-test");
        ContainerSpec containerSpec = KieServerIntegrationServerTemplateTest.newContainerSpec();
        serverTemplate.addContainerSpec(containerSpec);
        String serverInstanceId1 = "kie-server-test@1";
        ServerInstance serverInstance1 = new ServerInstance();
        serverInstance1.setServerTemplateId("kie-server-test");
        serverInstance1.setUrl("http://1");
        serverInstance1.setServerInstanceId("kie-server-test@1");
        serverTemplate.addServerInstance((ServerInstanceKey)serverInstance1);
        String serverInstanceId2 = "kie-server-test@2";
        ServerInstance serverInstance2 = new ServerInstance();
        serverInstance2.setServerTemplateId("kie-server-test");
        serverInstance2.setUrl("http://2");
        serverInstance2.setServerInstanceId("kie-server-test@2");
        serverTemplate.addServerInstance((ServerInstanceKey)serverInstance2);
        Mockito.when((Object)this.specManagementService.listServerTemplates()).thenReturn((Object)new ServerTemplateList(Collections.singletonList(serverTemplate)));
        CountDownLatch latch = new CountDownLatch(2);
        ((KieServerIntegration)Mockito.doAnswer(a -> {
            Object result = a.callRealMethod();
            latch.countDown();
            return result;
        }).when((Object)this.kieServerIntegration)).createClientForTemplate((ServerTemplate)Mockito.any(), (ClassLoader)Mockito.any(), (CredentialsProvider)Mockito.any());
        this.kieServerIntegration.createAvailableClients();
        Assert.assertTrue((String)"Clients not created within 10 seconds", (boolean)latch.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        Assert.assertNotNull((Object)this.kieServerIntegration.getServerClient("kie-server-test"));
        Assert.assertNotNull((Object)this.kieServerIntegration.getAdminServerClient("kie-server-test", "kie-server-test@1"));
        Assert.assertNotNull((Object)this.kieServerIntegration.getAdminServerClient("kie-server-test", "kie-server-test@2"));
    }

    @Test
    public void testBroadcastToKieServers() {
        String serverTemplateId = "kie-server-test";
        String serverInstanceId1 = "kie-server-test@1";
        String serverInstanceId2 = "kie-server-test@2";
        ServerInstance serverInstance1 = new ServerInstance();
        serverInstance1.setServerTemplateId("kie-server-test");
        serverInstance1.setUrl("http://1");
        serverInstance1.setServerInstanceId("kie-server-test@1");
        ServerTemplate serverTemplate = new ServerTemplate("kie-server-test", "kie-server-test");
        serverTemplate.addServerInstance((ServerInstanceKey)serverInstance1);
        ServerInstance serverInstance2 = new ServerInstance();
        serverInstance2.setServerTemplateId("kie-server-test");
        serverInstance2.setUrl("http://2");
        serverInstance2.setServerInstanceId("kie-server-test@2");
        serverTemplate.addServerInstance((ServerInstanceKey)serverInstance2);
        KieServicesClientProvider provider = (KieServicesClientProvider)Mockito.mock(KieServicesClientProvider.class);
        ArrayList<KieServicesClientProvider> providers = new ArrayList<KieServicesClientProvider>();
        providers.add(provider);
        this.kieServerIntegration.setKieServicesClientProviders(providers);
        Mockito.when((Object)provider.supports(Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)provider.get(Mockito.anyString())).thenReturn(Mockito.mock(KieServicesClient.class));
        Mockito.when((Object)this.specManagementService.getServerTemplate("kie-server-test")).thenReturn((Object)serverTemplate);
        Function operation = (Function)Mockito.mock(Function.class);
        this.kieServerIntegration.broadcastToKieServers("kie-server-test", operation);
        ((Function)Mockito.verify((Object)operation, (VerificationMode)Mockito.times((int)2))).apply(Mockito.any());
    }
}

