/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.impl.DataSetImpl;
import org.jbpm.workbench.ks.integration.ConsoleDataSetLookup;
import org.jbpm.workbench.ks.integration.KieServerDataSetProvider;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.QueryFilterSpec;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerDataSetProviderTest {
    public static String COLUMN_TEST = "columTest";
    @InjectMocks
    KieServerDataSetProvider kieServerDataSetProvider;
    @Mock
    KieServerIntegration kieServerIntegration;
    @Mock
    KieServicesClient kieServicesClient;
    @Mock
    QueryServicesClient queryServicesClient;
    @Mock
    DataSetImpl dataSet;
    @Mock
    DataSetDef dataSetDef;

    @Before
    public void setUp() {
        Mockito.when((Object)this.kieServerIntegration.getServerClient("servereTemplateId")).thenReturn((Object)this.kieServicesClient);
        Mockito.when((Object)this.kieServicesClient.getServicesClient(QueryServicesClient.class)).thenReturn((Object)this.queryServicesClient);
    }

    @Test
    public void appendEqualToIntervalSelectionTest() {
        String filterValue = "testValue";
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(new ColumnGroup(COLUMN_TEST, COLUMN_TEST, GroupStrategy.DYNAMIC));
        ArrayList<Interval> intervalList = new ArrayList<Interval>();
        Interval interval = new Interval(filterValue);
        intervalList.add(interval);
        dataSetGroup.setSelectedIntervalList(intervalList);
        ArrayList filterParams = new ArrayList();
        this.kieServerDataSetProvider.appendIntervalSelection(dataSetGroup, filterParams);
        Assert.assertEquals((long)1L, (long)filterParams.size());
        Assert.assertEquals((Object)COLUMN_TEST, (Object)((QueryParam)filterParams.get(0)).getColumn());
        Assert.assertEquals((Object)"EQUALS_TO", (Object)((QueryParam)filterParams.get(0)).getOperator());
        Assert.assertEquals((Object)filterValue, ((QueryParam)filterParams.get(0)).getValue().get(0));
    }

    @Test
    public void appendBetweenIntervalSelectionTest() {
        String filterValue = "testValue";
        Long minValue = 0L;
        Long maxValue = 2L;
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(new ColumnGroup(COLUMN_TEST, COLUMN_TEST, GroupStrategy.DYNAMIC));
        ArrayList<Interval> intervalList = new ArrayList<Interval>();
        Interval interval = new Interval(filterValue);
        interval.setMinValue((Object)minValue);
        interval.setMaxValue((Object)maxValue);
        intervalList.add(interval);
        dataSetGroup.setSelectedIntervalList(intervalList);
        ArrayList filterParams = new ArrayList();
        this.kieServerDataSetProvider.appendIntervalSelection(dataSetGroup, filterParams);
        Assert.assertEquals((long)1L, (long)filterParams.size());
        Assert.assertEquals((Object)COLUMN_TEST, (Object)((QueryParam)filterParams.get(0)).getColumn());
        Assert.assertEquals((Object)"BETWEEN", (Object)((QueryParam)filterParams.get(0)).getOperator());
        Assert.assertEquals((Object)minValue, ((QueryParam)filterParams.get(0)).getValue().get(0));
        Assert.assertEquals((Object)maxValue, ((QueryParam)filterParams.get(0)).getValue().get(1));
    }

    @Test
    public void lookupDataSetLogicalExprTest() throws Exception {
        DataSetLookup lookup = new DataSetLookup();
        lookup.setDataSetUUID("");
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"");
        ColumnFilter testFilter = FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.likeTo((String)"column1", (String)"%value%"), FilterFactory.likeTo((String)"column2", (String)"%value%")});
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{testFilter});
        lookup.addOperation(new DataSetOp[]{filter});
        this.kieServerDataSetProvider.lookupDataSet(this.dataSetDef, ConsoleDataSetLookup.fromInstance((DataSetLookup)lookup, (String)"servereTemplateId"));
        ArgumentCaptor captorEdit = ArgumentCaptor.forClass(QueryFilterSpec.class);
        ((QueryServicesClient)Mockito.verify((Object)this.queryServicesClient)).query(Matchers.anyString(), Matchers.anyString(), (QueryFilterSpec)captorEdit.capture(), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()), (Class)Matchers.any());
        Assert.assertNotNull((Object)captorEdit.getValue());
        QueryParam[] parameters = ((QueryFilterSpec)captorEdit.getValue()).getParameters();
        Assert.assertEquals((long)1L, (long)parameters.length);
        List expr = parameters[0].getValue();
        Assert.assertEquals((Object)"OR", (Object)parameters[0].getOperator());
        Assert.assertEquals((Object)"column1 like %value%, true", (Object)((CoreFunctionFilter)expr.get(0)).toString());
        Assert.assertEquals((Object)"column2 like %value%, true", (Object)((CoreFunctionFilter)expr.get(1)).toString());
    }

    @Test
    public void testGroupWithInterval() {
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(new ColumnGroup(COLUMN_TEST, COLUMN_TEST, GroupStrategy.DYNAMIC, 30, DateIntervalType.DAY.name()));
        ArrayList filterParams = new ArrayList();
        ArrayList extraColumns = new ArrayList();
        this.kieServerDataSetProvider.handleDataSetGroup(dataSetGroup, filterParams, extraColumns);
        Assert.assertEquals((long)1L, (long)filterParams.size());
        Assert.assertEquals((Object)COLUMN_TEST, (Object)((QueryParam)filterParams.get(0)).getColumn());
        Assert.assertEquals((Object)"group", (Object)((QueryParam)filterParams.get(0)).getOperator());
        Assert.assertEquals((long)3L, (long)((QueryParam)filterParams.get(0)).getValue().size());
        Assert.assertEquals((Object)COLUMN_TEST, ((QueryParam)filterParams.get(0)).getValue().get(0));
        Assert.assertEquals((Object)DateIntervalType.DAY.name(), ((QueryParam)filterParams.get(0)).getValue().get(1));
        Assert.assertEquals((Object)30, ((QueryParam)filterParams.get(0)).getValue().get(2));
    }

    @Test
    public void testGroupWithNotSetInterval() {
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(new ColumnGroup(COLUMN_TEST, COLUMN_TEST, GroupStrategy.DYNAMIC));
        ArrayList filterParams = new ArrayList();
        ArrayList extraColumns = new ArrayList();
        this.kieServerDataSetProvider.handleDataSetGroup(dataSetGroup, filterParams, extraColumns);
        Assert.assertEquals((long)1L, (long)filterParams.size());
        Assert.assertEquals((Object)COLUMN_TEST, (Object)((QueryParam)filterParams.get(0)).getColumn());
        Assert.assertEquals((Object)"group", (Object)((QueryParam)filterParams.get(0)).getOperator());
        Assert.assertEquals((long)1L, (long)((QueryParam)filterParams.get(0)).getValue().size());
        Assert.assertEquals((Object)COLUMN_TEST, ((QueryParam)filterParams.get(0)).getValue().get(0));
    }
}

