/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import org.jbpm.workbench.ks.integration.KieServerQueryDefinitionLoader;
import org.jbpm.workbench.ks.integration.event.QueryDefinitionLoaded;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.QueryDefinition;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerQueryDefinitionLoaderTest {
    private final Map<String, QueryDefinition> receivedEvents = new HashMap<String, QueryDefinition>();
    private static final int TOTAL_QUERY_DEFINITIONS_EXPECTED = 12;
    @Mock
    private Event<QueryDefinitionLoaded> event;
    @InjectMocks
    private KieServerQueryDefinitionLoader kieServerQueryDefinitionLoader;

    @Before
    public void setup() {
        MockitoAnnotations.openMocks((Object)this);
        ((Event)Mockito.doAnswer(invocation -> {
            QueryDefinitionLoaded queryDefinitionLoaded = (QueryDefinitionLoaded)invocation.getArgument(0);
            this.receivedEvents.put(queryDefinitionLoaded.getDefinition().getName(), queryDefinitionLoaded.getDefinition());
            return null;
        }).when(this.event)).fire(ArgumentMatchers.any(QueryDefinitionLoaded.class));
        this.kieServerQueryDefinitionLoader.init();
    }

    @Test
    public void testJbpmProcessInstances() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmProcessInstances").expression("select log.processInstanceId, log.processId, log.start_date, log.end_date, log.status, log.parentProcessInstanceId, log.outcome, log.duration, log.user_identity, log.processVersion, log.processName, log.correlationKey, log.externalId, log.processInstanceDescription, log.sla_due_date, log.slaCompliance, COALESCE(info.lastModificationDate, log.end_date) as lastModificationDate, (select COUNT(errInfo.id) from ExecutionErrorInfo errInfo where errInfo.PROCESS_INST_ID=log.processInstanceId and errInfo.ERROR_ACK=0) as errorCount from ProcessInstanceLog log left join ProcessInstanceInfo info on info.InstanceId=log.processInstanceId").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testJbpmProcessInstancesWithVariables() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmProcessInstancesWithVariables").expression("select vil.processInstanceId, vil.processId, vil.id, vil.variableId, vil.value from VariableInstanceLog vil left join VariableInstanceLog vil2 on vil.processInstanceId = vil2.processInstanceId and vil.variableId = vil2.variableId and vil.id < vil2.id where vil2.id is null").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testProcessesMonitoring() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("processesMonitoring").expression("select log.processInstanceId, log.processId, log.start_date, log.end_date, log.status, log.duration, log.user_identity, log.processVersion, log.processName, log.externalId from ProcessInstanceLog log").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testTasksMonitoring() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("tasksMonitoring").expression("select p.processName, p.externalId, t.taskId, t.taskName, t.status, t.createdDate, t.startDate, t.endDate, t.processInstanceId, t.userId, t.duration from ProcessInstanceLog p inner join BAMTaskSummary t on (t.processInstanceId = p.processInstanceId) inner join (select min(pk) as pk from BAMTaskSummary group by taskId) d on t.pk = d.pk").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testJbpmRequestList() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmRequestList").expression("select ri.id, ri.timestamp, ri.status, ri.commandName, ri.message, ri.businessKey, ri.retries, ri.executions, pil.processName, pil.processInstanceId, pil.processInstanceDescription, ri.deploymentId from RequestInfo ri left join ProcessInstanceLog pil on pil.processInstanceId=ri.processInstanceId").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testJbpmExecutionErrorList() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmExecutionErrorList").expression("select eri.ERROR_ACK, eri.ERROR_ACK_BY, eri.ERROR_ACK_AT, eri.ACTIVITY_ID, eri.ACTIVITY_NAME, eri.DEPLOYMENT_ID, eri.ERROR_DATE, eri.ERROR_ID, eri.ERROR_MSG, eri.JOB_ID, eri.PROCESS_ID, eri.PROCESS_INST_ID, eri.ERROR_TYPE from ExecutionErrorInfo eri").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testJbpmHumanTasks() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmHumanTasks").expression("select t.activationTime, t.actualOwner, t.createdBy, t.createdOn, t.deploymentId, t.description, t.dueDate, t.name, t.parentId, t.priority, t.processId, t.processInstanceId, t.processSessionId, t.status, t.taskId, t.workItemId, t.lastModificationDate, pil.correlationKey, pil.processInstanceDescription, nil.sla_due_date, nil.slaCompliance from AuditTaskImpl t left join ProcessInstanceLog pil on pil.processInstanceId=t.processInstanceId left join NodeInstanceLog nil on nil.workItemId=t.workItemId").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testJbpmHumanTasksWithUser() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmHumanTasksWithUser").expression("select t.activationTime, t.actualOwner, t.createdBy, t.createdOn, t.deploymentId, t.description, t.dueDate, t.name, t.parentId, t.priority, t.processId, t.processInstanceId, t.processSessionId, t.status, t.taskId, t.workItemId, t.lastModificationDate, pil.correlationKey, pil.processInstanceDescription , oe.id, eo.entity_id, nil.sla_due_date, nil.slaCompliance from AuditTaskImpl t left join PeopleAssignments_PotOwners po on t.taskId=po.task_id left join OrganizationalEntity oe on po.entity_id=oe.id left join ProcessInstanceLog pil on pil.processInstanceId=t.processInstanceId left join PeopleAssignments_ExclOwners eo on t.taskId=eo.task_id left join NodeInstanceLog nil on nil.workItemId=t.workItemId").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testJbpmHumanTasksWithAdmin() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmHumanTasksWithAdmin").expression("select t.activationTime, t.actualOwner, t.createdBy, t.createdOn, t.deploymentId, t.description, t.dueDate, t.name, t.parentId, t.priority, t.processId, t.processInstanceId, t.processSessionId, t.status, t.taskId, t.workItemId, t.lastModificationDate, pil.correlationKey, pil.processInstanceDescription ,oe.id, nil.sla_due_date, nil.slaCompliance, (select COUNT(errInfo.id) from ExecutionErrorInfo errInfo where errInfo.ACTIVITY_ID = t.taskId and errInfo.PROCESS_INST_ID = pil.processInstanceId and errInfo.ERROR_ACK = 0 and errInfo.ERROR_TYPE = 'Task') as errorCount from AuditTaskImpl t  left join ProcessInstanceLog pil on pil.processInstanceId = t.processInstanceId left join PeopleAssignments_BAs ba on t.taskId = ba.task_id left join OrganizationalEntity oe on ba.entity_id = oe.id left join NodeInstanceLog nil on nil.workItemId=t.workItemId").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testJbpmHumanTasksWithAdminExtended() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmHumanTasksWithAdminExtended").expression("select t.activationTime, t.actualOwner, t.createdBy, t.createdOn, t.deploymentId, t.description, t.dueDate, t.name, t.parentId, t.priority, t.processId, t.processInstanceId, t.processSessionId, t.status, t.taskId, t.workItemId, t.lastModificationDate, pil.correlationKey, pil.processInstanceDescription ,oe.id, nil.sla_due_date, nil.slaCompliance,(select COUNT(errInfo.id) from ExecutionErrorInfo errInfo where errInfo.ACTIVITY_ID = t.taskId and errInfo.PROCESS_INST_ID = pil.processInstanceId and errInfo.ERROR_ACK = 0 and errInfo.ERROR_TYPE = 'Task') as errorCount, i18n.text  as subject, i18n.language as language, task.formname as formname, (SELECT te1.userId FROM taskEvent te1 LEFT JOIN taskEvent te2 ON te1.id < te2.id WHERE te2.id IS NULL) as lastUser from AuditTaskImpl t  left join ProcessInstanceLog pil on pil.processInstanceId = t.processInstanceId left join PeopleAssignments_BAs ba on t.taskId = ba.task_id left join OrganizationalEntity oe on ba.entity_id = oe.id left join NodeInstanceLog nil on nil.workItemId=t.workItemId left join Task task on task.id = t.taskId left join I18NText i18n ON i18n.Task_Subjects_Id = t.taskId").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testJbpmHumanTasksWithVariables() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmHumanTasksWithVariables").expression("select tvi.taskId, tvi.name, tvi.value from TaskVariableImpl tvi").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testJbpmProcessInstanceLogs() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmProcessInstanceLogs").expression("select log.id, log.nodeId, log.nodeName, log.nodeType, log.externalId, log.processInstanceId, log.log_date, log.connection, log.type, log.workItemId, log.referenceId, log.nodeContainerId, log.sla_due_date, log.slaCompliance from NodeInstanceLog log ").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testNonExistingQueryDefinition() {
        QueryDefinition nonExistingQuery = QueryDefinition.builder().name("nonExistingQueryDefinition").expression("a fake query").build();
        Assert.assertTrue((String)"No named-queries were found", (this.receivedEvents.size() > 0 ? 1 : 0) != 0);
        Assert.assertNull((String)nonExistingQuery.getName(), (Object)this.receivedEvents.get(nonExistingQuery.getName()));
    }

    @Test
    public void testNonMatchingQueryDefinition() {
        QueryDefinition nonMatchingQuery = QueryDefinition.builder().name("jbpmProcessInstancesWithVariables").expression("select vil.processInstanceId, vil.processId, vil.id, vil.variableId, vil.value from VariableInstanceLog vil left join VariableInstanceLog vil2 on vil.processInstanceId = vil2.processInstanceId ").build();
        Assert.assertTrue((String)"No named-queries were found", (this.receivedEvents.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)("No query definition found for " + nonMatchingQuery.getName()), (Object)this.receivedEvents.get(nonMatchingQuery.getName()));
        Assert.assertNotEquals((Object)nonMatchingQuery.getExpression(), (Object)this.receivedEvents.get(nonMatchingQuery.getName()).getExpression());
    }

    @Test
    public void testTotalQueryDefinitionsLoaded() {
        Assert.assertEquals((String)("Number of QueryDefinitions loaded (" + this.receivedEvents.size() + ") does not match with expected (" + 12 + ")"), (long)12L, (long)this.receivedEvents.size());
    }

    private void testQueryDefinitionLoaded(QueryDefinition expectedQueryDefinition) {
        Assert.assertTrue((String)"No named-queries were found", (this.receivedEvents.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)("No query definition found for " + expectedQueryDefinition.getName()), (Object)this.receivedEvents.get(expectedQueryDefinition.getName()));
        Assert.assertEquals((Object)expectedQueryDefinition.getExpression(), (Object)this.receivedEvents.get(expectedQueryDefinition.getName()).getExpression());
    }
}

