/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.Arrays;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.jbpm.workbench.ks.integration.DateColumnFilterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DateColumnFilterFactoryTest {
    private ColumnGroup cg;

    @Before
    public void prepare() {
        this.cg = new ColumnGroup("test", "test");
    }

    @Test
    public void testDateColumnFilterFactorySecond() {
        this.cg.setIntervalSize(DateIntervalType.SECOND.name());
        CoreFunctionFilter filter = (CoreFunctionFilter)DateColumnFilterFactory.createFilter((ColumnGroup)this.cg, Arrays.asList("2023-10-01 01:01:01", "2023-11-02 02:02:02"));
        Assert.assertEquals((Object)"test", (Object)filter.getColumnId());
        Assert.assertEquals((Object)"2023-10-01 01:01:01", filter.getParameters().get(0));
        Assert.assertEquals((Object)"2023-11-02 02:02:02", filter.getParameters().get(1));
    }

    @Test
    public void testDateColumnFilterFactoryMinute() {
        this.cg.setIntervalSize(DateIntervalType.MINUTE.name());
        CoreFunctionFilter filter = (CoreFunctionFilter)DateColumnFilterFactory.createFilter((ColumnGroup)this.cg, Arrays.asList("2023-10-01 01:01", "2023-11-02 02:02"));
        Assert.assertEquals((Object)"test", (Object)filter.getColumnId());
        Assert.assertEquals((Object)"2023-10-01 01:01:00", filter.getParameters().get(0));
        Assert.assertEquals((Object)"2023-11-02 02:03:00", filter.getParameters().get(1));
    }

    @Test
    public void testDateColumnFilterFactoryHour() {
        this.cg.setIntervalSize(DateIntervalType.HOUR.name());
        CoreFunctionFilter filter = (CoreFunctionFilter)DateColumnFilterFactory.createFilter((ColumnGroup)this.cg, Arrays.asList("2023-10-01 01", "2023-11-02 02"));
        Assert.assertEquals((Object)"test", (Object)filter.getColumnId());
        Assert.assertEquals((Object)"2023-10-01 01:00:00", filter.getParameters().get(0));
        Assert.assertEquals((Object)"2023-11-02 03:00:00", filter.getParameters().get(1));
    }

    @Test
    public void testDateColumnFilterFactoryDay() {
        this.cg.setIntervalSize(DateIntervalType.DAY.name());
        CoreFunctionFilter filter = (CoreFunctionFilter)DateColumnFilterFactory.createFilter((ColumnGroup)this.cg, Arrays.asList("2023-10-01", "2023-11-02"));
        Assert.assertEquals((Object)"test", (Object)filter.getColumnId());
        Assert.assertEquals((Object)"2023-10-01 00:00:00", filter.getParameters().get(0));
        Assert.assertEquals((Object)"2023-11-03 00:00:00", filter.getParameters().get(1));
    }

    @Test
    public void testDateColumnFilterFactoryDayOrder() {
        this.cg.setIntervalSize(DateIntervalType.DAY.name());
        CoreFunctionFilter filter = (CoreFunctionFilter)DateColumnFilterFactory.createFilter((ColumnGroup)this.cg, Arrays.asList("2023-11-02", "2023-10-01"));
        Assert.assertEquals((Object)"test", (Object)filter.getColumnId());
        Assert.assertEquals((Object)"2023-10-01 00:00:00", filter.getParameters().get(0));
        Assert.assertEquals((Object)"2023-11-03 00:00:00", filter.getParameters().get(1));
    }

    @Test
    public void testDateColumnFilterFactoryDayEqualsValue() {
        this.cg.setIntervalSize(DateIntervalType.DAY.name());
        CoreFunctionFilter filter = (CoreFunctionFilter)DateColumnFilterFactory.createFilter((ColumnGroup)this.cg, Arrays.asList("2023-10-01", "2023-10-01"));
        Assert.assertEquals((Object)"test", (Object)filter.getColumnId());
        Assert.assertEquals((Object)"2023-10-01 00:00:00", filter.getParameters().get(0));
        Assert.assertEquals((Object)"2023-10-02 00:00:00", filter.getParameters().get(1));
    }

    @Test
    public void testDateColumnFilterFactoryMonth() {
        this.cg.setIntervalSize(DateIntervalType.MONTH.name());
        CoreFunctionFilter filter = (CoreFunctionFilter)DateColumnFilterFactory.createFilter((ColumnGroup)this.cg, Arrays.asList("2023-10", "2023-11"));
        Assert.assertEquals((Object)"test", (Object)filter.getColumnId());
        Assert.assertEquals((Object)"2023-10-01 00:00:00", filter.getParameters().get(0));
        Assert.assertEquals((Object)"2023-12-01 00:00:00", filter.getParameters().get(1));
    }

    @Test
    public void testDateColumnFilterFactoryYear() {
        this.cg.setIntervalSize(DateIntervalType.YEAR.name());
        CoreFunctionFilter filter = (CoreFunctionFilter)DateColumnFilterFactory.createFilter((ColumnGroup)this.cg, Arrays.asList("2023", "2024"));
        Assert.assertEquals((Object)"test", (Object)filter.getColumnId());
        Assert.assertEquals((Object)"2023-01-01 00:00:00", filter.getParameters().get(0));
        Assert.assertEquals((Object)"2025-01-01 00:00:00", filter.getParameters().get(1));
    }
}

