/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import org.jbpm.workbench.ks.integration.KieServerQueryDefinitionLoader;
import org.jbpm.workbench.ks.integration.event.QueryDefinitionLoaded;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.QueryDefinition;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerQueryDefinitionLoaderStrictModeTest {
    private final Map<String, QueryDefinition> receivedEvents = new HashMap<String, QueryDefinition>();
    private static final int TOTAL_QUERY_DEFINITIONS_EXPECTED = 12;
    @Mock
    private Event<QueryDefinitionLoaded> event;
    @InjectMocks
    private KieServerQueryDefinitionLoader kieServerQueryDefinitionLoader;

    @Before
    public void setup() {
        MockitoAnnotations.openMocks((Object)this);
        ((Event)Mockito.doAnswer(invocation -> {
            QueryDefinitionLoaded queryDefinitionLoaded = (QueryDefinitionLoaded)invocation.getArgument(0);
            this.receivedEvents.put(queryDefinitionLoaded.getDefinition().getName(), queryDefinitionLoaded.getDefinition());
            return null;
        }).when(this.event)).fire((Object)((QueryDefinitionLoaded)ArgumentMatchers.any(QueryDefinitionLoaded.class)));
        this.kieServerQueryDefinitionLoader.init((Map)new HashMap<String, String>(){
            {
                this.put("jbpm.wb.querymode", "STRICT");
            }
        });
    }

    @Test
    public void testJbpmProcessInstances() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("jbpmProcessInstances").expression("SELECT LOG.PROCESSINSTANCEID, LOG.PROCESSID, LOG.START_DATE, LOG.END_DATE, LOG.STATUS, LOG.PARENTPROCESSINSTANCEID, LOG.OUTCOME, LOG.DURATION, LOG.USER_IDENTITY, LOG.PROCESSVERSION, LOG.PROCESSNAME, LOG.CORRELATIONKEY, LOG.EXTERNALID, LOG.PROCESSINSTANCEDESCRIPTION, LOG.SLA_DUE_DATE, LOG.SLACOMPLIANCE, COALESCE ( INFO.LASTMODIFICATIONDATE, LOG.END_DATE ) AS LASTMODIFICATIONDATE, COUNT( ERRINFO.ID ) ERRORCOUNT FROM ProcessInstanceLog LOG LEFT JOIN ExecutionErrorInfo ERRINFO ON ERRINFO.PROCESS_INST_ID=LOG.PROCESSINSTANCEID AND ERRINFO.ERROR_ACK=0 LEFT JOIN ProcessInstanceInfo INFO ON INFO.INSTANCEID=LOG.PROCESSINSTANCEID GROUP BY LOG.PROCESSINSTANCEID, LOG.PROCESSID, LOG.START_DATE, LOG.END_DATE, LOG.STATUS, LOG.PARENTPROCESSINSTANCEID, LOG.OUTCOME, LOG.DURATION, LOG.USER_IDENTITY, LOG.PROCESSVERSION, LOG.PROCESSNAME, LOG.CORRELATIONKEY, LOG.EXTERNALID, LOG.PROCESSINSTANCEDESCRIPTION, LOG.SLA_DUE_DATE, LOG.SLACOMPLIANCE, COALESCE ( INFO.LASTMODIFICATIONDATE, LOG.END_DATE )").target("FILTERED_PROCESS").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testProcessesMonitoring() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("processesMonitoring").expression("select log.processInstanceId, log.processId, log.start_date, log.end_date, log.status, log.duration, log.user_identity, log.processVersion, log.processName, log.externalId from ProcessInstanceLog log").target("FILTERED_PROCESS").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    @Test
    public void testTasksMonitoring() {
        QueryDefinition expectedQuery = QueryDefinition.builder().name("tasksMonitoring").expression("select p.processName, p.externalId, t.taskId, t.taskName, t.status, t.createdDate, t.startDate, t.endDate, t.processInstanceId, t.userId, t.duration from ProcessInstanceLog p inner join BAMTaskSummary t on (t.processInstanceId = p.processInstanceId) inner join (select min(pk) as pk from BAMTaskSummary group by taskId) d on t.pk = d.pk").target("FILTERED_PROCESS").build();
        this.testQueryDefinitionLoaded(expectedQuery);
    }

    private void testQueryDefinitionLoaded(QueryDefinition expectedQueryDefinition) {
        Assert.assertTrue((String)"No named-queries were found", (this.receivedEvents.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)("No query definition found for " + expectedQueryDefinition.getName()), (Object)this.receivedEvents.get(expectedQueryDefinition.getName()));
        Assert.assertEquals((Object)expectedQueryDefinition.getExpression(), (Object)this.receivedEvents.get(expectedQueryDefinition.getName()).getExpression());
        Assert.assertEquals((Object)expectedQueryDefinition.getTarget(), (Object)this.receivedEvents.get(expectedQueryDefinition.getName()).getTarget());
    }
}

