/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.Map;
import javax.enterprise.event.Event;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.ks.integration.KieServerIntegrationServerTemplateTest;
import org.jbpm.workbench.ks.integration.event.ServerInstanceRegistered;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerIntegrationClientsTest {
    @Mock
    SpecManagementService specManagementService;
    @Mock
    KieServices kieServices;
    @Mock
    Event<ServerInstanceRegistered> serverInstanceRegisteredEvent;
    @InjectMocks
    KieServerIntegration kieServerIntegration;

    @Before
    public void setup() {
        Mockito.when((Object)this.kieServices.newKieContainer((ReleaseId)Mockito.any())).thenReturn(Mockito.mock(KieContainer.class));
    }

    @Test
    public void testServerTemplateClients() {
        String serverTemplateId = "kie-server-test";
        String serverInstanceId1 = "kie-server-test@1";
        String serverInstanceId2 = "kie-server-test@2";
        ContainerSpec containerSpec = KieServerIntegrationServerTemplateTest.newContainerSpec();
        ServerInstance serverInstance1 = new ServerInstance();
        serverInstance1.setServerTemplateId("kie-server-test");
        serverInstance1.setUrl("http://1");
        serverInstance1.setServerInstanceId("kie-server-test@1");
        ServerTemplate serverTemplate = new ServerTemplate("kie-server-test", "kie-server-test");
        serverTemplate.addContainerSpec(containerSpec);
        ServerInstance serverInstance2 = new ServerInstance();
        serverInstance2.setServerTemplateId("kie-server-test");
        serverInstance2.setUrl("http://2");
        serverInstance2.setServerInstanceId("kie-server-test@2");
        serverTemplate.addServerInstance((ServerInstanceKey)serverInstance2);
        Mockito.when((Object)this.specManagementService.getServerTemplate("kie-server-test")).thenReturn((Object)serverTemplate);
        this.kieServerIntegration.onServerInstanceConnected(new ServerInstanceConnected(serverInstance2));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test"));
        Assert.assertEquals((long)2L, (long)((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).size());
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).get("_SERVER_TEMPLATE_MAIN_CLIENT_"));
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).get(containerSpec.getId()));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@2"));
        serverTemplate.addServerInstance((ServerInstanceKey)serverInstance1);
        this.kieServerIntegration.onServerInstanceConnected(new ServerInstanceConnected(serverInstance1));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test"));
        Assert.assertEquals((long)2L, (long)((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).size());
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).get("_SERVER_TEMPLATE_MAIN_CLIENT_"));
        Assert.assertNotNull(((Map)this.kieServerIntegration.getServerTemplatesClients().get("kie-server-test")).get(containerSpec.getId()));
        Assert.assertEquals((long)2L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNotNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@1"));
        this.kieServerIntegration.onServerInstanceDisconnected(new ServerInstanceDisconnected("kie-server-test@1"));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        KieServerIntegrationServerTemplateTest.assertServerInstanceFailedEndpoint(this.kieServerIntegration, serverInstance1);
        KieServerIntegrationServerTemplateTest.assertContainerFailedEndpoint(this.kieServerIntegration, serverInstance1, containerSpec.getId());
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@1"));
        Assert.assertNotNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@2"));
        this.kieServerIntegration.onServerInstanceDisconnected(new ServerInstanceDisconnected("kie-server-test@2"));
        Assert.assertEquals((long)1L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
        KieServerIntegrationServerTemplateTest.assertServerInstanceFailedEndpoint(this.kieServerIntegration, serverInstance2);
        KieServerIntegrationServerTemplateTest.assertContainerFailedEndpoint(this.kieServerIntegration, serverInstance2, containerSpec.getId());
        Assert.assertEquals((long)0L, (long)this.kieServerIntegration.getServerInstancesById().size());
        Assert.assertNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@1"));
        Assert.assertNull(this.kieServerIntegration.getServerInstancesById().get("kie-server-test@2"));
        this.kieServerIntegration.onServerTemplateDeleted(new ServerTemplateDeleted("kie-server-test"));
        Assert.assertEquals((long)0L, (long)this.kieServerIntegration.getServerTemplatesClients().size());
    }
}

