/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.Arrays;
import java.util.List;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.jbpm.workbench.pr.backend.server.DataSetDefsBootstrap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.internal.identity.IdentityProvider;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetDefsBootstrapTest {
    @Mock
    IdentityProvider identityProvider;
    @Spy
    DataSetDefRegistry dataSetRegistry = DataSetCore.get().getDataSetDefRegistry();
    @Spy
    DataSetManager dataSetManager = DataSetCore.get().getDataSetManager();
    @InjectMocks
    DataSetDefsBootstrap dataSetsBootstrap;
    List<String> deploymentIds = Arrays.asList("role1", "role2");

    @Before
    public void setUp() {
        this.dataSetsBootstrap.registerDataSetDefinitions();
    }

    @Test
    public void registerDataSetDefsTest() {
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetRegistry, (VerificationMode)Mockito.times((int)2))).registerDataSetDef((DataSetDef)argument.capture());
        List dataSetDefList = argument.getAllValues();
        Assert.assertEquals((long)dataSetDefList.size(), (long)2L);
        Assert.assertEquals((Object)((DataSetDef)dataSetDefList.get(0)).getUUID(), (Object)"jbpmProcessInstances");
        Assert.assertEquals((Object)((DataSetDef)dataSetDefList.get(1)).getUUID(), (Object)"jbpmProcessInstancesWithVariables");
    }

    @Ignore
    public void procInstancesPreprocessorTest() {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("jbpmProcessInstances")).buildLookup();
        this.dataSetManager.lookupDataSet(lookup);
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetLookup.class);
        ((DataSetManager)Mockito.verify((Object)this.dataSetManager)).lookupDataSet((DataSetLookup)argument.capture());
        Assert.assertEquals((Object)argument.getValue(), (Object)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("jbpmProcessInstances")).filter(new ColumnFilter[]{FilterFactory.in((String)"externalId", this.deploymentIds)})).buildLookup());
    }
}

