/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.common.model.QueryFilter;
import org.jbpm.workbench.ks.integration.AbstractKieServerService;
import org.jbpm.workbench.pr.backend.server.model.VariableHelper;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.jbpm.workbench.pr.service.ProcessVariablesService;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.api.model.definition.VariablesDefinition;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class RemoteProcessVariablesServiceImpl
extends AbstractKieServerService
implements ProcessVariablesService {
    public PageResponse<ProcessVariableSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List<ProcessVariableSummary> processVariablesSums = this.getProcessVariables(filter);
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(processVariablesSums.size() - 1);
        if (processVariablesSums.size() > filter.getCount()) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        response.setTotalRowSizeExact(true);
        response.setTotalRowSize(processVariablesSums.size());
        if (!processVariablesSums.isEmpty()) {
            if (processVariablesSums.size() > filter.getCount() + filter.getOffset()) {
                response.setPageRowList(new ArrayList<ProcessVariableSummary>(processVariablesSums.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
                response.setLastPage(false);
            } else {
                response.setPageRowList(new ArrayList<ProcessVariableSummary>(processVariablesSums.subList(filter.getOffset(), processVariablesSums.size())));
                response.setLastPage(true);
            }
        } else {
            response.setPageRowList(new ArrayList<ProcessVariableSummary>(processVariablesSums));
            response.setLastPage(true);
        }
        return response;
    }

    protected List<ProcessVariableSummary> getProcessVariables(QueryFilter filter) {
        Long processInstanceId = null;
        String processId = "";
        String deploymentId = "";
        String serverTemplateId = "";
        if (filter.getParams() != null) {
            processInstanceId = Long.valueOf((String)filter.getParams().get("processInstanceId"));
            processId = (String)filter.getParams().get("processDefId");
            deploymentId = (String)filter.getParams().get("deploymentId");
            serverTemplateId = (String)filter.getParams().get("serverTemplateId");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        QueryServicesClient queryServicesClient = (QueryServicesClient)this.getClient(serverTemplateId, QueryServicesClient.class);
        ProcessServicesClient processClient = (ProcessServicesClient)this.getClient(serverTemplateId, ProcessServicesClient.class);
        try {
            VariablesDefinition vars = processClient.getProcessVariableDefinitions(deploymentId, processId);
            properties.putAll(vars.getVariables());
        }
        catch (KieServicesHttpException vars) {
            // empty catch block
        }
        List variables = queryServicesClient.findVariablesCurrentState(processInstanceId);
        List<ProcessVariableSummary> processVariables = VariableHelper.adaptCollection(variables, properties, processInstanceId, deploymentId, serverTemplateId);
        ArrayList<ProcessVariableSummary> processVariablesSums = new ArrayList<ProcessVariableSummary>(processVariables.size());
        for (ProcessVariableSummary pv : processVariables) {
            if (filter.getParams().get("textSearch") == null || ((String)filter.getParams().get("textSearch")).isEmpty()) {
                processVariablesSums.add(pv);
                continue;
            }
            if (!pv.getVariableId().toLowerCase().contains((String)filter.getParams().get("textSearch"))) continue;
            processVariablesSums.add(pv);
        }
        return processVariablesSums;
    }

    public List<ProcessVariableSummary> getVariableHistory(String serverTemplateId, String deploymentId, Long processInstanceId, String variableName) {
        QueryServicesClient processClient = (QueryServicesClient)this.getClient(serverTemplateId, QueryServicesClient.class);
        List variables = processClient.findVariableHistory(processInstanceId, variableName, Integer.valueOf(0), Integer.valueOf(100));
        return VariableHelper.adaptCollection(variables, new HashMap<String, String>(), processInstanceId, deploymentId, serverTemplateId);
    }
}

