/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.pr.backend.server.RemoteProcessImageServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.UIServicesClient;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteProcessImageServiceImplTest {
    private static final String SVG_WITH_ACTIONS = "<svg><g><text font-size=\"12\" id=\"_5D35D92A-455D-408D-9BF3-4D6C25D6B64D\" style=\"stroke-width:1;fill:rgb(177,194,214);font-family:arial;font-weight:bold\" transform=\"translate(10, 20)\" onmouseover=\"ORYX.Plugins.CanvasTitle.addToolTip('_5D35D92A-455D-408D-9BF3-4D6C25D6B64D')\" onclick=\"ORYX.Plugins.CanvasTitle.openTextualAnalysis()\">Evaluation v.1 (evaluation)</text></g></svg>";
    private static final String SVG_WITHOUT_ACTIONS = "<svg><g><text font-size=\"12\" id=\"_5D35D92A-455D-408D-9BF3-4D6C25D6B64D\" style=\"stroke-width:1;fill:rgb(177,194,214);font-family:arial;font-weight:bold\" transform=\"translate(10, 20)\"  >Evaluation v.1 (evaluation)</text></g></svg>";
    private static final String SVG_WITH_LINK = "<svg><a onclick=\"parent.designeropenintab(&quot;place-order.bpmn2&quot;,&quot;default://master@myrepo/itorders/src/main/resources/org/jbpm/demo/itorders/place-order.bpmn2&quot;);\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:href=\"\" xlink:type=\"simple\" xlink:actuate=\"onRequest\" id=\"_646D12C5-DE96-4300-B822-EC8C77253514pimg\" xlink:show=\"replace\"></svg>";
    private static final String SVG_WITHOUT_LINK = "<svg><a  xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:href=\"\" xlink:type=\"simple\" xlink:actuate=\"onRequest\" id=\"_646D12C5-DE96-4300-B822-EC8C77253514pimg\" xlink:show=\"replace\"></svg>";
    @Mock
    KieServerIntegration kieServerIntegration;
    @Mock
    UIServicesClient uiServicesClient;
    @InjectMocks
    RemoteProcessImageServiceImpl service;

    private static void validateHTMLContent(String html) {
        Assert.assertFalse((boolean)html.contains("onclick"));
        Assert.assertFalse((boolean)html.contains("onmouseover"));
        Assert.assertEquals((Object)SVG_WITHOUT_ACTIONS, (Object)html);
    }

    @Before
    public void setup() {
        KieServicesClient servicesClient = (KieServicesClient)Mockito.mock(KieServicesClient.class);
        Mockito.when((Object)servicesClient.getServicesClient(UIServicesClient.class)).thenReturn((Object)this.uiServicesClient);
        Mockito.when((Object)this.kieServerIntegration.getServerClient("", "")).thenReturn((Object)servicesClient);
    }

    @Test
    public void testProcessDiagramHTML() {
        Mockito.when((Object)this.uiServicesClient.getProcessImage("", "")).thenReturn((Object)SVG_WITH_ACTIONS, (Object[])new String[]{SVG_WITHOUT_ACTIONS});
        RemoteProcessImageServiceImplTest.validateHTMLContent(this.service.getProcessDiagram("", "", ""));
        RemoteProcessImageServiceImplTest.validateHTMLContent(this.service.getProcessDiagram("", "", ""));
    }

    @Test
    public void testProcessInstanceImageHTML() {
        Mockito.when((Object)this.uiServicesClient.getProcessInstanceImage("", null)).thenReturn((Object)SVG_WITH_ACTIONS, (Object[])new String[]{SVG_WITHOUT_ACTIONS});
        RemoteProcessImageServiceImplTest.validateHTMLContent(this.service.getProcessInstanceDiagram("", "", null));
        RemoteProcessImageServiceImplTest.validateHTMLContent(this.service.getProcessInstanceDiagram("", "", null));
    }

    @Test
    public void testImageWithLink() {
        Mockito.when((Object)this.uiServicesClient.getProcessInstanceImage("", null)).thenReturn((Object)SVG_WITH_LINK);
        String diagram = this.service.getProcessInstanceDiagram("", "", null);
        Assert.assertFalse((boolean)diagram.contains("onclick"));
        Assert.assertEquals((Object)SVG_WITHOUT_LINK, (Object)diagram);
    }

    @Test
    public void testProcessInstanceImageNotFound() {
        Integer okCode = 400;
        Mockito.when((Object)this.uiServicesClient.getProcessInstanceImage("", null)).thenThrow(new Throwable[]{new KieServicesHttpException(null, Integer.valueOf(404), null, null), new KieServicesHttpException(null, okCode, null, null)});
        Assert.assertNull((Object)this.service.getProcessInstanceDiagram("", "", null));
        try {
            this.service.getProcessInstanceDiagram("", "", null);
            Assert.fail((String)"Method should throw exception");
        }
        catch (KieServicesHttpException ex) {
            Assert.assertEquals((Object)okCode, (Object)ex.getHttpCode());
        }
    }

    @Test
    public void testProcessImageNotFound() {
        Integer okCode = 400;
        Mockito.when((Object)this.uiServicesClient.getProcessImage("", null)).thenThrow(new Throwable[]{new KieServicesHttpException(null, Integer.valueOf(404), null, null), new KieServicesHttpException(null, okCode, null, null)});
        Assert.assertNull((Object)this.service.getProcessDiagram("", "", null));
        try {
            this.service.getProcessDiagram("", "", null);
            Assert.fail((String)"Method should throw exception");
        }
        catch (KieServicesHttpException ex) {
            Assert.assertEquals((Object)okCode, (Object)ex.getHttpCode());
        }
    }
}

