/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server.util;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.jbpm.workbench.pr.backend.server.util.VariableHelper;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.kie.server.api.model.instance.VariableInstance;

public class DocumentsVariableProcessor
implements VariableHelper.VariableProcessor {
    private static final String PATTERN_SUFFIX = "+\\s\\(\\d+/\\d+\\)";
    private String type;

    public DocumentsVariableProcessor(String type) {
        this.type = type;
    }

    @Override
    public void process(long processInstanceId, String varName, String varType, List<VariableInstance> variables, Consumer<ProcessVariableSummary> consumer) {
        String patternString = varName + PATTERN_SUFFIX;
        Iterator<VariableInstance> it = variables.iterator();
        while (it.hasNext()) {
            VariableInstance var = it.next();
            if (!var.getVariableName().matches(patternString)) continue;
            consumer.accept(new ProcessVariableSummary(var.getVariableName(), var.getVariableName(), var.getProcessInstanceId().longValue(), var.getOldValue(), var.getValue(), var.getDate().getTime(), "org.jbpm.document.Document"));
            it.remove();
        }
    }

    @Override
    public String getSupportedType() {
        return this.type;
    }
}

