/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.stream.IntStream;
import org.jbpm.workbench.common.model.PortableQueryFilter;
import org.jbpm.workbench.common.model.QueryFilter;
import org.jbpm.workbench.pr.backend.server.RemoteProcessDocumentsServiceImpl;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.jbpm.workbench.pr.service.ProcessVariablesService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.paging.PageResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteProcessDocumentsServiceImplTest {
    private final String serverTemplateId = "serverTemplateId";
    @Mock
    private ProcessVariablesService processVariablesService;
    @InjectMocks
    private RemoteProcessDocumentsServiceImpl processDocumentsService;

    private static ProcessVariableSummary newDocumentVariable() {
        return new ProcessVariableSummary("", "", 1L, "", "docId####1####" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "####" + "1", 0L, "org.jbpm.document.Document");
    }

    @Test
    public void testGetData() {
        PageResponse variablesResponse = new PageResponse();
        variablesResponse.setPageRowList(Collections.singletonList(RemoteProcessDocumentsServiceImplTest.newDocumentVariable()));
        Mockito.when((Object)this.processVariablesService.getData((QueryFilter)Mockito.any())).thenReturn((Object)variablesResponse);
        PortableQueryFilter queryFilter = new PortableQueryFilter(0, 10, false, "", "", false);
        queryFilter.getParams().put("serverTemplateId", "serverTemplateId");
        PageResponse response = this.processDocumentsService.getData((QueryFilter)queryFilter);
        Assert.assertEquals((long)1L, (long)response.getTotalRowSize());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertTrue((boolean)response.isTotalRowSizeExact());
        Assert.assertTrue((boolean)response.isFirstPage());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testGetDataPaginated() {
        int totalItems = 12;
        PageResponse variablesResponse = new PageResponse();
        variablesResponse.setPageRowList(new ArrayList());
        IntStream.range(0, totalItems).forEach(i -> variablesResponse.getPageRowList().add(RemoteProcessDocumentsServiceImplTest.newDocumentVariable()));
        Mockito.when((Object)this.processVariablesService.getData((QueryFilter)Mockito.any())).thenReturn((Object)variablesResponse);
        PortableQueryFilter queryFilter = new PortableQueryFilter(0, 10, false, "", "", false);
        queryFilter.getParams().put("serverTemplateId", "serverTemplateId");
        PageResponse response = this.processDocumentsService.getData((QueryFilter)queryFilter);
        Assert.assertEquals((long)totalItems, (long)response.getTotalRowSize());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertTrue((boolean)response.isTotalRowSizeExact());
        Assert.assertTrue((boolean)response.isFirstPage());
        Assert.assertFalse((boolean)response.isLastPage());
    }
}

