/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server.util;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.workbench.pr.backend.server.util.VariableHelper;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.instance.VariableInstance;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class VariableHelperTest {
    private final String deploymentId = "deploymentId";
    private final String serverTemplateId = "serverTemplateId";
    private final String processId = "processId";
    private final Long processInstanceId = 1L;
    private String processDefinitionVar1Name = "var1";
    private String processDefinitionVar2Name = "var2";
    private String processDefinitionVar3Name = "var3";
    private String processDefaultVar_name = "initiator";
    private String processDefinitionVar1Value = "value1";
    private String processDefaultVarValue = "testUser";
    private String processDefaultExcludedVarName = "processId";
    private List<VariableInstance> variables;
    private Map<String, String> properties;

    @Before
    public void setUp() {
        this.variables = Arrays.asList(VariableInstance.builder().processInstanceId(this.processInstanceId).name(this.processDefinitionVar1Name).value(this.processDefinitionVar1Value).date(new Date()).build(), VariableInstance.builder().processInstanceId(this.processInstanceId).name(this.processDefaultVar_name).value(this.processDefaultVarValue).date(new Date()).build(), VariableInstance.builder().processInstanceId(this.processInstanceId).name(this.processDefaultExcludedVarName).value("processId").date(new Date()).build());
        this.properties = new HashMap<String, String>();
        this.properties.put(this.processDefinitionVar1Name, "String");
        this.properties.put(this.processDefinitionVar2Name, "String");
        this.properties.put(this.processDefinitionVar3Name, "String");
    }

    @Test
    public void addDeploymentIdServerTemplateToAllProcessInstancesVarsTest() {
        List varList = VariableHelper.adaptCollection(this.variables, this.properties, (long)this.processInstanceId, (String)"deploymentId", (String)"serverTemplateId");
        varList.stream().forEach(processVariableSummary -> {
            Assert.assertEquals((Object)"deploymentId", (Object)processVariableSummary.getDeploymentId());
            Assert.assertEquals((Object)"serverTemplateId", (Object)processVariableSummary.getServerTemplateId());
        });
        Assert.assertEquals((long)4L, (long)varList.size());
        Assert.assertEquals((Object)this.processDefaultVar_name, (Object)((ProcessVariableSummary)varList.get(0)).getName());
        Assert.assertEquals((Object)this.processDefinitionVar1Name, (Object)((ProcessVariableSummary)varList.get(1)).getName());
        Assert.assertEquals((Object)this.processDefinitionVar2Name, (Object)((ProcessVariableSummary)varList.get(2)).getName());
        Assert.assertEquals((Object)this.processDefinitionVar3Name, (Object)((ProcessVariableSummary)varList.get(3)).getName());
        Assert.assertEquals((Object)this.processDefaultVarValue, (Object)((ProcessVariableSummary)varList.get(0)).getNewValue());
        Assert.assertEquals((Object)this.processDefinitionVar1Value, (Object)((ProcessVariableSummary)varList.get(1)).getNewValue());
        Assert.assertEquals((Object)"", (Object)((ProcessVariableSummary)varList.get(2)).getNewValue());
        Assert.assertEquals((Object)"", (Object)((ProcessVariableSummary)varList.get(3)).getNewValue());
    }
}

