/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.pr.backend.server.ProcessInstanceVariableMapper;
import org.jbpm.workbench.pr.backend.server.util.DefaultVariableProcessor;
import org.jbpm.workbench.pr.backend.server.util.DocumentsVariableProcessor;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.kie.server.api.model.instance.VariableInstance;

public class VariableHelper {
    public static final Collection<String> DOCUMENT_TYPES;
    public static final String JBPM_DOCUMENT = "org.jbpm.document.Document";
    public static final String DOCUMENT_COLLECTION = "org.jbpm.document.DocumentCollection";
    public static final String DOCUMENT_COLLECTION_IMPL = "org.jbpm.document.service.impl.DocumentCollectionImpl";
    public static final String LEGACY_DOCUMENTS = "org.jbpm.document.Documents";
    private static final List<String> excludedVariables;
    private static final Map<String, VariableProcessor> processors;

    public static void registerProcessor(VariableProcessor processor) {
        processors.put(processor.getSupportedType(), processor);
    }

    public static List<ProcessVariableSummary> adaptCollection(List<VariableInstance> variables, Map<String, String> properties, long processInstanceId, String deploymentId, String serverTemplateId) {
        List filteredVariables = variables.stream().filter(variable -> !excludedVariables.contains(variable.getVariableName())).collect(Collectors.toList());
        ArrayList<ProcessVariableSummary> variablesSummary = new ArrayList<ProcessVariableSummary>();
        properties.forEach((key, value) -> {
            VariableProcessor processor = processors.getOrDefault(value, new DefaultVariableProcessor());
            processor.process(processInstanceId, (String)key, (String)value, filteredVariables, deploymentId, serverTemplateId, variableSummary -> variablesSummary.add((ProcessVariableSummary)variableSummary));
        });
        variablesSummary.addAll(Optional.ofNullable(filteredVariables).orElse(Collections.emptyList()).stream().map(new ProcessInstanceVariableMapper(deploymentId, serverTemplateId, "")).collect(Collectors.toList()));
        variablesSummary.sort(Comparator.comparing(GenericSummary::getName));
        return variablesSummary;
    }

    static {
        excludedVariables = Collections.singletonList("processId");
        processors = new HashMap<String, VariableProcessor>();
        DOCUMENT_TYPES = Arrays.asList(JBPM_DOCUMENT, DOCUMENT_COLLECTION, DOCUMENT_COLLECTION_IMPL, LEGACY_DOCUMENTS);
        VariableHelper.registerProcessor(new DocumentsVariableProcessor(DOCUMENT_COLLECTION));
        VariableHelper.registerProcessor(new DocumentsVariableProcessor(DOCUMENT_COLLECTION_IMPL));
        VariableHelper.registerProcessor(new DocumentsVariableProcessor(LEGACY_DOCUMENTS));
    }

    public static interface VariableProcessor {
        public String getSupportedType();

        public void process(long var1, String var3, String var4, List<VariableInstance> var5, String var6, String var7, Consumer<ProcessVariableSummary> var8);
    }
}

