/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.Date;
import org.jbpm.workbench.pr.backend.server.ProcessInstanceVariableMapper;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.instance.VariableInstance;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessInstanceVariableMapperTest {
    private String deploymentId = "deploymentId";
    private String serverTemplateId = "serverTemplateId";
    private String varType = "String";

    public static void assertVariableInstance(VariableInstance vi, ProcessVariableSummary pivs) {
        Assert.assertNotNull((Object)vi);
        Assert.assertEquals((Object)vi.getVariableName(), (Object)pivs.getName());
        Assert.assertEquals((Object)vi.getProcessInstanceId(), (Object)pivs.getProcessInstanceId());
        Assert.assertEquals((Object)vi.getOldValue(), (Object)pivs.getOldValue());
        Assert.assertEquals((Object)vi.getValue(), (Object)pivs.getNewValue());
        Assert.assertEquals((long)vi.getDate().getTime(), (long)pivs.getTimestamp());
    }

    @Test
    public void testProcessInstanceVariableMapperTest() {
        VariableInstance vi = VariableInstance.builder().name("variableName").processInstanceId(Long.valueOf(1L)).value("variableNewValue").oldValue("variableOldValue").date(new Date()).build();
        ProcessVariableSummary pivs = new ProcessInstanceVariableMapper(this.deploymentId, this.serverTemplateId, this.varType).apply(vi);
        ProcessInstanceVariableMapperTest.assertVariableInstance(vi, pivs);
        Assert.assertEquals((Object)this.deploymentId, (Object)pivs.getDeploymentId());
        Assert.assertEquals((Object)this.serverTemplateId, (Object)pivs.getServerTemplateId());
        Assert.assertEquals((Object)this.varType, (Object)pivs.getType());
    }

    @Test
    public void testProcessInstanceVariableMapperMapNull() {
        VariableInstance vi = null;
        ProcessVariableSummary pivs = new ProcessInstanceVariableMapper(this.deploymentId, this.serverTemplateId, "").apply(vi);
        Assert.assertNull((Object)pivs);
    }
}

