/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.Collections;
import org.jbpm.workbench.pr.backend.server.WorkItemSummaryMapper;
import org.jbpm.workbench.pr.model.WorkItemSummary;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.instance.WorkItemInstance;

public class WorkItemSummaryMapperTest {
    public static void assertWorkItemSummary(WorkItemInstance wii, WorkItemSummary wis) {
        Assert.assertNotNull((Object)wii);
        Assert.assertNotNull((Object)wis);
        Assert.assertEquals((Object)wii.getId(), (Object)wis.getId());
        Assert.assertEquals((Object)wii.getName(), (Object)wis.getName());
        if (wii.getParameters() != null) {
            Assert.assertEquals((long)wii.getParameters().size(), (long)wis.getParameters().size());
            wis.getParameters().stream().forEach(wisp -> Assert.assertEquals((Object)wii.getParameters().get(wisp.getId()).toString(), (Object)wisp.getName()));
        } else {
            Assert.assertNull((Object)wis.getParameters());
        }
    }

    @Test
    public void testWorkItemSummaryMapper_mapWorkItemSummary() {
        WorkItemInstance workItemInstance = WorkItemInstance.builder().id(Long.valueOf(1L)).name("Human Task").parameters(Collections.singletonMap("initiator", "String")).build();
        WorkItemSummaryMapperTest.assertWorkItemSummary(workItemInstance, new WorkItemSummaryMapper().apply(workItemInstance));
    }

    @Test
    public void testWorkItemSummaryMapper_mapNull() {
        Assert.assertNull((Object)new WorkItemSummaryMapper().apply(null));
    }
}

