/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.jbpm.workbench.ks.integration.ConsoleDataSetLookup;
import org.jbpm.workbench.pr.backend.server.ProcessDefinitionDataSetGenerator;
import org.jbpm.workbench.pr.backend.server.ProcessDefinitionDataSetProvider;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessDefinitionDataSetProviderTest {
    @Mock
    protected ProcessRuntimeDataService processRuntimeDataService;
    @InjectMocks
    ProcessDefinitionDataSetProvider processDefinitionDataSetProvider;
    private static final String SERVER_TEMPLATE_ID = "serverTemplateId";
    private static final String TEXT_SEARCH = "one";
    private static final String SORT_COLUMN_NAME = "ProcessName";
    private DataSetDef dataSetdef;

    @Before
    public void init() {
        ProcessSummary processSummaryOne = new ProcessSummary("test-def-id", "test-def-name-one", "testone", "1", false);
        ProcessSummary processSummaryTwo = new ProcessSummary("test-def-id", "test-def-name", "testtwo", "1", false);
        ProcessSummary processSummaryThree = new ProcessSummary("test-def-id", "test-def-name", "testtwo", "2", false);
        List<ProcessSummary> processSummaries = Arrays.asList(processSummaryOne, processSummaryTwo, processSummaryThree);
        ((ProcessRuntimeDataService)Mockito.doAnswer(answer -> Arrays.asList(processSummaryOne)).when((Object)this.processRuntimeDataService)).getProcessesByFilter(SERVER_TEMPLATE_ID, TEXT_SEARCH, Integer.valueOf(0), Integer.valueOf(-1), SORT_COLUMN_NAME, Boolean.valueOf(false));
        ((ProcessRuntimeDataService)Mockito.doAnswer(answer -> processSummaries).when((Object)this.processRuntimeDataService)).getProcessesByFilter(SERVER_TEMPLATE_ID, "", Integer.valueOf(0), Integer.valueOf(-1), SORT_COLUMN_NAME, Boolean.valueOf(false));
        this.dataSetdef = new ProcessDefinitionDataSetGenerator().getDataSetDef();
    }

    @Test
    public void testGetDataSetMetadata() throws Exception {
        DataSetMetadata dataSetMetadata = this.processDefinitionDataSetProvider.getDataSetMetadata(this.dataSetdef);
        Assert.assertEquals((Object)"jbpmProcessDefinition", (Object)dataSetMetadata.getUUID());
        ((ListAssert)Assertions.assertThat((List)dataSetMetadata.getColumnIds()).hasSize(5)).containsOnlyOnce((Object[])new String[]{SORT_COLUMN_NAME, "ProcessVersion", "Project", "ProcessDefId", "Dynamic"});
        ((ListAssert)Assertions.assertThat((List)dataSetMetadata.getColumnTypes()).hasSize(5)).containsOnly((Object[])new ColumnType[]{ColumnType.LABEL});
    }

    @Test
    public void testLookupDataSet() throws Exception {
        DataSetLookup lookup = new DataSetLookup();
        lookup.setDataSetUUID("jbpmProcessDefinition");
        DataSetLookup consoleDataSetLookup = ConsoleDataSetLookup.fromInstance((DataSetLookup)lookup, (String)SERVER_TEMPLATE_ID);
        CoreFunctionFilter coreFunctionFilter = new CoreFunctionFilter(SORT_COLUMN_NAME, CoreFunctionType.LIKE_TO, new Comparable[]{TEXT_SEARCH});
        DataSetFilter dataSetFilter = new DataSetFilter();
        dataSetFilter.addFilterColumn(new ColumnFilter[]{coreFunctionFilter});
        consoleDataSetLookup.addOperation(new DataSetOp[]{dataSetFilter});
        DataSet dataSet = this.processDefinitionDataSetProvider.lookupDataSet(this.dataSetdef, consoleDataSetLookup);
        Assert.assertEquals((Object)"jbpmProcessDefinition", (Object)dataSet.getUUID());
        Assert.assertEquals((long)1L, (long)dataSet.getRowCount());
        ((ListAssert)Assertions.assertThat((List)dataSet.getColumns()).hasSize(5)).extracting(dataColumn -> dataColumn.getId()).contains((Object[])new String[]{"ProcessVersion", "ProcessVersion", "Project", "ProcessDefId", "Dynamic"});
    }

    @Test
    public void testLookupDataSetWithoutFilterColumn() throws Exception {
        DataSetLookup lookup = new DataSetLookup();
        lookup.setDataSetUUID("jbpmProcessDefinition");
        DataSetLookup consoleDataSetLookup = ConsoleDataSetLookup.fromInstance((DataSetLookup)lookup, (String)SERVER_TEMPLATE_ID);
        DataSetFilter dataSetFilter = new DataSetFilter();
        consoleDataSetLookup.addOperation(new DataSetOp[]{dataSetFilter});
        DataSet dataSet = this.processDefinitionDataSetProvider.lookupDataSet(this.dataSetdef, consoleDataSetLookup);
        Assert.assertEquals((Object)"jbpmProcessDefinition", (Object)dataSet.getUUID());
        Assert.assertEquals((long)3L, (long)dataSet.getRowCount());
        ((ListAssert)Assertions.assertThat((List)dataSet.getColumns()).hasSize(5)).extracting(dataColumn -> dataColumn.getId()).contains((Object[])new String[]{"ProcessVersion", "ProcessVersion", "Project", "ProcessDefId", "Dynamic"});
    }
}

