/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.jbpm.workbench.common.model.PortableQueryFilter;
import org.jbpm.workbench.common.model.QueryFilter;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.pr.backend.server.RemoteProcessVariablesServiceImpl;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.api.model.definition.VariablesDefinition;
import org.kie.server.api.model.instance.VariableInstance;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.paging.PageResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteProcessVariablesServiceImplTest {
    private final String var1 = "var1";
    private final String var1_value = "valueVar1";
    private final String var2 = "var2";
    private final String doc = "doc";
    private final String docValue = "doc.txt####42580####2019-04-17 15:53:36####doc";
    private final String docs = "documents";
    private final String document1Name = "documents (1/2)";
    private final String document1Value = "doc1.txt####42580####2019-04-17 15:53:36####doc1";
    private final String document2Name = "documents (2/2)";
    private final String document2Value = "doc2.txt####42580####2019-04-17 15:53:36####doc2";
    private final String containerId = "containerId";
    private final String serverTemplateId = "serverTemplateId";
    private final String processId = "processId";
    private final String processInstanceId = "1";
    @Mock
    private KieServerIntegration kieServerIntegration;
    @Mock
    private QueryServicesClient queryServicesClient;
    @Mock
    private ProcessServicesClient processServicesClient;
    private QueryFilter queryFilter;
    @InjectMocks
    private RemoteProcessVariablesServiceImpl processVariablesService;

    @Before
    public void setup() {
        KieServicesClient kieServicesClient = (KieServicesClient)Mockito.mock(KieServicesClient.class);
        Mockito.when((Object)this.kieServerIntegration.getServerClient((String)Mockito.any())).thenReturn((Object)kieServicesClient);
        Mockito.when((Object)kieServicesClient.getServicesClient(QueryServicesClient.class)).thenReturn((Object)this.queryServicesClient);
        Mockito.when((Object)kieServicesClient.getServicesClient(ProcessServicesClient.class)).thenReturn((Object)this.processServicesClient);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serverTemplateId", "serverTemplateId");
        params.put("deploymentId", "containerId");
        params.put("processInstanceId", "1");
        params.put("processDefId", "processId");
        this.queryFilter = new PortableQueryFilter(0, 10, false, "", "", true, null, params);
    }

    @Test
    public void getProcessVariablesTestWithContainerStarted() {
        HashMap<String, String> processDefVars = new HashMap<String, String>();
        processDefVars.put("var1", "");
        processDefVars.put("var2", "");
        VariablesDefinition variablesDefinition = new VariablesDefinition(processDefVars);
        VariableInstance variableInstance = VariableInstance.builder().name("var1").value("valueVar1").processInstanceId(Long.valueOf("1")).date(new Date()).build();
        Mockito.when((Object)this.queryServicesClient.findVariablesCurrentState((Long)Mockito.any())).thenReturn(Collections.singletonList(variableInstance));
        Mockito.when((Object)this.processServicesClient.getProcessVariableDefinitions("containerId", "processId")).thenReturn((Object)variablesDefinition);
        List processInstanceVariables = this.processVariablesService.getProcessVariables(this.queryFilter);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).getProcessVariableDefinitions("containerId", "processId");
        ((QueryServicesClient)Mockito.verify((Object)this.queryServicesClient)).findVariablesCurrentState(Long.valueOf("1"));
        Assert.assertEquals((long)2L, (long)processInstanceVariables.size());
        Assert.assertEquals((Object)"var1", (Object)((ProcessVariableSummary)processInstanceVariables.get(0)).getName());
        Assert.assertEquals((Object)"valueVar1", (Object)((ProcessVariableSummary)processInstanceVariables.get(0)).getNewValue());
        Assert.assertEquals((Object)"var2", (Object)((ProcessVariableSummary)processInstanceVariables.get(1)).getName());
        Assert.assertEquals((Object)"", (Object)((ProcessVariableSummary)processInstanceVariables.get(1)).getNewValue());
    }

    @Test
    public void testGetProcessVariablesWithDocumentCollectionWithContainerStarted() {
        this.testDocumentCollection("org.jbpm.document.DocumentCollection");
    }

    @Test
    public void testGetProcessVariablesWithDocumentCollectionImplWithContainerStarted() {
        this.testDocumentCollection("org.jbpm.document.service.impl.DocumentCollectionImpl");
    }

    @Test
    public void testGetProcessVariablesWithLegacyDocumentsWithContainerStarted() {
        this.testDocumentCollection("org.jbpm.document.Documents");
    }

    public void testDocumentCollection(String documentsCollectionType) {
        HashMap<String, String> processDefVars = new HashMap<String, String>();
        processDefVars.put("var1", "");
        processDefVars.put("var2", "");
        processDefVars.put("doc", "org.jbpm.document.Document");
        processDefVars.put("documents", documentsCollectionType);
        VariablesDefinition variablesDefinition = new VariablesDefinition(processDefVars);
        VariableInstance variableInstance = VariableInstance.builder().name("var1").value("valueVar1").processInstanceId(Long.valueOf("1")).date(new Date()).build();
        VariableInstance docVariableInstance = VariableInstance.builder().name("doc").value("doc.txt####42580####2019-04-17 15:53:36####doc").processInstanceId(Long.valueOf("1")).date(new Date()).build();
        VariableInstance doc1VariableInstance = VariableInstance.builder().name("documents (1/2)").value("doc1.txt####42580####2019-04-17 15:53:36####doc1").processInstanceId(Long.valueOf("1")).date(new Date()).build();
        VariableInstance doc2VariableInstance = VariableInstance.builder().name("documents (2/2)").value("doc2.txt####42580####2019-04-17 15:53:36####doc2").processInstanceId(Long.valueOf("1")).date(new Date()).build();
        Mockito.when((Object)this.queryServicesClient.findVariablesCurrentState((Long)Mockito.any())).thenReturn(Arrays.asList(variableInstance, docVariableInstance, doc1VariableInstance, doc2VariableInstance));
        Mockito.when((Object)this.processServicesClient.getProcessVariableDefinitions("containerId", "processId")).thenReturn((Object)variablesDefinition);
        List processInstanceVariables = this.processVariablesService.getProcessVariables(this.queryFilter);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).getProcessVariableDefinitions("containerId", "processId");
        ((QueryServicesClient)Mockito.verify((Object)this.queryServicesClient)).findVariablesCurrentState(Long.valueOf("1"));
        Assert.assertEquals((long)5L, (long)processInstanceVariables.size());
        Assert.assertEquals((Object)"doc", (Object)((ProcessVariableSummary)processInstanceVariables.get(0)).getName());
        Assert.assertEquals((Object)"doc.txt####42580####2019-04-17 15:53:36####doc", (Object)((ProcessVariableSummary)processInstanceVariables.get(0)).getNewValue());
        Assert.assertEquals((Object)"documents (1/2)", (Object)((ProcessVariableSummary)processInstanceVariables.get(1)).getName());
        Assert.assertEquals((Object)"doc1.txt####42580####2019-04-17 15:53:36####doc1", (Object)((ProcessVariableSummary)processInstanceVariables.get(1)).getNewValue());
        Assert.assertEquals((Object)"documents (2/2)", (Object)((ProcessVariableSummary)processInstanceVariables.get(2)).getName());
        Assert.assertEquals((Object)"doc2.txt####42580####2019-04-17 15:53:36####doc2", (Object)((ProcessVariableSummary)processInstanceVariables.get(2)).getNewValue());
        Assert.assertEquals((Object)"var1", (Object)((ProcessVariableSummary)processInstanceVariables.get(3)).getName());
        Assert.assertEquals((Object)"valueVar1", (Object)((ProcessVariableSummary)processInstanceVariables.get(3)).getNewValue());
        Assert.assertEquals((Object)"var2", (Object)((ProcessVariableSummary)processInstanceVariables.get(4)).getName());
        Assert.assertEquals((Object)"", (Object)((ProcessVariableSummary)processInstanceVariables.get(4)).getNewValue());
    }

    @Test
    public void getProcessVariablesTestWithContainerStopped() {
        VariableInstance variableInstance = VariableInstance.builder().name("var1").value("valueVar1").processInstanceId(Long.valueOf("1")).date(new Date()).build();
        Mockito.when((Object)this.processServicesClient.getProcessVariableDefinitions("containerId", "processId")).thenThrow(new Throwable[]{new KieServicesHttpException()});
        Mockito.when((Object)this.queryServicesClient.findVariablesCurrentState((Long)Mockito.any())).thenReturn(Collections.singletonList(variableInstance));
        List processInstanceVariables = this.processVariablesService.getProcessVariables(this.queryFilter);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).getProcessVariableDefinitions("containerId", "processId");
        ((QueryServicesClient)Mockito.verify((Object)this.queryServicesClient)).findVariablesCurrentState(Long.valueOf("1"));
        Assert.assertEquals((long)1L, (long)processInstanceVariables.size());
        Assert.assertEquals((Object)"var1", (Object)((ProcessVariableSummary)processInstanceVariables.get(0)).getName());
        Assert.assertEquals((Object)"valueVar1", (Object)((ProcessVariableSummary)processInstanceVariables.get(0)).getNewValue());
    }

    @Test
    public void testGetData() {
        VariablesDefinition variablesDefinition = new VariablesDefinition(Collections.singletonMap("var1", ""));
        Mockito.when((Object)this.processServicesClient.getProcessVariableDefinitions("containerId", "processId")).thenReturn((Object)variablesDefinition);
        VariableInstance variableInstance = VariableInstance.builder().name("var1").value("valueVar1").processInstanceId(Long.valueOf("1")).date(new Date()).build();
        Mockito.when((Object)this.queryServicesClient.findVariablesCurrentState((Long)Mockito.any())).thenReturn(Collections.singletonList(variableInstance));
        PageResponse response = this.processVariablesService.getData(this.queryFilter);
        Assert.assertEquals((long)1L, (long)response.getTotalRowSize());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertTrue((boolean)response.isTotalRowSizeExact());
        Assert.assertTrue((boolean)response.isFirstPage());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testGetDataPaginated() {
        int totalItems = 12;
        HashMap variables = new HashMap();
        IntStream.range(0, totalItems).forEach(i -> variables.put("var_" + i, ""));
        VariablesDefinition variablesDefinition = new VariablesDefinition(variables);
        Mockito.when((Object)this.processServicesClient.getProcessVariableDefinitions("containerId", "processId")).thenReturn((Object)variablesDefinition);
        PageResponse response = this.processVariablesService.getData(this.queryFilter);
        Assert.assertEquals((long)totalItems, (long)response.getTotalRowSize());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertTrue((boolean)response.isTotalRowSizeExact());
        Assert.assertTrue((boolean)response.isFirstPage());
        Assert.assertFalse((boolean)response.isLastPage());
    }
}

