/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.pr.backend.server.RemoteProcessServiceImpl;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteProcessServiceImplTest {
    private static final String SERVER_TEMPLATE_ID = "serverTemplateId";
    private ProcessServicesClient processServicesClientMock;
    @Mock
    private KieServerIntegration kieServerIntegration;
    @InjectMocks
    private RemoteProcessServiceImpl remoteProcessService;
    private final String signal = "signal";
    private final Object event = new Object();

    @Before
    public void setup() {
        KieServicesClient kieServicesClientMock = (KieServicesClient)Mockito.mock(KieServicesClient.class);
        this.processServicesClientMock = (ProcessServicesClient)Mockito.mock(ProcessServicesClient.class);
        Mockito.when((Object)this.kieServerIntegration.getServerClient((String)Matchers.eq((Object)SERVER_TEMPLATE_ID), Matchers.anyString())).thenReturn((Object)kieServicesClientMock);
        Mockito.when((Object)this.kieServerIntegration.getServerClient((String)Matchers.eq((Object)SERVER_TEMPLATE_ID))).thenReturn((Object)kieServicesClientMock);
        Mockito.when((Object)kieServicesClientMock.getServicesClient(ProcessServicesClient.class)).thenReturn((Object)this.processServicesClientMock);
    }

    @Test
    public void bulkAbortProcessInstancesTest_singleProcessInstance() {
        String containerId = "containerId";
        Long processInstanceId = 1L;
        Map<String, List<Long>> containerInstance = Collections.singletonMap("containerId", Arrays.asList(processInstanceId));
        this.remoteProcessService.abortProcessInstances(SERVER_TEMPLATE_ID, containerInstance);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClientMock)).abortProcessInstances("containerId", Arrays.asList(processInstanceId));
    }

    @Test
    public void bulkAbortProcessInstancesTest_multipleProcessInstancesOneContainer() {
        String containerId = "containerId";
        ArrayList<Long> processInstanceIds = new ArrayList<Long>(Arrays.asList(1L, 2L));
        Map<String, List<Long>> containerInstance = Collections.singletonMap("containerId", Arrays.asList(1L, 2L));
        this.remoteProcessService.abortProcessInstances(SERVER_TEMPLATE_ID, containerInstance);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClientMock)).abortProcessInstances("containerId", processInstanceIds);
    }

    @Test
    public void bulkAbortProcessInstancesTest_multipleProcessInstancesMultipleContainers() {
        HashMap<String, List<Long>> containerInstance = new HashMap<String, List<Long>>();
        containerInstance.put("containerId_1", Arrays.asList(1L));
        containerInstance.put("containerId_2", Arrays.asList(2L));
        this.remoteProcessService.abortProcessInstances(SERVER_TEMPLATE_ID, containerInstance);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClientMock)).abortProcessInstances("containerId_1", Arrays.asList(1L));
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClientMock)).abortProcessInstances("containerId_2", Arrays.asList(2L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.processServicesClientMock});
    }

    @Test
    public void bulkSignalProcessInstancesTest_singleProcessInstance() {
        String containerId = "containerId";
        Long processInstanceId = 1L;
        this.remoteProcessService.signalProcessInstances(SERVER_TEMPLATE_ID, Collections.singletonList("containerId"), Collections.singletonList(processInstanceId), "signal", this.event);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClientMock)).signalProcessInstances("containerId", Collections.singletonList(processInstanceId), "signal", this.event);
    }

    @Test
    public void bulkSignalProcessInstancesTest_multipleProcessInstancesOneContainer() {
        String containerId = "containerId";
        ArrayList<Long> processInstanceIds = new ArrayList<Long>(Arrays.asList(1L, 2L));
        this.remoteProcessService.signalProcessInstances(SERVER_TEMPLATE_ID, new ArrayList<String>(Arrays.asList("containerId", "containerId")), processInstanceIds, "signal", this.event);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClientMock)).signalProcessInstances("containerId", processInstanceIds, "signal", this.event);
    }

    @Test
    public void bulkSignalProcessInstancesTest_multipleProcessInstancesMultipleContainers() {
        ArrayList<String> containerIds = new ArrayList<String>(Arrays.asList("containerId_1", "containerId_2"));
        ArrayList<Long> processInstanceIds = new ArrayList<Long>(Arrays.asList(1L, 2L));
        this.remoteProcessService.signalProcessInstances(SERVER_TEMPLATE_ID, containerIds, processInstanceIds, "signal", this.event);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClientMock)).signalProcessInstance((String)containerIds.get(0), (Long)processInstanceIds.get(0), "signal", this.event);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClientMock)).signalProcessInstance((String)containerIds.get(1), (Long)processInstanceIds.get(1), "signal", this.event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.processServicesClientMock});
    }
}

