/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.jbpm.workbench.ks.integration.KieServerDataSetProvider;
import org.jbpm.workbench.ks.integration.event.QueryDefinitionLoaded;
import org.jbpm.workbench.pr.backend.server.DataSetDefsBootstrap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.QueryDefinition;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetDefsBootstrapTest {
    @Mock
    DataSetDefRegistry dataSetRegistry;
    @InjectMocks
    DataSetDefsBootstrap dataSetsBootstrap;

    @Test
    public void testProcessInstanceDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("jbpmProcessInstances").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"jbpmProcessInstances", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-jbpmProcessInstances", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)18L, (long)dataSetDef.getColumns().size());
    }

    @Test
    public void testProcessInstanceWithVariablesDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("jbpmProcessInstancesWithVariables").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"jbpmProcessInstancesWithVariables", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-jbpmProcessInstancesWithVariables", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)5L, (long)dataSetDef.getColumns().size());
    }

    @Test
    public void testProcessInstanceLogsDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("jbpmProcessInstanceLogs").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"jbpmProcessInstanceLogs", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-jbpmProcessInstanceLogs", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)14L, (long)dataSetDef.getColumns().size());
    }
}

