/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.pr.backend.server.ProcessSummaryMapperTest;
import org.jbpm.workbench.pr.backend.server.RemoteProcessRuntimeDataServiceImpl;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteProcessRuntimeDataServiceImplTest {
    private final String processId = "processId";
    private final String containerId = "containerId";
    private final String serverTemplateId = "serverTemplateId";
    @Mock
    private KieServerIntegration kieServerIntegration;
    @Mock
    private QueryServicesClient queryServicesClient;
    @Mock
    private ProcessServicesClient processServicesClient;
    @InjectMocks
    private RemoteProcessRuntimeDataServiceImpl service;

    @Before
    public void setup() {
        KieServicesClient kieServicesClient = (KieServicesClient)Mockito.mock(KieServicesClient.class);
        Mockito.when((Object)this.kieServerIntegration.getServerClient(Matchers.anyString())).thenReturn((Object)kieServicesClient);
        Mockito.when((Object)kieServicesClient.getServicesClient(QueryServicesClient.class)).thenReturn((Object)this.queryServicesClient);
        Mockito.when((Object)kieServicesClient.getServicesClient(ProcessServicesClient.class)).thenReturn((Object)this.processServicesClient);
    }

    @Test
    public void getProcessInstanceDetailsTest() {
        Long processInstanceId = 1L;
        TaskSummary taskSummaryMock = (TaskSummary)Mockito.mock(TaskSummary.class);
        TaskSummaryList taskSummaryListSpy = (TaskSummaryList)Mockito.spy((Object)new TaskSummaryList(Collections.singletonList(taskSummaryMock)));
        ProcessInstance processInstanceSpy = (ProcessInstance)Mockito.spy((Object)ProcessInstance.builder().activeUserTasks(taskSummaryListSpy).build());
        Mockito.when((Object)this.processServicesClient.getProcessInstance("containerId", processInstanceId)).thenReturn((Object)processInstanceSpy);
        this.service.getProcessInstance("serverTemplateId", new ProcessInstanceKey("serverTemplateId", "containerId", processInstanceId));
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getProcessId();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getState();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getContainerId();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getProcessVersion();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getCorrelationKey();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getParentId();
        this.verifyActiveUserTasks(taskSummaryListSpy, taskSummaryMock);
        this.verifyCurrentActivities(processInstanceId);
    }

    public void verifyActiveUserTasks(TaskSummaryList taskSummaryList, TaskSummary taskSummary) {
        ((TaskSummaryList)Mockito.verify((Object)taskSummaryList)).getItems();
        ((TaskSummary)Mockito.verify((Object)taskSummary)).getName();
        ((TaskSummary)Mockito.verify((Object)taskSummary)).getStatus();
        ((TaskSummary)Mockito.verify((Object)taskSummary)).getActualOwner();
    }

    private void verifyCurrentActivities(Long processInstanceId) {
        NodeInstance nodeInstanceMock = (NodeInstance)Mockito.mock(NodeInstance.class);
        List<NodeInstance> nodeInstanceList = Collections.singletonList(nodeInstanceMock);
        Mockito.when((Object)this.processServicesClient.findActiveNodeInstances("containerId", processInstanceId, Integer.valueOf(0), Integer.valueOf(100))).thenReturn(nodeInstanceList);
        Mockito.when((Object)nodeInstanceMock.getDate()).thenReturn((Object)new Date());
        this.service.getProcessInstanceActiveNodes("serverTemplateId", "containerId", processInstanceId);
        ((ProcessServicesClient)Mockito.verify((Object)this.processServicesClient)).findActiveNodeInstances("containerId", processInstanceId, Integer.valueOf(0), Integer.valueOf(100));
        ((NodeInstance)Mockito.verify((Object)nodeInstanceMock)).getDate();
        ((NodeInstance)Mockito.verify((Object)nodeInstanceMock)).getId();
        ((NodeInstance)Mockito.verify((Object)nodeInstanceMock)).getName();
        ((NodeInstance)Mockito.verify((Object)nodeInstanceMock)).getNodeType();
    }

    @Test
    public void testInvalidServerTemplate() throws Exception {
        Method[] methods;
        for (Method method : methods = ProcessRuntimeDataService.class.getMethods()) {
            Class<?> returnType = method.getReturnType();
            Object[] args = new Object[method.getParameterCount()];
            Object result = method.invoke((Object)this.service, args);
            this.assertMethodResult(method, returnType, result);
            args[0] = "";
            result = method.invoke((Object)this.service, args);
            this.assertMethodResult(method, returnType, result);
        }
    }

    private void assertMethodResult(Method method, Class<?> returnType, Object result) {
        if (Collection.class.isAssignableFrom(returnType)) {
            Assert.assertNotNull((String)String.format("Returned collection for method %s should not be null", method.getName()), (Object)result);
            Assert.assertTrue((String)String.format("Returned collection for method %s should be empty", method.getName()), (boolean)((Collection)result).isEmpty());
        } else {
            Assert.assertNull((String)String.format("Returned object for method %s should be null", method.getName()), (Object)result);
        }
    }

    @Test
    public void testGetProcesses() {
        ProcessDefinition def = ProcessDefinition.builder().id("processId").build();
        Mockito.when((Object)this.queryServicesClient.findProcesses(Integer.valueOf(0), Integer.valueOf(10), "", true)).thenReturn(Collections.singletonList(def));
        List summaries = this.service.getProcesses("serverTemplateId", Integer.valueOf(0), Integer.valueOf(10), "", Boolean.valueOf(true));
        Assert.assertNotNull((Object)summaries);
        Assert.assertEquals((long)1L, (long)summaries.size());
        ProcessSummaryMapperTest.assertProcessSummary(def, (ProcessSummary)summaries.get(0));
    }

    @Test
    public void testGetProcessesByFilter() {
        ProcessDefinition def = ProcessDefinition.builder().id("processId").build();
        Mockito.when((Object)this.queryServicesClient.findProcesses("filter", Integer.valueOf(0), Integer.valueOf(10), "", true)).thenReturn(Collections.singletonList(def));
        List summaries = this.service.getProcessesByFilter("serverTemplateId", "filter", Integer.valueOf(0), Integer.valueOf(10), "", Boolean.valueOf(true));
        Assert.assertNotNull((Object)summaries);
        Assert.assertEquals((long)1L, (long)summaries.size());
        ProcessSummaryMapperTest.assertProcessSummary(def, (ProcessSummary)summaries.get(0));
    }

    @Test
    public void testGetProcess() {
        ProcessDefinition def = ProcessDefinition.builder().id("processId").build();
        Mockito.when((Object)this.processServicesClient.getProcessDefinition("containerId", "processId")).thenReturn((Object)def);
        ProcessDefinitionKey pdk = new ProcessDefinitionKey("serverTemplateId", "containerId", "processId");
        ProcessSummary summary = this.service.getProcess("serverTemplateId", pdk);
        Assert.assertNotNull((Object)summary);
        ProcessSummaryMapperTest.assertProcessSummary(def, summary);
    }
}

