/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.ks.integration.AbstractKieServerService;
import org.jbpm.workbench.pr.backend.server.ProcessSummaryMapper;
import org.jbpm.workbench.pr.backend.server.RuntimeLogSummaryMapper;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.model.RuntimeLogSummary;
import org.jbpm.workbench.pr.model.TaskDefSummary;
import org.jbpm.workbench.pr.model.UserTaskSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.UserTaskDefinitionList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;

@Service
@ApplicationScoped
public class RemoteProcessRuntimeDataServiceImpl
extends AbstractKieServerService
implements ProcessRuntimeDataService {
    public ProcessInstanceSummary getProcessInstance(String serverTemplateId, ProcessInstanceKey processInstanceKey) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        ProcessServicesClient queryServicesClient = (ProcessServicesClient)this.getClient(serverTemplateId, ProcessServicesClient.class);
        ProcessInstance processInstance = queryServicesClient.getProcessInstance(processInstanceKey.getDeploymentId(), processInstanceKey.getProcessInstanceId());
        return this.build(processInstance);
    }

    public List<NodeInstanceSummary> getProcessInstanceActiveNodes(String serverTemplateId, String deploymentId, Long processInstanceId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NodeInstanceSummary> instances = new ArrayList<NodeInstanceSummary>();
        ProcessServicesClient processServicesClient = (ProcessServicesClient)this.getClient(serverTemplateId, ProcessServicesClient.class);
        List nodeInstances = processServicesClient.findActiveNodeInstances(deploymentId, processInstanceId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        for (NodeInstance instance : nodeInstances) {
            NodeInstanceSummary summary = new NodeInstanceSummary(instance.getId().longValue(), instance.getProcessInstanceId().longValue(), instance.getName(), instance.getNodeId(), instance.getNodeType(), instance.getDate().toString(), instance.getConnection(), false);
            instances.add(summary);
        }
        return instances;
    }

    public List<RuntimeLogSummary> getProcessInstanceLogs(String serverTemplateId, String deploymentId, Long processInstanceId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        ProcessServicesClient processServicesClient = (ProcessServicesClient)this.getClient(serverTemplateId, ProcessServicesClient.class);
        List processInstanceHistory = processServicesClient.findNodeInstances(deploymentId, processInstanceId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        return processInstanceHistory.stream().map(new RuntimeLogSummaryMapper()).collect(Collectors.toList());
    }

    public List<ProcessSummary> getProcesses(String serverTemplateId, Integer page, Integer pageSize, String sort, Boolean sortOrder) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        QueryServicesClient queryServicesClient = (QueryServicesClient)this.getClient(serverTemplateId, QueryServicesClient.class);
        List processes = queryServicesClient.findProcesses(page, pageSize, sort, sortOrder.booleanValue());
        return processes.stream().map(new ProcessSummaryMapper()).collect(Collectors.toList());
    }

    public ProcessSummary getProcess(String serverTemplateId, ProcessDefinitionKey processDefinitionKey) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        ProcessServicesClient queryServicesClient = (ProcessServicesClient)this.getClient(serverTemplateId, ProcessServicesClient.class);
        ProcessDefinition definition = queryServicesClient.getProcessDefinition(processDefinitionKey.getDeploymentId(), processDefinitionKey.getProcessId());
        return new ProcessSummaryMapper().apply(definition);
    }

    public List<ProcessSummary> getProcessesByFilter(String serverTemplateId, String textSearch, Integer page, Integer pageSize, String sort, Boolean sortOrder) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        QueryServicesClient queryServicesClient = (QueryServicesClient)this.getClient(serverTemplateId, QueryServicesClient.class);
        List processes = queryServicesClient.findProcesses(textSearch, page, pageSize, sort, sortOrder.booleanValue());
        return processes.stream().map(new ProcessSummaryMapper()).collect(Collectors.toList());
    }

    public List<TaskDefSummary> getProcessUserTasks(String serverTemplateId, String containerId, String processId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        ProcessServicesClient processServicesClient = (ProcessServicesClient)this.getClient(serverTemplateId, ProcessServicesClient.class);
        UserTaskDefinitionList userTaskDefinitionList = processServicesClient.getUserTaskDefinitions(containerId, processId);
        return userTaskDefinitionList.getItems().stream().map(t -> new TaskDefSummary(t.getName())).collect(Collectors.toList());
    }

    protected ProcessInstanceSummary build(ProcessInstance processInstance) {
        ProcessInstanceSummary summary = new ProcessInstanceSummary(processInstance.getId(), processInstance.getProcessId(), processInstance.getContainerId(), processInstance.getProcessName(), processInstance.getProcessVersion(), processInstance.getState(), processInstance.getDate(), null, processInstance.getInitiator(), processInstance.getProcessInstanceDescription(), processInstance.getCorrelationKey(), processInstance.getParentId(), null, Integer.valueOf(0));
        if (processInstance.getActiveUserTasks() != null && processInstance.getActiveUserTasks().getTasks() != null) {
            List tasks = processInstance.getActiveUserTasks().getItems();
            ArrayList<UserTaskSummary> userTaskSummaries = new ArrayList<UserTaskSummary>();
            for (TaskSummary taskSummary : tasks) {
                UserTaskSummary userTaskSummary = new UserTaskSummary(taskSummary.getId(), taskSummary.getName(), taskSummary.getActualOwner(), taskSummary.getStatus());
                userTaskSummaries.add(userTaskSummary);
            }
            summary.setActiveTasks(userTaskSummaries);
        }
        return summary;
    }
}

