/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.pr.backend.server.ProcessDocumentServlet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.instance.DocumentInstance;
import org.kie.server.client.DocumentServicesClient;
import org.kie.server.client.KieServicesClient;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessDocumentServletTest {
    @Mock
    KieServerIntegration kieServerIntegration;
    @Mock
    KieServicesClient kieServicesClient;
    @Mock
    DocumentServicesClient documentServicesClient;
    @Mock
    DocumentInstance documentInstance;
    Map<String, String> params;
    @Mock
    private Appender loggingAppender;
    @Captor
    private ArgumentCaptor<LoggingEvent> loggingEventArgumentCaptor;
    private ProcessDocumentServlet processDocServlet;

    @Before
    public void setup() {
        this.params = new HashMap<String, String>();
        this.processDocServlet = new ProcessDocumentServlet();
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.addAppender(this.loggingAppender);
        logger.setLevel(Level.INFO);
    }

    @After
    public void teardown() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.detachAppender(this.loggingAppender);
    }

    @Test
    public void testInvalidRequestParamets() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getParameter("templateid")).thenReturn(null);
        Mockito.when((Object)request.getParameter("docid")).thenReturn(null);
        ProcessDocumentServlet processDocServlet = new ProcessDocumentServlet();
        processDocServlet.doGet(request, response);
        ((Appender)Mockito.verify((Object)this.loggingAppender)).doAppend(this.loggingEventArgumentCaptor.capture());
        LoggingEvent loggingEvent = (LoggingEvent)this.loggingEventArgumentCaptor.getValue();
        Assert.assertEquals((Object)Level.ERROR, (Object)loggingEvent.getLevel());
        Assert.assertEquals((Object)MessageFormat.format("Invalid parameters to servlet: templateid: \"{0}\", docid: \"{1}\"", "null", "null"), (Object)loggingEvent.getFormattedMessage());
    }

    @Test
    public void testInvalidServerTemplate() throws Exception {
        Mockito.when((Object)this.kieServerIntegration.getServerClient(Mockito.anyString())).thenReturn(null);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getParameter("templateid")).thenReturn((Object)"invalidTemplateId");
        Mockito.when((Object)request.getParameter("docid")).thenReturn((Object)"invalidDocId");
        ProcessDocumentServlet processDocServlet = new ProcessDocumentServlet();
        processDocServlet.setKieServerIntegration(this.kieServerIntegration);
        processDocServlet.doGet(request, response);
        ((Appender)Mockito.verify((Object)this.loggingAppender)).doAppend(this.loggingEventArgumentCaptor.capture());
        LoggingEvent loggingEvent = (LoggingEvent)this.loggingEventArgumentCaptor.getValue();
        Assert.assertEquals((Object)Level.ERROR, (Object)loggingEvent.getLevel());
        Assert.assertEquals((Object)MessageFormat.format("Unable to retrieve services client with template id \"{0}\"", "invalidTemplateId"), (Object)loggingEvent.getFormattedMessage());
    }

    @Test
    public void testInvalidDocumentInstance() throws Exception {
        Mockito.when((Object)this.kieServerIntegration.getServerClient(Mockito.anyString())).thenReturn((Object)this.kieServicesClient);
        Mockito.when((Object)this.kieServicesClient.getServicesClient((Class)Mockito.any())).thenReturn((Object)this.documentServicesClient);
        Mockito.when((Object)this.documentServicesClient.getDocument(Mockito.anyString())).thenReturn(null);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getParameter("templateid")).thenReturn((Object)"kie-server-id");
        Mockito.when((Object)request.getParameter("docid")).thenReturn((Object)"invalidDocId");
        ProcessDocumentServlet processDocServlet = new ProcessDocumentServlet();
        processDocServlet.setKieServerIntegration(this.kieServerIntegration);
        processDocServlet.doGet(request, response);
        ((Appender)Mockito.verify((Object)this.loggingAppender)).doAppend(this.loggingEventArgumentCaptor.capture());
        LoggingEvent loggingEvent = (LoggingEvent)this.loggingEventArgumentCaptor.getValue();
        Assert.assertEquals((Object)Level.ERROR, (Object)loggingEvent.getLevel());
        Assert.assertEquals((Object)MessageFormat.format("Unable to retrieve document with id \"{0}\"", "invalidDocId"), (Object)loggingEvent.getFormattedMessage());
    }

    @Test
    public void testRetrieveValidDocument() throws Exception {
        Mockito.when((Object)this.kieServerIntegration.getServerClient(Mockito.anyString())).thenReturn((Object)this.kieServicesClient);
        Mockito.when((Object)this.kieServicesClient.getServicesClient((Class)Mockito.any())).thenReturn((Object)this.documentServicesClient);
        Mockito.when((Object)this.documentServicesClient.getDocument(Mockito.anyString())).thenReturn((Object)this.documentInstance);
        Mockito.when((Object)this.documentInstance.getName()).thenReturn((Object)"testdoc.properties");
        Mockito.when((Object)this.documentInstance.getContent()).thenReturn((Object)"sampleContent".getBytes());
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getParameter("templateid")).thenReturn((Object)"kie-server-id");
        Mockito.when((Object)request.getParameter("docid")).thenReturn((Object)"AAAA-BBBB-CCCC-DDDD");
        StubServletOutputStream stubServletOutputStream = new StubServletOutputStream();
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)stubServletOutputStream);
        ProcessDocumentServlet processDocServlet = new ProcessDocumentServlet();
        processDocServlet.setKieServerIntegration(this.kieServerIntegration);
        processDocServlet.doGet(request, response);
        Assert.assertNotNull((Object)response.getOutputStream());
        Assert.assertEquals((Object)"sampleContent", (Object)new String(((StubServletOutputStream)response.getOutputStream()).getContent()));
    }

    protected class StubServletOutputStream
    extends ServletOutputStream {
        public ByteArrayOutputStream baos = new ByteArrayOutputStream();

        protected StubServletOutputStream() {
        }

        public byte[] getContent() {
            return this.baos.toByteArray();
        }

        public void write(int i) throws IOException {
            this.baos.write(i);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

