/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.pr.backend.server.ProcessSummaryMapperTest;
import org.jbpm.workbench.pr.backend.server.RemoteProcessRuntimeDataServiceImpl;
import org.jbpm.workbench.pr.backend.server.WorkItemSummaryMapperTest;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.model.ProcessInstanceDiagramSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessNodeSummary;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;
import org.jbpm.workbench.pr.model.TimerSummary;
import org.jbpm.workbench.pr.model.WorkItemSummary;
import org.jbpm.workbench.pr.service.ProcessImageService;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.admin.TimerInstance;
import org.kie.server.api.model.definition.NodeDefinition;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.TimerDefinition;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.api.model.instance.WorkItemInstance;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.admin.ProcessAdminServicesClient;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteProcessRuntimeDataServiceImplTest {
    private final Long processInstanceId = 1L;
    private final String processId = "processId";
    private final String containerId = "containerId";
    private final String serverTemplateId = "serverTemplateId";
    @Mock
    private KieServerIntegration kieServerIntegration;
    @Mock
    private QueryServicesClient queryServicesClient;
    @Mock
    private ProcessAdminServicesClient processAdminServicesClient;
    @Mock
    private ProcessServicesClient processServicesClient;
    @Mock
    private ProcessImageService processImageService;
    @InjectMocks
    private RemoteProcessRuntimeDataServiceImpl service;

    @Before
    public void setup() {
        KieServicesClient kieServicesClient = (KieServicesClient)Mockito.mock(KieServicesClient.class);
        Mockito.when((Object)this.kieServerIntegration.getServerClient(Matchers.anyString())).thenReturn((Object)kieServicesClient);
        Mockito.when((Object)((QueryServicesClient)kieServicesClient.getServicesClient(QueryServicesClient.class))).thenReturn((Object)this.queryServicesClient);
        Mockito.when((Object)((ProcessServicesClient)kieServicesClient.getServicesClient(ProcessServicesClient.class))).thenReturn((Object)this.processServicesClient);
        Mockito.when((Object)((ProcessAdminServicesClient)kieServicesClient.getServicesClient(ProcessAdminServicesClient.class))).thenReturn((Object)this.processAdminServicesClient);
    }

    @Test
    public void getProcessInstanceDetailsTest() {
        Long processInstanceId = 1L;
        TaskSummary taskSummaryMock = (TaskSummary)Mockito.mock(TaskSummary.class);
        TaskSummaryList taskSummaryListSpy = (TaskSummaryList)Mockito.spy((Object)new TaskSummaryList(Collections.singletonList(taskSummaryMock)));
        ProcessInstance processInstanceSpy = (ProcessInstance)Mockito.spy((Object)ProcessInstance.builder().activeUserTasks(taskSummaryListSpy).build());
        Mockito.when((Object)this.queryServicesClient.findProcessInstanceById(processInstanceId)).thenReturn((Object)processInstanceSpy);
        this.service.getProcessInstance(new ProcessInstanceKey("serverTemplateId", "containerId", processInstanceId));
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getProcessId();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getState();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getContainerId();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getProcessVersion();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getCorrelationKey();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getParentId();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getSlaCompliance();
        ((ProcessInstance)Mockito.verify((Object)processInstanceSpy)).getSlaDueDate();
        this.verifyActiveUserTasks(taskSummaryListSpy, taskSummaryMock);
        this.verifyCurrentActivities(processInstanceId);
    }

    public void verifyActiveUserTasks(TaskSummaryList taskSummaryList, TaskSummary taskSummary) {
        ((TaskSummaryList)Mockito.verify((Object)taskSummaryList)).getItems();
        ((TaskSummary)Mockito.verify((Object)taskSummary)).getName();
        ((TaskSummary)Mockito.verify((Object)taskSummary)).getStatus();
        ((TaskSummary)Mockito.verify((Object)taskSummary)).getActualOwner();
    }

    private void verifyCurrentActivities(Long processInstanceId) {
        NodeInstance nodeInstanceMock = (NodeInstance)Mockito.mock(NodeInstance.class);
        List<NodeInstance> nodeInstanceList = Collections.singletonList(nodeInstanceMock);
        Mockito.when((Object)this.queryServicesClient.findActiveNodeInstances(processInstanceId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE))).thenReturn(nodeInstanceList);
        Mockito.when((Object)nodeInstanceMock.getDate()).thenReturn((Object)new Date());
        ProcessInstanceKey instanceKey = new ProcessInstanceKey("serverTemplateId", "containerId", processInstanceId);
        this.service.getProcessInstanceActiveNodes(instanceKey);
        ((QueryServicesClient)Mockito.verify((Object)this.queryServicesClient)).findActiveNodeInstances(processInstanceId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        ((NodeInstance)Mockito.verify((Object)nodeInstanceMock)).getDate();
        ((NodeInstance)Mockito.verify((Object)nodeInstanceMock)).getId();
        ((NodeInstance)Mockito.verify((Object)nodeInstanceMock)).getName();
        ((NodeInstance)Mockito.verify((Object)nodeInstanceMock)).getNodeType();
    }

    @Test
    public void testInvalidServerTemplate() throws Exception {
        Method[] methods;
        for (Method method : methods = ProcessRuntimeDataService.class.getMethods()) {
            Class<?> returnType = method.getReturnType();
            Class<?>[] parameterType = method.getParameterTypes();
            Object[] args = new Object[method.getParameterCount()];
            Object result = method.invoke((Object)this.service, args);
            this.assertMethodResult(method, returnType, result);
            if (parameterType[0].isAssignableFrom(String.class)) {
                args[0] = "";
            } else if (parameterType[0].isAssignableFrom(ProcessInstanceKey.class)) {
                args[0] = new ProcessInstanceKey("", "", null);
            }
            result = method.invoke((Object)this.service, args);
            this.assertMethodResult(method, returnType, result);
        }
    }

    private void assertMethodResult(Method method, Class<?> returnType, Object result) {
        if (Collection.class.isAssignableFrom(returnType)) {
            Assert.assertNotNull((String)String.format("Returned collection for method %s should not be null", method.getName()), (Object)result);
            Assert.assertTrue((String)String.format("Returned collection for method %s should be empty", method.getName()), (boolean)((Collection)result).isEmpty());
        } else {
            Assert.assertNull((String)String.format("Returned object for method %s should be null", method.getName()), (Object)result);
        }
    }

    @Test
    public void testGetProcesses() {
        ProcessDefinition def = ProcessDefinition.builder().id("processId").nodes(Collections.emptyList()).timers(Collections.emptyList()).build();
        Mockito.when((Object)this.queryServicesClient.findProcesses(Integer.valueOf(0), Integer.valueOf(10), "", true)).thenReturn(Collections.singletonList(def));
        List summaries = this.service.getProcesses("serverTemplateId", Integer.valueOf(0), Integer.valueOf(10), "", Boolean.valueOf(true));
        Assert.assertNotNull((Object)summaries);
        Assert.assertEquals((long)1L, (long)summaries.size());
        ProcessSummaryMapperTest.assertProcessSummary(def, (ProcessSummary)summaries.get(0));
    }

    @Test
    public void testGetProcessesByFilter() {
        ProcessDefinition def = ProcessDefinition.builder().id("processId").timers(Collections.emptyList()).nodes(Collections.emptyList()).build();
        Mockito.when((Object)this.queryServicesClient.findProcesses("filter", Integer.valueOf(0), Integer.valueOf(10), "", true)).thenReturn(Collections.singletonList(def));
        List summaries = this.service.getProcessesByFilter("serverTemplateId", "filter", Integer.valueOf(0), Integer.valueOf(10), "", Boolean.valueOf(true));
        Assert.assertNotNull((Object)summaries);
        Assert.assertEquals((long)1L, (long)summaries.size());
        ProcessSummaryMapperTest.assertProcessSummary(def, (ProcessSummary)summaries.get(0));
    }

    @Test
    public void testGetProcess() {
        ProcessDefinition def = ProcessDefinition.builder().id("processId").nodes(Collections.emptyList()).timers(Collections.emptyList()).build();
        Mockito.when((Object)this.processServicesClient.getProcessDefinition("containerId", "processId")).thenReturn((Object)def);
        ProcessDefinitionKey pdk = new ProcessDefinitionKey("serverTemplateId", "containerId", "processId");
        ProcessSummary summary = this.service.getProcess(pdk);
        Assert.assertNotNull((Object)summary);
        ProcessSummaryMapperTest.assertProcessSummary(def, summary);
    }

    @Test
    public void testGetWorkItemByProcessInstanceId() {
        Long workItemId = 1L;
        Long processInstanceId = 2L;
        WorkItemInstance workItem = WorkItemInstance.builder().id(workItemId).parameters(Collections.singletonMap("key", "value")).build();
        Mockito.when((Object)this.processServicesClient.getWorkItem("containerId", processInstanceId, workItemId)).thenReturn((Object)workItem);
        WorkItemSummary summary = this.service.getWorkItemByProcessInstanceId("serverTemplateId", "containerId", processInstanceId, workItemId);
        Assert.assertNotNull((Object)summary);
        WorkItemSummaryMapperTest.assertWorkItemSummary(workItem, summary);
    }

    @Test
    public void testGetProcessInstanceActiveNodes() {
        ProcessInstanceKey instanceKey = new ProcessInstanceKey("serverTemplateId", "containerId", this.processInstanceId);
        List<NodeInstance> nodeInstances = Arrays.asList(NodeInstance.builder().id(Long.valueOf(1L)).name("name-1").nodeType("HumanTask").build(), NodeInstance.builder().id(Long.valueOf(2L)).name(" ").nodeType("Split").build());
        Mockito.when((Object)this.queryServicesClient.findActiveNodeInstances(instanceKey.getProcessInstanceId(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE))).thenReturn(nodeInstances);
        List nodes = this.service.getProcessInstanceActiveNodes(instanceKey);
        ((ListAssert)Assertions.assertThat((List)nodes).hasSize(2)).containsExactly((Object[])new NodeInstanceSummary[]{NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withType("HumanTask").build(), NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withType("Split").build()});
    }

    @Test
    public void testGetProcessInstanceCompletedNodes() {
        ProcessInstanceKey instanceKey = new ProcessInstanceKey("serverTemplateId", "containerId", this.processInstanceId);
        List<NodeInstance> nodeInstances = Arrays.asList(NodeInstance.builder().id(Long.valueOf(1L)).name("name-1").nodeType("HumanTask").build(), NodeInstance.builder().id(Long.valueOf(2L)).name(" ").nodeType("Split").build());
        Mockito.when((Object)this.queryServicesClient.findCompletedNodeInstances(instanceKey.getProcessInstanceId(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE))).thenReturn(nodeInstances);
        List nodes = this.service.getProcessInstanceCompletedNodes(instanceKey);
        ((ListAssert)Assertions.assertThat((List)nodes).hasSize(2)).containsExactly((Object[])new NodeInstanceSummary[]{NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withType("HumanTask").build(), NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withType("Split").build()});
    }

    @Test
    public void testGetProcessInstanceTimerInstances() {
        ProcessInstanceKey instanceKey = new ProcessInstanceKey("serverTemplateId", "containerId", this.processInstanceId);
        List<TimerInstance> timerInstances = Arrays.asList(TimerInstance.builder().id(1L).timerId(0L).timerName("timer1").period(2L).delay(1L).build(), TimerInstance.builder().id(2L).timerId(1L).timerName("time2").period(1L).delay(2L).build());
        Mockito.when((Object)this.processAdminServicesClient.getTimerInstances("containerId", this.processInstanceId)).thenReturn(timerInstances);
        List timers = this.service.getProcessInstanceTimerInstances(instanceKey);
        ((ListAssert)Assertions.assertThat((List)timers).hasSize(2)).containsExactly((Object[])new TimerInstanceSummary[]{TimerInstanceSummary.builder().withId(Long.valueOf(1L)).withTimerId(Long.valueOf(0L)).withName("timer1").withPeriod(Long.valueOf(2L)).withDelay(Long.valueOf(1L)).build(), TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withTimerId(Long.valueOf(1L)).withName("time2").withPeriod(Long.valueOf(1L)).withDelay(Long.valueOf(2L)).build()});
    }

    @Test
    public void testTriggerProcessInstanceNode() {
        ProcessInstanceKey instanceKey = new ProcessInstanceKey("serverTemplateId", "containerId", this.processInstanceId);
        Long nodeId = 2L;
        this.service.triggerProcessInstanceNode(instanceKey, nodeId);
        ((ProcessAdminServicesClient)Mockito.verify((Object)this.processAdminServicesClient)).triggerNode("containerId", this.processInstanceId, nodeId);
    }

    @Test
    public void testReTriggerProcessInstanceNode() {
        ProcessInstanceKey instanceKey = new ProcessInstanceKey("serverTemplateId", "containerId", this.processInstanceId);
        Long nodeId = 2L;
        this.service.reTriggerProcessInstanceNode(instanceKey, nodeId);
        ((ProcessAdminServicesClient)Mockito.verify((Object)this.processAdminServicesClient)).retriggerNodeInstance("containerId", this.processInstanceId, nodeId);
    }

    @Test
    public void testCancelProcessInstanceNode() {
        ProcessInstanceKey instanceKey = new ProcessInstanceKey("serverTemplateId", "containerId", this.processInstanceId);
        Long nodeId = 2L;
        this.service.cancelProcessInstanceNode(instanceKey, nodeId);
        ((ProcessAdminServicesClient)Mockito.verify((Object)this.processAdminServicesClient)).cancelNodeInstance("containerId", this.processInstanceId, nodeId);
    }

    @Test
    public void testGetProcessInstanceDiagramSummary() {
        ProcessInstanceKey instanceKey = new ProcessInstanceKey("serverTemplateId", "containerId", this.processInstanceId);
        String svgContent = "<svg></svg>";
        Long parentId = 2L;
        Integer state = 1;
        String processName = "process";
        Mockito.when((Object)this.queryServicesClient.findProcessInstanceById(this.processInstanceId)).thenReturn((Object)ProcessInstance.builder().id(this.processInstanceId).containerId("containerId").processId("processId").state(state).parentInstanceId(parentId).processName(processName).build());
        Mockito.when((Object)this.processImageService.getProcessInstanceDiagram("serverTemplateId", "containerId", this.processInstanceId, "", "", "", "")).thenReturn((Object)svgContent);
        List<NodeDefinition> processNodes = Arrays.asList(NodeDefinition.builder().id(Long.valueOf(1L)).name("name-1").type("HumanTask").uniqueId("_1").build(), NodeDefinition.builder().id(Long.valueOf(2L)).name(" ").type("Split").uniqueId("_2").build());
        List<TimerDefinition> timers = Arrays.asList(TimerDefinition.builder().id(Long.valueOf(1L)).nodeId(Long.valueOf(2L)).nodeName("name-1").uniqueId("_1").build(), TimerDefinition.builder().id(Long.valueOf(2L)).nodeId(Long.valueOf(0L)).nodeName(" ").uniqueId("_2").build());
        Mockito.when((Object)this.processServicesClient.getProcessDefinition("containerId", "processId")).thenReturn((Object)ProcessDefinition.builder().id("processId").nodes(processNodes).timers(timers).build());
        List<NodeInstance> activeNodeInstances = Arrays.asList(NodeInstance.builder().id(Long.valueOf(1L)).name("name-1").nodeType("HumanTask").build(), NodeInstance.builder().id(Long.valueOf(2L)).name(" ").nodeType("Split").build());
        Mockito.when((Object)this.queryServicesClient.findActiveNodeInstances(this.processInstanceId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE))).thenReturn(activeNodeInstances);
        List<NodeInstance> completedNodeInstances = Arrays.asList(NodeInstance.builder().id(Long.valueOf(3L)).name("name-3").nodeType("HumanTask").completed(Boolean.valueOf(true)).build(), NodeInstance.builder().id(Long.valueOf(4L)).name(" ").nodeType("End").completed(Boolean.valueOf(true)).build());
        Mockito.when((Object)this.queryServicesClient.findCompletedNodeInstances(this.processInstanceId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE))).thenReturn(completedNodeInstances);
        Mockito.when((Object)this.queryServicesClient.findProcessInstanceById(parentId)).thenReturn((Object)ProcessInstance.builder().id(parentId).containerId("containerId").processId("processId").state(state).parentInstanceId(Long.valueOf(-1L)).processName(processName).build());
        ProcessInstanceDiagramSummary summary = this.service.getProcessInstanceDiagramSummary(instanceKey, "", "", "", "");
        Assert.assertEquals((Object)this.processInstanceId, (Object)summary.getId());
        Assert.assertEquals((Object)processName, (Object)summary.getName());
        Assert.assertEquals((Object)svgContent, (Object)summary.getSvgContent());
        Assert.assertNotNull((Object)summary.getProcessDefinition());
        Assert.assertNotNull((Object)summary.getParentProcessInstanceSummary());
        Assert.assertEquals((Object)parentId, (Object)summary.getParentProcessInstanceSummary().getProcessInstanceId());
        ((IterableAssert)Assertions.assertThat((Iterable)summary.getProcessDefinition().getNodes()).hasSize(2)).containsExactly((Object[])new ProcessNodeSummary[]{new ProcessNodeSummary(Long.valueOf(1L), "name-1", "HumanTask", "_1"), new ProcessNodeSummary(Long.valueOf(2L), " ", "Split", "_2")});
        ((IterableAssert)Assertions.assertThat((Iterable)summary.getProcessDefinition().getTimers()).hasSize(2)).containsExactly((Object[])new TimerSummary[]{new TimerSummary(Long.valueOf(1L), Long.valueOf(2L), "name-1", "_1"), new TimerSummary(Long.valueOf(2L), Long.valueOf(0L), " ", "_2")});
        ((ListAssert)Assertions.assertThat((List)summary.getNodeInstances()).hasSize(4)).containsExactly((Object[])new NodeInstanceSummary[]{NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withType("HumanTask").build(), NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withType("Split").build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withType("End").withCompleted(Boolean.valueOf(true)).build()});
    }

    @Test
    public void testGetProcessInstanceDiagramSummaryCompletedStatus() {
        ProcessInstanceKey instanceKey = new ProcessInstanceKey("serverTemplateId", "containerId", this.processInstanceId);
        String svgContent = "<svg></svg>";
        Integer state = 2;
        String processName = "process";
        Mockito.when((Object)this.queryServicesClient.findProcessInstanceById(this.processInstanceId)).thenReturn((Object)ProcessInstance.builder().id(this.processInstanceId).processId("processId").containerId("containerId").state(state).parentInstanceId(Long.valueOf(-1L)).processName(processName).build());
        Mockito.when((Object)this.processImageService.getProcessInstanceDiagram("serverTemplateId", "containerId", this.processInstanceId, "", "", "", "")).thenReturn((Object)svgContent);
        Mockito.when((Object)this.processServicesClient.getProcessDefinition("containerId", "processId")).thenReturn((Object)new ProcessDefinition());
        ProcessInstanceDiagramSummary summary = this.service.getProcessInstanceDiagramSummary(instanceKey, "", "", "", "");
        Assert.assertEquals((Object)this.processInstanceId, (Object)summary.getId());
        Assert.assertEquals((Object)processName, (Object)summary.getName());
        Assert.assertEquals((Object)svgContent, (Object)summary.getSvgContent());
        Assert.assertNotNull((Object)summary.getProcessDefinition());
        Assertions.assertThat((Iterable)summary.getProcessDefinition().getNodes()).isEmpty();
        Assertions.assertThat((Iterable)summary.getProcessDefinition().getTimers()).isEmpty();
        Assertions.assertThat((List)summary.getNodeInstances()).isEmpty();
        ((QueryServicesClient)Mockito.verify((Object)this.queryServicesClient, (VerificationMode)Mockito.never())).findActiveNodeInstances((Long)Mockito.any(), (Integer)Mockito.any(), (Integer)Mockito.any());
        ((QueryServicesClient)Mockito.verify((Object)this.queryServicesClient, (VerificationMode)Mockito.never())).findCompletedNodeInstances((Long)Mockito.any(), (Integer)Mockito.any(), (Integer)Mockito.any());
        ((ProcessAdminServicesClient)Mockito.verify((Object)this.processAdminServicesClient, (VerificationMode)Mockito.never())).getTimerInstances((String)Mockito.any(), (Long)Mockito.any());
    }

    @Test
    public void testRescheduleTimerInstance() {
        ProcessInstanceKey instanceKey = new ProcessInstanceKey("serverTemplateId", "containerId", this.processInstanceId);
        TimerInstanceSummary summary = TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withRelative(Boolean.valueOf(false)).withDelay(Long.valueOf(3L)).withProcessInstanceId(Long.valueOf(1L)).withPeriod(Long.valueOf(4L)).withRepeatLimit(Integer.valueOf(1)).build();
        this.service.rescheduleTimerInstance(instanceKey, summary);
        ((ProcessAdminServicesClient)Mockito.verify((Object)this.processAdminServicesClient)).updateTimer("containerId", this.processInstanceId, ((Long)summary.getId()).longValue(), summary.getDelay().longValue(), summary.getPeriod().longValue(), summary.getRepeatLimit().intValue());
        summary.setRelative(Boolean.valueOf(true));
        this.service.rescheduleTimerInstance(instanceKey, summary);
        ((ProcessAdminServicesClient)Mockito.verify((Object)this.processAdminServicesClient)).updateTimerRelative("containerId", this.processInstanceId, ((Long)summary.getId()).longValue(), summary.getDelay().longValue(), summary.getPeriod().longValue(), summary.getRepeatLimit().intValue());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.processAdminServicesClient});
    }
}

