/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.Collections;
import org.jbpm.workbench.pr.backend.server.ProcessSummaryMapper;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.definition.ProcessDefinition;

public class ProcessSummaryMapperTest {
    public static void assertProcessSummary(ProcessDefinition pd, ProcessSummary ps) {
        Assert.assertNotNull((Object)ps);
        Assert.assertEquals((Object)pd.getId(), (Object)ps.getId());
        Assert.assertEquals((Object)pd.getId(), (Object)ps.getProcessDefId());
        Assert.assertEquals((Object)pd.getName(), (Object)ps.getName());
        Assert.assertEquals((Object)pd.getName(), (Object)ps.getProcessDefName());
        Assert.assertEquals((Object)pd.isDynamic(), (Object)ps.isDynamic());
        Assert.assertEquals((Object)pd.getVersion(), (Object)ps.getVersion());
        Assert.assertEquals((Object)pd.getContainerId(), (Object)ps.getDeploymentId());
        Assert.assertEquals((Object)pd.getAssociatedEntities(), (Object)ps.getAssociatedEntities());
        Assert.assertEquals((Object)pd.getProcessVariables(), (Object)ps.getProcessVariables());
        Assert.assertEquals((Object)pd.getReusableSubProcesses(), (Object)ps.getReusableSubProcesses());
        Assert.assertEquals((Object)pd.getServiceTasks(), (Object)ps.getServiceTasks());
    }

    @Test
    public void testProcessSummaryMapper_mapProcessSummary() {
        ProcessDefinition pd = new ProcessDefinition();
        pd.setName("definitionName");
        pd.setId("definitionId");
        pd.setDynamic(true);
        pd.setContainerId("containerId");
        pd.setVersion("1.0");
        pd.setAssociatedEntities(Collections.singletonMap("e1", new String[0]));
        pd.setProcessVariables(Collections.singletonMap("initiator", "String"));
        pd.setReusableSubProcesses(Collections.singletonList("processOne"));
        pd.setServiceTasks(Collections.singletonMap("email", "org.jbpm"));
        ProcessSummaryMapperTest.assertProcessSummary(pd, new ProcessSummaryMapper().apply(pd));
    }

    @Test
    public void testProcessSummaryMapper_mapNull() {
        Assert.assertNull((Object)new ProcessSummaryMapper().apply(null));
    }
}

