/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.workbench.pr.client.editors.definition.details;

import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessDefStyleEvent;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;

public abstract class BaseProcessDefDetailsPresenter {

    @Inject
    private Event<ProcessDefStyleEvent> processDefStyleEvent;

    private String currentProcessDefId = "";
    private String currentDeploymentId = "";
    private String currentServerTemplateId = "";

    public interface BaseProcessDefDetailsView extends IsWidget {

        void displayNotification( String text );

        HTML getProcessNameText();

        HTML getProcessIdText();

        HTML getDeploymentIdText();

    }

    protected void changeStyleRow( String processDefName, String processDefVersion ) {

        processDefStyleEvent.fire( new ProcessDefStyleEvent( processDefName, processDefVersion ) );
    }

    public void onProcessDefSelectionEvent( @Observes final ProcessDefSelectionEvent event ) {
        this.currentProcessDefId = event.getProcessId();
        this.currentDeploymentId = event.getDeploymentId();
        this.currentServerTemplateId = event.getServerTemplateId();
        refreshView( currentServerTemplateId, currentProcessDefId, currentDeploymentId );
        refreshProcessDef( currentServerTemplateId, currentDeploymentId, currentProcessDefId );
    }

    public abstract IsWidget getWidget();

    protected abstract void refreshView(  final String serverTemplateId, String currentProcessDefId, String currentDeploymentId );

    protected abstract void refreshProcessDef(  final String serverTemplateId, final String deploymentId, final String processId );
}
