/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list.variables.dash;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.common.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.workbench.common.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.base.AbstractListView;
import org.jbpm.workbench.common.client.list.base.AbstractScreenListPresenter;
import org.jbpm.workbench.common.client.list.base.events.SearchEvent;
import org.jbpm.workbench.common.client.menu.RestoreDefaultFiltersMenuBuilder;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetQueryHelper;
import org.jbpm.workbench.forms.client.display.process.QuickNewProcessInstancePopup;
import org.jbpm.workbench.pr.client.i18n.Constants;
import org.jbpm.workbench.pr.events.NewProcessInstanceEvent;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesWithDetailsRequestEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.service.ProcessService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.ext.widgets.common.client.menu.RefreshSelectorMenuBuilder;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="DataSet Process Instance List With Variables")
public class DataSetProcessInstanceWithVariablesListPresenter
extends AbstractScreenListPresenter<ProcessInstanceSummary> {
    public static final String SCREEN_ID = "DataSet Process Instance List With Variables";
    @Inject
    private DataSetProcessInstanceWithVariablesListView view;
    @Inject
    private DataSetQueryHelper dataSetQueryHelper;
    @Inject
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Inject
    private ErrorPopupPresenter errorPopup;
    private RefreshSelectorMenuBuilder refreshSelectorMenuBuilder = new RefreshSelectorMenuBuilder((RefreshSelectorMenuBuilder.SupportsRefreshInterval)this);
    @Inject
    private QuickNewProcessInstancePopup newProcessInstancePopup;
    protected final List<ProcessInstanceSummary> myProcessInstancesFromDataSet = new ArrayList<ProcessInstanceSummary>();
    private Caller<ProcessService> processService;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        try {
            if (!this.isAddingDefaultFilters()) {
                FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
                currentTableSettings.setServerTemplateId(this.selectedServerTemplate);
                currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("start_date");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                List<ColumnFilter> filters = this.getColumnFilters(this.textSearchStr);
                if (!filters.isEmpty()) {
                    if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                        currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    } else {
                        DataSetFilter filter = new DataSetFilter();
                        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                        currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                    }
                }
                this.dataSetQueryHelper.setCurrentTableSettings(currentTableSettings);
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), this.createDataSetProcessInstanceCallback(visibleRange.getStart(), currentTableSettings));
            }
        }
        catch (Exception e) {
            this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(e.getMessage()));
            this.view.hideBusyIndicator();
        }
    }

    protected List<ColumnFilter> getColumnFilters(String searchString) {
        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
        if (searchString != null && searchString.trim().length() > 0) {
            try {
                Long instanceId = Long.valueOf(searchString.trim());
                filters.add(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)instanceId));
            }
            catch (NumberFormatException ex) {
                filters.add(FilterFactory.equalsTo((String)"processId", (Comparable)((Object)searchString)));
                filters.add(FilterFactory.likeTo((String)"processName", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
                filters.add(FilterFactory.likeTo((String)"processInstanceDescription", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
                filters.add(FilterFactory.likeTo((String)"user_identity", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
            }
        }
        return filters;
    }

    protected DataSetReadyCallback createDataSetDomainSpecificCallback(final int startRange, FilterSettings tableSettings, final boolean lastPage) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (AbstractListView.BasicListView)this.view, tableSettings.getUUID()){

            public void callback(DataSet dataSet) {
                HashSet<String> columns = new HashSet<String>();
                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                    Long processInstanceId = DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnLongValue(dataSet, "processInstanceId", i);
                    String variableName = DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "variableId", i);
                    String variableValue = DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "value", i);
                    for (ProcessInstanceSummary pis : DataSetProcessInstanceWithVariablesListPresenter.this.myProcessInstancesFromDataSet) {
                        if (!pis.getProcessInstanceId().equals(processInstanceId)) continue;
                        pis.addDomainData(variableName, variableValue);
                        columns.add(variableName);
                    }
                }
                DataSetProcessInstanceWithVariablesListPresenter.this.view.addDomainSpecifColumns((ExtendedPagedTable<ProcessInstanceSummary>)DataSetProcessInstanceWithVariablesListPresenter.this.view.getListGrid(), columns);
                DataSetProcessInstanceWithVariablesListPresenter.this.updateDataOnCallback(DataSetProcessInstanceWithVariablesListPresenter.this.myProcessInstancesFromDataSet, startRange, startRange + DataSetProcessInstanceWithVariablesListPresenter.this.myProcessInstancesFromDataSet.size(), lastPage);
            }
        };
    }

    protected DataSetReadyCallback createDataSetProcessInstanceCallback(final int startRange, final FilterSettings tableSettings) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (AbstractListView.BasicListView)this.view, tableSettings.getUUID()){

            public void callback(DataSet dataSet) {
                if (dataSet != null && DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(tableSettings.getKey())) {
                    DataSetProcessInstanceWithVariablesListPresenter.this.myProcessInstancesFromDataSet.clear();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        DataSetProcessInstanceWithVariablesListPresenter.this.myProcessInstancesFromDataSet.add(DataSetProcessInstanceWithVariablesListPresenter.this.createProcessInstanceSummaryFromDataSet(dataSet, i));
                    }
                    List ops = tableSettings.getDataSetLookup().getOperationList();
                    String filterValue = DataSetProcessInstanceWithVariablesListPresenter.this.isFilteredByProcessId(ops);
                    boolean lastPage = false;
                    if (dataSet.getRowCount() < DataSetProcessInstanceWithVariablesListPresenter.this.view.getListGrid().getPageSize()) {
                        lastPage = true;
                    }
                    if (filterValue != null) {
                        DataSetProcessInstanceWithVariablesListPresenter.this.getDomainSpecifDataForProcessInstances(startRange, filterValue, lastPage);
                    } else {
                        DataSetProcessInstanceWithVariablesListPresenter.this.updateDataOnCallback(DataSetProcessInstanceWithVariablesListPresenter.this.myProcessInstancesFromDataSet, startRange, startRange + DataSetProcessInstanceWithVariablesListPresenter.this.myProcessInstancesFromDataSet.size(), lastPage);
                    }
                }
                DataSetProcessInstanceWithVariablesListPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    protected String isFilteredByProcessId(List<DataSetOp> ops) {
        for (DataSetOp dataSetOp : ops) {
            if (!dataSetOp.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List filters = ((DataSetFilter)dataSetOp).getColumnFilterList();
            for (ColumnFilter filter : filters) {
                List parameters;
                if (!(filter instanceof CoreFunctionFilter)) continue;
                CoreFunctionFilter coreFilter = (CoreFunctionFilter)filter;
                if (!filter.getColumnId().toUpperCase().equals("processId".toUpperCase()) || ((CoreFunctionFilter)filter).getType() != CoreFunctionType.EQUALS_TO || (parameters = coreFilter.getParameters()).size() <= 0) continue;
                return parameters.get(0).toString();
            }
        }
        return null;
    }

    public void getDomainSpecifDataForProcessInstances(int startRange, String filterValue, boolean lastPage) {
        FilterSettings variablesTableSettings = this.view.getVariablesTableSettings(filterValue);
        variablesTableSettings.setServerTemplateId(this.selectedServerTemplate);
        variablesTableSettings.setTablePageSize(-1);
        this.dataSetQueryHelperDomainSpecific.setDataSetHandler(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setCurrentTableSettings(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setLastOrderedColumn("processInstanceId");
        this.dataSetQueryHelperDomainSpecific.setLastSortOrder(SortOrder.ASCENDING);
        this.dataSetQueryHelperDomainSpecific.lookupDataSet(Integer.valueOf(0), this.createDataSetDomainSpecificCallback(startRange, variablesTableSettings, lastPage));
    }

    protected ProcessInstanceSummary createProcessInstanceSummaryFromDataSet(DataSet dataSet, int i) {
        return new ProcessInstanceSummary(this.dataSetQueryHelper.getColumnLongValue(dataSet, "processInstanceId", i).longValue(), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processId", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "externalId", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processName", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processVersion", i), this.dataSetQueryHelper.getColumnIntValue(dataSet, "status", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "start_date", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "end_date", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "user_identity", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processInstanceDescription", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "correlationKey", i), this.dataSetQueryHelper.getColumnLongValue(dataSet, "parentProcessInstanceId", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "lastModificationDate", i));
    }

    public void newInstanceCreated(@Observes NewProcessInstanceEvent pi) {
        this.refreshGrid();
    }

    public void newInstanceCreated(@Observes ProcessInstancesUpdateEvent pis) {
        this.refreshGrid();
    }

    @OnOpen
    public void onOpen() {
        this.textSearchStr = this.place.getParameter("processDefinitionId", "");
        super.onOpen();
    }

    public void abortProcessInstance(String containerId, long processInstanceId) {
        ((ProcessService)this.processService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceWithVariablesListPresenter.this.refreshGrid();
            }
        })).abortProcessInstance(this.selectedServerTemplate, containerId, Long.valueOf(processInstanceId));
    }

    public void abortProcessInstance(List<String> containers, List<Long> processInstanceIds) {
        ((ProcessService)this.processService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceWithVariablesListPresenter.this.refreshGrid();
            }
        })).abortProcessInstances(this.selectedServerTemplate, containers, processInstanceIds);
    }

    public void bulkSignal(List<ProcessInstanceSummary> processInstances) {
        if (processInstances == null || processInstances.isEmpty()) {
            return;
        }
        StringBuilder processIdsParam = new StringBuilder();
        StringBuilder deploymentIdsParam = new StringBuilder();
        for (ProcessInstanceSummary selected : processInstances) {
            if (selected.getState() != 1) {
                this.view.displayNotification(Constants.INSTANCE.Signaling_Process_Instance_Not_Allowed(selected.getId()));
                continue;
            }
            processIdsParam.append(selected.getId() + ",");
            deploymentIdsParam.append(selected.getDeploymentId() + ",");
        }
        if (processIdsParam.length() == 0) {
            return;
        }
        processIdsParam.deleteCharAt(processIdsParam.length() - 1);
        deploymentIdsParam.deleteCharAt(deploymentIdsParam.length() - 1);
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", processIdsParam.toString());
        placeRequestImpl.addParameter("deploymentId", deploymentIdsParam.toString());
        placeRequestImpl.addParameter("serverTemplateId", this.selectedServerTemplate);
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
        this.view.displayNotification(Constants.INSTANCE.Signaling_Process_Instance());
    }

    public void bulkAbort(List<ProcessInstanceSummary> processInstances) {
        if (processInstances == null || processInstances.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<String> containers = new ArrayList<String>();
        for (ProcessInstanceSummary selected : processInstances) {
            if (selected.getState() != 1) {
                this.view.displayNotification(Constants.INSTANCE.Aborting_Process_Instance_Not_Allowed(selected.getId()));
                continue;
            }
            ids.add(selected.getProcessInstanceId());
            containers.add(selected.getDeploymentId());
            this.view.displayNotification(Constants.INSTANCE.Aborting_Process_Instance(selected.getId()));
        }
        if (ids.size() > 0) {
            this.abortProcessInstance(containers, ids);
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.Process_Instances();
    }

    @WorkbenchPartView
    public UberView<DataSetProcessInstanceWithVariablesListPresenter> getView() {
        return this.view;
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Process_Instance()).respondsWith(new Command(){

            public void execute() {
                if (DataSetProcessInstanceWithVariablesListPresenter.this.selectedServerTemplate != null && !DataSetProcessInstanceWithVariablesListPresenter.this.selectedServerTemplate.isEmpty()) {
                    DataSetProcessInstanceWithVariablesListPresenter.this.newProcessInstancePopup.show(DataSetProcessInstanceWithVariablesListPresenter.this.selectedServerTemplate);
                } else {
                    DataSetProcessInstanceWithVariablesListPresenter.this.view.displayNotification(Constants.INSTANCE.SelectServerTemplate());
                }
            }
        })).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.serverTemplateSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.refreshSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RestoreDefaultFiltersMenuBuilder((RestoreDefaultFiltersMenuBuilder.SupportsRestoreDefaultFilters)this)).endMenu()).build();
    }

    public void onGridPreferencesStoreLoaded() {
        this.refreshSelectorMenuBuilder.loadOptions(this.view.getRefreshValue());
    }

    public void onUpdateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        super.onUpdateRefreshInterval(enableAutoRefresh, newInterval);
        this.view.saveRefreshValue(newInterval);
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
    }

    protected List<ProcessInstanceSummary> getDisplayedProcessInstances() {
        return this.myProcessInstancesFromDataSet;
    }

    public void signalProcessInstance(ProcessInstanceSummary processInstance) {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", Long.toString(processInstance.getProcessInstanceId()));
        placeRequestImpl.addParameter("deploymentId", processInstance.getDeploymentId());
        placeRequestImpl.addParameter("serverTemplateId", this.selectedServerTemplate);
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void selectProcessInstance(ProcessInstanceSummary summary, Boolean close) {
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Process Instance Details Multi"));
        if (status == PlaceStatus.CLOSE) {
            this.placeManager.goTo("Process Instance Details Multi");
            this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(summary.getDeploymentId(), summary.getProcessInstanceId(), summary.getProcessId(), summary.getProcessName(), Integer.valueOf(summary.getState()), this.selectedServerTemplate));
        } else if (status == PlaceStatus.OPEN && !close.booleanValue()) {
            this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(summary.getDeploymentId(), summary.getProcessInstanceId(), summary.getProcessId(), summary.getProcessName(), Integer.valueOf(summary.getState()), this.selectedServerTemplate));
        } else if (status == PlaceStatus.OPEN && close.booleanValue()) {
            this.placeManager.closePlace("Process Instance Details Multi");
        }
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstancesWithDetailsRequestEvent event) {
        this.placeManager.goTo("Process Instance Details Multi");
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(event.getDeploymentId(), event.getProcessInstanceId(), event.getProcessDefId(), event.getProcessDefName(), event.getProcessInstanceStatus(), event.getServerTemplateId()));
    }

    public void formClosed(@Observes BeforeClosePlaceEvent closed) {
        if ("Signal Process Popup".equals(closed.getPlace().getIdentifier())) {
            this.refreshGrid();
        }
    }

    @Inject
    public void setProcessService(Caller<ProcessService> processService) {
        this.processService = processService;
    }

    public static interface DataSetProcessInstanceWithVariablesListView
    extends AbstractListView.ListView<ProcessInstanceSummary, DataSetProcessInstanceWithVariablesListPresenter> {
        public int getRefreshValue();

        public void saveRefreshValue(int var1);

        public FilterSettings getVariablesTableSettings(String var1);

        public void addDomainSpecifColumns(ExtendedPagedTable<ProcessInstanceSummary> var1, Set<String> var2);

        public void applyFilterOnPresenter(String var1);
    }
}

