/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.variables.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.workbench.pr.client.editors.variables.list.ProcessVariableListPresenter;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.jbpm.workbench.pr.service.ProcessVariablesService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessVariableListPresenterTest {
    @Mock
    ProcessVariableListPresenter.ProcessVariableListView view;
    @Mock
    ExtendedPagedTable extendedPagedTable;
    Caller<ProcessVariablesService> variablesServicesCaller;
    @Mock
    ProcessVariablesService processVariablesService;
    ProcessVariableListPresenter presenter;

    @Before
    public void setup() {
        this.variablesServicesCaller = new CallerMock((Object)this.processVariablesService);
        this.presenter = new ProcessVariableListPresenter(this.view, this.variablesServicesCaller);
    }

    @Test
    public void testLoadVariableHistory() {
        ParameterizedCommand callback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        String variableName = "variable";
        String deploymentId = "deploymentId";
        long processInstanceId = 1L;
        ProcessVariableSummary summary = new ProcessVariableSummary("variable", "variableInstanceId", 1L, "oldValue", "newValue", System.currentTimeMillis(), "type");
        List<ProcessVariableSummary> summaries = Arrays.asList(summary);
        Mockito.when((Object)this.processVariablesService.getVariableHistory(Mockito.anyString(), (String)Mockito.eq((Object)"deploymentId"), Long.valueOf(Mockito.eq((long)1L)), (String)Mockito.eq((Object)"variable"))).thenReturn(summaries);
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)this.extendedPagedTable);
        ProcessInstanceSelectionEvent event = new ProcessInstanceSelectionEvent("deploymentId", Long.valueOf(1L), "processDefId", "processDefName", Integer.valueOf(1), "serverTemplateIdTest");
        this.presenter.onProcessInstanceSelectionEvent(event);
        this.presenter.loadVariableHistory(callback, "variable");
        ((ParameterizedCommand)Mockito.verify((Object)callback)).execute(summaries);
    }
}

