/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.pr.client.util.LogUtils;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.RuntimeLogSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;

@Dependent
public class RuntimeLogPresenter {
    private Long currentProcessInstanceId;
    private String currentProcessName;
    private String currentServerTemplateId;
    private String currentDeploymentId;
    @Inject
    private RuntimeLogView view;
    @Inject
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public void refreshProcessInstanceData(final LogUtils.LogOrder logOrder, LogUtils.LogType logType) {
        if (LogUtils.LogType.TECHNICAL.equals((Object)logType)) {
            ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<List<RuntimeLogSummary>>(){

                public void callback(List<RuntimeLogSummary> logs) {
                    ArrayList<String> logsLine = new ArrayList<String>();
                    if (logOrder == LogUtils.LogOrder.DESC) {
                        Collections.reverse(logs);
                    }
                    for (RuntimeLogSummary rls : logs) {
                        logsLine.add(rls.getTime() + ": " + rls.getLogLine() + " - " + rls.getType());
                    }
                    RuntimeLogPresenter.this.view.setLogs(logsLine);
                }
            })).getRuntimeLogs(this.currentServerTemplateId, this.currentDeploymentId, this.currentProcessInstanceId);
        } else {
            ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<List<RuntimeLogSummary>>(){

                public void callback(List<RuntimeLogSummary> logs) {
                    ArrayList<String> logsLine = new ArrayList<String>();
                    if (logOrder == LogUtils.LogOrder.DESC) {
                        Collections.reverse(logs);
                    }
                    for (RuntimeLogSummary rls : logs) {
                        logsLine.add(rls.getTime() + ": " + rls.getLogLine());
                    }
                    RuntimeLogPresenter.this.view.setLogs(logsLine);
                }
            })).getBusinessLogs(this.currentServerTemplateId, this.currentDeploymentId, this.currentProcessName, this.currentProcessInstanceId);
        }
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.currentProcessInstanceId = event.getProcessInstanceId();
        this.currentProcessName = event.getProcessDefName();
        this.currentServerTemplateId = event.getServerTemplateId();
        this.currentDeploymentId = event.getDeploymentId();
        this.refreshProcessInstanceData(LogUtils.LogOrder.ASC, LogUtils.LogType.BUSINESS);
    }

    public static interface RuntimeLogView
    extends IsWidget {
        public void init(RuntimeLogPresenter var1);

        public void setLogs(List<String> var1);
    }
}

