/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.common.collect.Lists;
import com.google.gwt.dev.util.collect.HashSet;
import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.events.SearchEvent;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsJSONMarshaller;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListViewImpl;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.service.ProcessService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceListPresenterTest {
    @Mock
    protected PlaceManager placeManager;
    private CallerMock<ProcessService> remoteProcessServiceCaller;
    @Mock
    private ProcessService processService;
    @Mock
    private ProcessInstanceListViewImpl viewMock;
    @Mock
    private DataSetQueryHelper dataSetQueryHelper;
    @Mock
    private DataSet dataSet;
    @Mock
    private DataSet dataSetProcessVar;
    @Mock
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Mock
    private ExtendedPagedTable extendedPagedTable;
    @Spy
    private FilterSettings filterSettings;
    @Mock
    private FilterSettingsJSONMarshaller filterSettingsJSONMarshaller;
    @Spy
    private DataSetLookup dataSetLookup;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private User identity;
    private ArrayList<ProcessInstanceSummary> processInstanceSummaries;
    @InjectMocks
    private ProcessInstanceListPresenter presenter;

    public static ProcessInstanceSummary createProcessInstanceSummary(Long key) {
        return ProcessInstanceListPresenterTest.createProcessInstanceSummary(key, 1);
    }

    public static ProcessInstanceSummary createProcessInstanceSummary(Long key, Integer status) {
        return new ProcessInstanceSummary(key, "procTest", "test.0.1", "Test Proc", "1.0", status, new Date(), new Date(), "intiatior", "procTestInstanceDesc", "cKey", Long.valueOf(0L), new Date(), Integer.valueOf(0));
    }

    protected static void testProcessInstanceStatusCondition(Predicate<ProcessInstanceSummary> predicate, Integer ... validStatutes) {
        ArrayList allStatus = Lists.newArrayList((Object[])new Integer[]{3, 1, 2, 0, 4});
        List<Integer> validStatuses = Arrays.asList(validStatutes);
        allStatus.removeAll(validStatuses);
        allStatus.forEach(s -> Assert.assertFalse((boolean)predicate.test(ProcessInstanceListPresenterTest.createProcessInstanceSummary(1L, s))));
        validStatuses.forEach(s -> Assert.assertTrue((boolean)predicate.test(ProcessInstanceListPresenterTest.createProcessInstanceSummary(1L, s))));
    }

    @Before
    public void setupMocks() {
        this.remoteProcessServiceCaller = new CallerMock((Object)this.processService);
        this.processInstanceSummaries = this.createProcessInstanceSummaryList(5);
        Mockito.when((Object)this.filterSettings.getDataSetLookup()).thenReturn((Object)this.dataSetLookup);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn((Object)this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.filterSettingsJSONMarshaller.fromJsonString(Mockito.anyString())).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.viewMock.getAdvancedSearchFilterSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.filterSettings.getKey()).thenReturn((Object)"key");
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(ProcessInstanceListPresenterTest.this.dataSet);
                return null;
            }
        }).when((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(ProcessInstanceListPresenterTest.this.dataSetProcessVar);
                return null;
            }
        }).when((Object)this.dataSetQueryHelperDomainSpecific)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        this.presenter.setProcessService(this.remoteProcessServiceCaller);
    }

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).hideBusyIndicator();
    }

    @Test
    public void isFilteredByProcessIdTest() {
        String processId = "testProc";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"processId", (Comparable)((Object)"testProc"))});
        String filterProcessId = this.presenter.isFilteredByProcessId(Collections.singletonList(filter));
        Assert.assertEquals((Object)"testProc", (Object)filterProcessId);
    }

    @Test
    public void isFilteredByProcessIdInvalidTest() {
        String processId = "testProc";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.likeTo((String)"processId", (String)"testProc")});
        String filterProcessId = this.presenter.isFilteredByProcessId(Collections.singletonList(filter));
        Assert.assertNull((Object)filterProcessId);
    }

    @Test
    public void abortProcessInstanceTest() {
        Long processInstanceId = new Random().nextLong();
        String containerId = "container";
        this.presenter.abortProcessInstance("container", processInstanceId.longValue());
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstance(Mockito.anyString(), (String)Mockito.eq((Object)"container"), (Long)Mockito.eq((Object)processInstanceId));
    }

    @Test
    public void abortProcessInstancesTest() {
        Random random = new Random();
        ArrayList<String> containers = new ArrayList<String>();
        containers.add("container");
        ArrayList<Long> pIds = new ArrayList<Long>();
        pIds.add(random.nextLong());
        pIds.add(random.nextLong());
        pIds.add(random.nextLong());
        this.presenter.abortProcessInstance(containers, pIds);
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstances(Mockito.anyString(), (List)Mockito.eq(containers), (List)Mockito.eq(pIds));
    }

    @Test
    public void bulkAbortProcessInstancesTest() {
        ArrayList<Long> pIds = new ArrayList<Long>();
        ArrayList<String> containers = new ArrayList<String>();
        for (ProcessInstanceSummary summary : this.processInstanceSummaries) {
            pIds.add(summary.getProcessInstanceId());
            containers.add(summary.getDeploymentId());
        }
        this.presenter.bulkAbort(this.processInstanceSummaries);
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstances(Mockito.anyString(), (List)Mockito.eq(containers), (List)Mockito.eq(pIds));
    }

    @Test
    public void bulkAbortProcessInstancesStateTest() {
        this.processInstanceSummaries.add(ProcessInstanceListPresenterTest.createProcessInstanceSummary(new Random().nextLong(), 3));
        ArrayList<Long> pIds = new ArrayList<Long>();
        ArrayList<String> containers = new ArrayList<String>();
        for (ProcessInstanceSummary summary : this.processInstanceSummaries) {
            if (summary.getState() != 1) continue;
            pIds.add(summary.getProcessInstanceId());
            containers.add(summary.getDeploymentId());
        }
        this.presenter.bulkAbort(this.processInstanceSummaries);
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstances(Mockito.anyString(), (List)Mockito.eq(containers), (List)Mockito.eq(pIds));
    }

    @Test
    public void bulkSignalProcessInstanceSingleAbortedTest() {
        ArrayList<ProcessInstanceSummary> processInstanceSummaries = new ArrayList<ProcessInstanceSummary>();
        processInstanceSummaries.add(ProcessInstanceListPresenterTest.createProcessInstanceSummary(new Random().nextLong(), 3));
        this.presenter.bulkSignal(processInstanceSummaries);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)Mockito.any(PlaceRequest.class));
    }

    @Test
    public void bulkSignalProcessInstancesStateTest() {
        this.processInstanceSummaries.add(ProcessInstanceListPresenterTest.createProcessInstanceSummary(new Random().nextLong(), 3));
        ArrayList<Long> pIds = new ArrayList<Long>();
        for (ProcessInstanceSummary summary : this.processInstanceSummaries) {
            if (summary.getState() != 1) continue;
            pIds.add(summary.getProcessInstanceId());
        }
        this.presenter.bulkSignal(this.processInstanceSummaries);
        ArgumentCaptor placeRequest = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)placeRequest.capture());
        Assert.assertEquals((Object)"Signal Process Popup", (Object)((PlaceRequest)placeRequest.getValue()).getIdentifier());
        Assert.assertEquals((Object)StringUtils.join(pIds, (String)","), (Object)((PlaceRequest)placeRequest.getValue()).getParameter("processInstanceId", null));
    }

    @Test
    public void testSkipDomainSpecificColumnsForSearchTab() {
        this.presenter.setAddingDefaultFilters(false);
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"processId", (Comparable)((Object)"testProc"))});
        this.filterSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        this.filterSettings.setKey("base");
        Mockito.when((Object)this.filterSettings.getKey()).thenReturn((Object)"base");
        Mockito.when((Object)this.dataSet.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSet.getValueAt(0, "processInstanceId")).thenReturn((Object)1L);
        this.presenter.getData(new Range(0, 5));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.dataSetQueryHelperDomainSpecific});
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).hideBusyIndicator();
    }

    @Test
    public void getDomainSpecifDataForProcessInstancesTest() {
        this.presenter.setAddingDefaultFilters(false);
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"processId", (Comparable)((Object)"testProc"))});
        this.filterSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        Mockito.when((Object)this.dataSet.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSet.getValueAt(0, "processInstanceId")).thenReturn((Object)1L);
        Mockito.when((Object)this.dataSetProcessVar.getRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processInstanceId")).thenReturn((Object)1L);
        String processVariable1 = "var1";
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "variableId")).thenReturn((Object)processVariable1);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "value")).thenReturn((Object)"value1");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(1, "processInstanceId")).thenReturn((Object)1L);
        String processVariable2 = "var2";
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(1, "variableId")).thenReturn((Object)processVariable2);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(1, "value")).thenReturn((Object)"value2");
        Object expectedColumns = new HashSet();
        expectedColumns.add(processVariable1);
        expectedColumns.add(processVariable2);
        this.presenter.getData(new Range(0, 5));
        ArgumentCaptor argument = ArgumentCaptor.forClass(Set.class);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addDomainSpecifColumns((ExtendedPagedTable)Mockito.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals((Object)expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).setLastOrderedColumn("processInstanceId");
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).setLastSortOrder(SortOrder.ASCENDING);
        Mockito.when((Object)this.dataSetProcessVar.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processInstanceId")).thenReturn((Object)1L);
        processVariable1 = "varTest1";
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "variableId")).thenReturn((Object)processVariable1);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "value")).thenReturn((Object)"value1");
        expectedColumns = Collections.singleton(processVariable1);
        this.presenter.getData(new Range(0, 5));
        argument = ArgumentCaptor.forClass(Set.class);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).addDomainSpecifColumns((ExtendedPagedTable)Mockito.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals((Object)expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
    }

    public ArrayList<ProcessInstanceSummary> createProcessInstanceSummaryList(int listSize) {
        ArrayList<ProcessInstanceSummary> pIList = new ArrayList<ProcessInstanceSummary>();
        for (long i = 1L; i <= (long)listSize; ++i) {
            pIList.add(ProcessInstanceListPresenterTest.createProcessInstanceSummary(i));
        }
        return pIList;
    }

    @Test
    public void testEmptySearchString() {
        SearchEvent searchEvent = new SearchEvent("");
        this.presenter.onSearchEvent(searchEvent);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).applyFilterOnPresenter(Mockito.anyString());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
    }

    @Test
    public void testSearchString() {
        SearchEvent searchEvent = new SearchEvent(RandomStringUtils.random((int)10));
        this.presenter.onSearchEvent(searchEvent);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).applyFilterOnPresenter(Mockito.anyString());
        Assert.assertEquals((Object)searchEvent.getFilter(), (Object)this.presenter.getTextSearchStr());
    }

    @Test
    public void testSearchFilterEmpty() {
        List filters = this.presenter.getColumnFilters("");
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterNull() {
        List filters = this.presenter.getColumnFilters(null);
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterEmptyTrim() {
        List filters = this.presenter.getColumnFilters("     ");
        Assert.assertTrue((boolean)filters.isEmpty());
    }

    @Test
    public void testSearchFilterId() {
        List filters = this.presenter.getColumnFilters("1");
        Assert.assertEquals((long)1L, (long)filters.size());
        Assert.assertEquals((Object)"processInstanceId", (Object)((ColumnFilter)filters.get(0)).getColumnId());
    }

    @Test
    public void testSearchFilterIdTrim() {
        List filters = this.presenter.getColumnFilters(" 1 ");
        Assert.assertEquals((long)1L, (long)filters.size());
        Assert.assertEquals((Object)"processInstanceId", (Object)((ColumnFilter)filters.get(0)).getColumnId());
    }

    @Test
    public void testSearchFilterString() {
        List filters = this.presenter.getColumnFilters("processName");
        Assert.assertEquals((long)4L, (long)filters.size());
        Assert.assertEquals((Object)"processId", (Object)((ColumnFilter)filters.get(0)).getColumnId());
        Assert.assertEquals((Object)"processName", (Object)((ColumnFilter)filters.get(1)).getColumnId());
        Assert.assertEquals((Object)"processInstanceDescription", (Object)((ColumnFilter)filters.get(2)).getColumnId());
        Assert.assertEquals((Object)"user_identity", (Object)((ColumnFilter)filters.get(3)).getColumnId());
    }

    @Test
    public void testDataSetQueryHelperColumnMapping() {
        Long TEST_PROC_INST_ID = 55L;
        String TEST_PROC_ID = "TEST_PROC_ID";
        String TEST_EXT_ID = "TEST_EXT_ID";
        String TEST_PROC_NAME = "TEST_PROC_NAME";
        String TEST_PROC_VER = "TEST_PROC_VER";
        Integer TEST_STATE = 7;
        Date TEST_START_DATE = new Date(new Date().getTime() - 0x6DDD00L);
        Date TEST_END_DATE = new Date(new Date().getTime() + 0x6DDD00L);
        String TEST_IDENTITY = "TEST_IDENTITY";
        String TEST_INST_DESC = "TEST_INST_DESC";
        String TEST_CORREL_KEY = "TEST_CORREL_KEY";
        Long TEST_PARENT_PROC_INST_ID = 66L;
        Date TEST_LAST_MODIF_DATE = new Date();
        Integer TEST_ERROR_COUNT = 66;
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processInstanceId")).thenReturn((Object)TEST_PROC_INST_ID);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processId")).thenReturn((Object)"TEST_PROC_ID");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "externalId")).thenReturn((Object)"TEST_EXT_ID");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processName")).thenReturn((Object)"TEST_PROC_NAME");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processVersion")).thenReturn((Object)"TEST_PROC_VER");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "status")).thenReturn((Object)TEST_STATE);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "start_date")).thenReturn((Object)TEST_START_DATE);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "end_date")).thenReturn((Object)TEST_END_DATE);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "user_identity")).thenReturn((Object)"TEST_IDENTITY");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processInstanceDescription")).thenReturn((Object)"TEST_INST_DESC");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "correlationKey")).thenReturn((Object)"TEST_CORREL_KEY");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "parentProcessInstanceId")).thenReturn((Object)TEST_PARENT_PROC_INST_ID);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "lastModificationDate")).thenReturn((Object)TEST_LAST_MODIF_DATE);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "errorCount")).thenReturn((Object)TEST_ERROR_COUNT);
        ProcessInstanceSummary pis = this.presenter.createProcessInstanceSummaryFromDataSet(this.dataSetProcessVar, 0);
        Assert.assertEquals((Object)TEST_PROC_INST_ID, (Object)pis.getProcessInstanceId());
        Assert.assertEquals((Object)"TEST_PROC_ID", (Object)pis.getProcessId());
        Assert.assertEquals((Object)"TEST_EXT_ID", (Object)pis.getDeploymentId());
        Assert.assertEquals((Object)"TEST_PROC_NAME", (Object)pis.getProcessName());
        Assert.assertEquals((Object)"TEST_PROC_VER", (Object)pis.getProcessVersion());
        Assert.assertEquals((Object)TEST_STATE, (Object)pis.getState());
        Assert.assertEquals((Object)TEST_START_DATE, (Object)pis.getStartTime());
        Assert.assertEquals((Object)TEST_END_DATE, (Object)pis.getEndTime());
        Assert.assertEquals((Object)"TEST_IDENTITY", (Object)pis.getInitiator());
        Assert.assertEquals((Object)"TEST_INST_DESC", (Object)pis.getProcessInstanceDescription());
        Assert.assertEquals((Object)"TEST_CORREL_KEY", (Object)pis.getCorrelationKey());
        Assert.assertEquals((Object)TEST_PARENT_PROC_INST_ID, (Object)pis.getParentId());
        Assert.assertEquals((Object)TEST_LAST_MODIF_DATE, (Object)pis.getLastModificationDate());
        Assert.assertEquals((Object)TEST_ERROR_COUNT, (Object)pis.getErrorCount());
    }

    @Test
    public void testDefaultActiveSearchFilters() {
        this.presenter.setupDefaultActiveSearchFilters();
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.State()), (String)Mockito.eq((Object)Constants.INSTANCE.Active()), Mockito.eq((Object)String.valueOf(1)), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testActiveSearchFilters() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)place.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn(null);
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.State()), (String)Mockito.eq((Object)Constants.INSTANCE.Active()), Mockito.eq((Object)String.valueOf(1)), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testActiveSearchFiltersProcessDefinitionId() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        String processDefinitionId = "defId";
        Mockito.when((Object)place.getParameter("processDefinitionId", null)).thenReturn((Object)"defId");
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.Process_Definition_Id()), (String)Mockito.eq((Object)"defId"), Mockito.eq((Object)"defId"), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testActiveSearchFiltersProcessInstanceId() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        String processInstanceId = "1";
        Mockito.when((Object)place.getParameter("processDefinitionId", null)).thenReturn(null);
        Mockito.when((Object)place.getParameter("processInstanceId", null)).thenReturn((Object)"1");
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.Id()), (String)Mockito.eq((Object)"1"), Mockito.eq((Object)"1"), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testIsAuthorizedForTaskAdminView() {
        this.testIsAuthorizedForView("TaskAdmin");
    }

    @Test
    public void testIsAuthorizedForTaskView() {
        this.testIsAuthorizedForView("Tasks");
    }

    private void testIsAuthorizedForView(String perspectiveId) {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Assert.assertTrue((boolean)this.presenter.isUserAuthorizedForPerspective(perspectiveId));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ResourceRef.class);
        ((AuthorizationManager)Mockito.verify((Object)this.authorizationManager)).authorize((Resource)captor.capture(), (User)Mockito.eq((Object)this.identity));
        Assert.assertEquals((Object)perspectiveId, (Object)((ResourceRef)captor.getValue()).getIdentifier());
        Assert.assertEquals((Object)ActivityResourceType.PERSPECTIVE, (Object)((ResourceRef)captor.getValue()).getResourceType());
        Assert.assertFalse((boolean)this.presenter.isUserAuthorizedForPerspective(perspectiveId));
    }

    @Test
    public void testViewTasksActionCondition() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("TaskAdmin")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        Assert.assertTrue((boolean)this.presenter.getViewTasksActionCondition().test(new ProcessInstanceSummary()));
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("Tasks")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        Assert.assertTrue((boolean)this.presenter.getViewTasksActionCondition().test(new ProcessInstanceSummary()));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.presenter.getViewJobsActionCondition().test(new ProcessInstanceSummary()));
    }

    @Test
    public void testViewJobsActionCondition() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("Requests")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        Assert.assertTrue((boolean)this.presenter.getViewJobsActionCondition().test(new ProcessInstanceSummary()));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.presenter.getViewJobsActionCondition().test(new ProcessInstanceSummary()));
    }

    @Test
    public void testViewErrorsActionCondition() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("ExecutionErrors")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        ProcessInstanceSummary okProcInst = new ProcessInstanceSummary();
        ProcessInstanceSummary errProcInst = new ProcessInstanceSummary();
        errProcInst.setErrorCount(Integer.valueOf(1));
        Predicate viewErrCondition = this.presenter.getViewErrorsActionCondition();
        Assert.assertFalse((boolean)viewErrCondition.test(okProcInst));
        Assert.assertTrue((boolean)viewErrCondition.test(errProcInst));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Assert.assertFalse((boolean)viewErrCondition.test(okProcInst));
        Assert.assertFalse((boolean)viewErrCondition.test(errProcInst));
    }

    @Test
    public void testAbortActionCondition() {
        ProcessInstanceListPresenterTest.testProcessInstanceStatusCondition(this.presenter.getAbortActionCondition(), 1);
    }

    @Test
    public void testSignalActionCondition() {
        ProcessInstanceListPresenterTest.testProcessInstanceStatusCondition(this.presenter.getSignalActionCondition(), 1);
    }

    @Test
    public void testOpenTaskView() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true, (Object[])new Boolean[]{false});
        this.presenter.openTaskView("");
        this.presenter.openTaskView("");
        ArgumentCaptor captor = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)2))).goTo((PlaceRequest)captor.capture());
        Assert.assertEquals((long)2L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)"TaskAdmin", (Object)((PlaceRequest)captor.getAllValues().get(0)).getIdentifier());
        Assert.assertEquals((Object)"Tasks", (Object)((PlaceRequest)captor.getAllValues().get(1)).getIdentifier());
    }

    @Test
    public void testCreateDataSetProcessInstanceCallbackOnError() {
        ProcessInstanceListPresenter spy = (ProcessInstanceListPresenter)Mockito.spy((Object)this.presenter);
        ClientRuntimeError error = new ClientRuntimeError("");
        FilterSettings filterSettings = (FilterSettings)Mockito.mock(FilterSettings.class);
        DataSetReadyCallback callback = spy.createDataSetProcessInstanceCallback(0, filterSettings);
        ((ProcessInstanceListPresenter)Mockito.doNothing().when((Object)spy)).showErrorPopup((String)Mockito.any());
        Assert.assertFalse((boolean)callback.onError(error));
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).hideBusyIndicator();
        ((ProcessInstanceListPresenter)Mockito.verify((Object)spy)).showErrorPopup(Constants.INSTANCE.ResourceCouldNotBeLoaded(Constants.INSTANCE.Process_Instances()));
    }

    protected class PerspectiveAnswer
    implements Answer<Boolean> {
        private String perspectiveId;

        public PerspectiveAnswer(String perspectiveId) {
            this.perspectiveId = perspectiveId;
        }

        public Boolean answer(InvocationOnMock invocation) throws Throwable {
            return this.perspectiveId.equals(((ResourceRef)invocation.getArguments()[0]).getIdentifier());
        }
    }
}

