/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMTokenList;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;

@Dependent
@Templated(value="ProcessInstanceSummaryErrorPopoverCell.html", stylesheet="ProcessInstanceSummaryErrorPopoverCell.css")
public class ProcessInstanceSummaryErrorPopoverCell
extends AbstractCell<ProcessInstanceSummary>
implements IsElement {
    private static final Constants I18N = Constants.INSTANCE;
    private static final String VIEW_ERROR_LINK_NAME = "viewErrAnchor";
    private static final String PROCESS_INSTANCE_ATTRIBUTE = "data-jbpm-processInstanceId";
    private static final String ERROR_PRESENT_STYLE = "error-present";
    private static final String LINK_AVAILABLE_STYLE = "link-available";
    @Inject
    @DataField(value="popover")
    private Anchor popover;
    @Inject
    @DataField(value="popoverContent")
    private Span popoverContent;
    @Inject
    @DataField(value="contentErrCount")
    private Span contentErrCount;
    @Inject
    @DataField(value="viewErrAnchor")
    private Anchor viewErrAnchor;
    private ProcessInstanceListPresenter viewPresenter;

    public ProcessInstanceSummaryErrorPopoverCell() {
        super(new String[0]);
    }

    public ProcessInstanceSummaryErrorPopoverCell init(ProcessInstanceListPresenter viewPresenter) {
        this.viewPresenter = viewPresenter;
        return this;
    }

    public void render(Cell.Context context, ProcessInstanceSummary value, SafeHtmlBuilder sb) {
        Integer errCount = value != null && value.getErrorCount() != null ? value.getErrorCount() : 0;
        DOMTokenList popoverClasses = this.popover.getClassList();
        this.popover.setTextContent(Integer.toString(errCount));
        if (errCount > 0) {
            popoverClasses.add(ERROR_PRESENT_STYLE);
        } else {
            popoverClasses.remove(ERROR_PRESENT_STYLE);
        }
        if (this.viewPresenter.getViewErrorsActionCondition().test(value)) {
            this.viewErrAnchor.setTitle(I18N.ErrorCountViewLink());
            this.viewErrAnchor.setTextContent(I18N.ErrorCountViewLink());
            this.viewErrAnchor.setAttribute(PROCESS_INSTANCE_ATTRIBUTE, Long.toString(value.getProcessInstanceId()));
            this.contentErrCount.setTextContent(I18N.ErrorCountNumber(errCount));
            popoverClasses.add(LINK_AVAILABLE_STYLE);
            this.popover.setAttribute("data-toggle", "popover");
            Scheduler.get().scheduleDeferred(() -> this.initPopovers(VIEW_ERROR_LINK_NAME, PROCESS_INSTANCE_ATTRIBUTE));
        } else {
            this.popover.removeAttribute("data-toggle");
            popoverClasses.remove(LINK_AVAILABLE_STYLE);
        }
        sb.appendHtmlConstant(this.popover.getOuterHTML());
    }

    public void openErrorView(String pid) {
        this.viewPresenter.openErrorView(pid);
    }

    public String getPopoverContent() {
        return this.popoverContent.getInnerHTML();
    }

    private native void initPopovers(String var1, String var2);
}

