/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.details.multi;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.workbench.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.display.views.PopupFormDisplayerView;
import org.jbpm.workbench.forms.display.api.ProcessDisplayerConfig;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramUtil;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

public abstract class BaseProcessDefDetailsMultiPresenter<T extends BaseProcessDefDetailsMultiView>
implements RefreshMenuBuilder.SupportsRefresh {
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    protected PopupFormDisplayerView formDisplayPopUp;
    @Inject
    protected T view;
    @Inject
    private PlaceManager placeManager;
    @Inject
    protected StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Inject
    private Event<ProcessDefSelectionEvent> processDefSelectionEvent;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    private PlaceRequest place;
    private String deploymentId = "";
    private String processId = "";
    private String processDefName = "";
    private String serverTemplateId = "";
    private boolean dynamic;
    protected MenuFactory.CustomMenuBuilder newInstanceMenu;

    @PostConstruct
    public void init() {
        this.newInstanceMenu = new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return BaseProcessDefDetailsMultiPresenter.this.view.getNewInstanceButton();
                    }
                };
            }
        };
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public void onProcessSelectionEvent(@Observes ProcessDefSelectionEvent event) {
        this.deploymentId = event.getDeploymentId();
        this.processId = event.getProcessId();
        this.processDefName = event.getProcessDefName();
        this.serverTemplateId = event.getServerTemplateId();
        this.dynamic = event.isDynamic();
        this.view.setNewInstanceButtonVisible(!this.dynamic);
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(this.deploymentId) + " - " + this.processDefName));
    }

    public void createNewProcessInstance() {
        ProcessDisplayerConfig config = new ProcessDisplayerConfig(new ProcessDefinitionKey(this.serverTemplateId, this.deploymentId, this.processId, this.processDefName), this.processDefName);
        this.formDisplayPopUp.setTitle(this.processDefName);
        this.startProcessDisplayProvider.setup(config, (FormDisplayerView)this.formDisplayPopUp);
    }

    public void goToProcessDefModelPopup() {
        if (this.place != null && !this.deploymentId.equals("")) {
            this.placeManager.goTo(ProcessDiagramUtil.buildPlaceRequest(this.serverTemplateId, this.deploymentId, this.processId));
        }
    }

    public void viewProcessInstances() {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("ProcessInstances");
        placeRequestImpl.addParameter("processDefinitionId", this.processId);
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void onRefresh() {
        this.processDefSelectionEvent.fire((Object)new ProcessDefSelectionEvent(this.processId, this.deploymentId, this.serverTemplateId, this.processDefName, this.dynamic));
    }

    public void closeDetails() {
        this.placeManager.forceClosePlace(this.place);
    }

    public static interface BaseProcessDefDetailsMultiView {
        public IsWidget getNewInstanceButton();

        public void setNewInstanceButtonVisible(boolean var1);
    }
}

