/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceSummaryActionCell;
import org.jbpm.workbench.pr.client.resources.ProcessRuntimeResources;
import org.jbpm.workbench.pr.client.resources.css.ProcessRuntimeCSS;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@Dependent
public class ProcessInstanceListViewImpl
extends AbstractMultiGridView<ProcessInstanceSummary, ProcessInstanceListPresenter>
implements ProcessInstanceListPresenter.ProcessInstanceListView {
    public static final String TAB_ACTIVE = "DS_ProcessInstancesWithVariablesIncludedGrid_0";
    public static final String TAB_COMPLETED = "DS_ProcessInstancesWithVariablesIncludedGrid_1";
    public static final String TAB_ABORTED = "DS_ProcessInstancesWithVariablesIncludedGrid_2";
    private List<ProcessInstanceSummary> selectedProcessInstances = new ArrayList<ProcessInstanceSummary>();
    private final Constants constants = Constants.INSTANCE;
    private AnchorListItem bulkAbortNavLink;
    private AnchorListItem bulkSignalNavLink;

    private void controlBulkOperations() {
        if (this.selectedProcessInstances != null && this.selectedProcessInstances.size() > 0) {
            this.bulkAbortNavLink.setEnabled(true);
            this.bulkSignalNavLink.setEnabled(true);
        } else {
            this.bulkAbortNavLink.setEnabled(false);
            this.bulkSignalNavLink.setEnabled(false);
        }
    }

    public void init(final ProcessInstanceListPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add("Select");
        bannedColumns.add("processInstanceId");
        bannedColumns.add("processName");
        bannedColumns.add("processInstanceDescription");
        bannedColumns.add("Actions");
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add("Select");
        initColumns.add("processInstanceId");
        initColumns.add("processName");
        initColumns.add("processInstanceDescription");
        initColumns.add("processVersion");
        initColumns.add("lastModificationDate");
        initColumns.add("errorCount");
        initColumns.add("Actions");
        this.createTabButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final String key = ProcessInstanceListViewImpl.this.getValidKeyForAdditionalListGrid("DS_ProcessInstancesWithVariablesIncludedGrid_");
                Command addNewGrid = new Command(){

                    public void execute() {
                        final ExtendedPagedTable extendedPagedTable = ProcessInstanceListViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                        ProcessInstanceListViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, ProcessInstanceListViewImpl.this.createTabButton, new Command(){

                            public void execute() {
                                ProcessInstanceListViewImpl.this.currentListGrid = extendedPagedTable;
                                ProcessInstanceListViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        ProcessInstanceListViewImpl.this.applyFilterOnPresenter(key);
                    }
                };
                FilterSettings tableSettings = presenter.createTableSettingsPrototype();
                tableSettings.setKey(key);
                ProcessInstanceListViewImpl.this.dataSetEditorManager.showTableSettingsEditor(ProcessInstanceListViewImpl.this.filterPagedTable, ProcessInstanceListViewImpl.this.constants.New_Process_InstanceList(), tableSettings, addNewGrid);
            }
        });
        super.init((AbstractMultiGridPresenter)presenter, new GridGlobalPreferences("DS_ProcessInstancesWithVariablesIncludedGrid", initColumns, bannedColumns));
    }

    public void initSelectionModel(final ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Process_Instances_Found());
        extendedPagedTable.getRightActionsToolbar().clear();
        this.initBulkActions(extendedPagedTable);
        final NoSelectionModel selectionModel = new NoSelectionModel();
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (ProcessInstanceListViewImpl.this.selectedRow == -1 || extendedPagedTable.getKeyboardSelectedRow() != ProcessInstanceListViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(ProcessInstanceListViewImpl.this.selectedStyles);
                    ProcessInstanceListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
                ProcessInstanceListViewImpl.this.selectedItem = (GenericSummary)selectionModel.getLastSelectedObject();
                ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).selectProcessInstance((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem, close);
            }
        });
        DefaultSelectionEventManager noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<ProcessInstanceSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<ProcessInstanceSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<ProcessInstanceSummary> event) {
                DefaultSelectionEventManager.SelectAction ret = DefaultSelectionEventManager.SelectAction.DEFAULT;
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType())) {
                    InputElement input;
                    Element target;
                    if (extendedPagedTable.isSelectionIgnoreColumn(event.getColumn())) {
                        ret = DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                    if ("input".equals((target = (Element)nativeEvent.getEventTarget().cast()).getTagName().toLowerCase()) && "checkbox".equals((input = (InputElement)target.cast()).getType().toLowerCase())) {
                        if (!ProcessInstanceListViewImpl.this.selectedProcessInstances.contains(event.getValue())) {
                            ProcessInstanceListViewImpl.this.selectedProcessInstances.add(event.getValue());
                            input.setChecked(true);
                        } else {
                            ProcessInstanceListViewImpl.this.selectedProcessInstances.remove(event.getValue());
                            input.setChecked(false);
                        }
                        ProcessInstanceListViewImpl.this.getListGrid().redraw();
                        ProcessInstanceListViewImpl.this.controlBulkOperations();
                        ret = DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                }
                return ret;
            }
        });
        extendedPagedTable.setSelectionModel((SelectionModel)selectionModel, (CellPreviewEvent.Handler)noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    public void initColumns(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        ColumnMeta<ProcessInstanceSummary> checkColumnMeta = this.initChecksColumn();
        Column<ProcessInstanceSummary, ProcessInstanceSummary> actionsColumn = this.initActionsColumn();
        Column<ProcessInstanceSummary, ProcessInstanceSummary> errorCountColumn = this.initErrorCountColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumn);
        extendedPagedTable.addSelectionIgnoreColumn(errorCountColumn);
        ArrayList<ColumnMeta<ProcessInstanceSummary>> columnMetas = new ArrayList<ColumnMeta<ProcessInstanceSummary>>();
        columnMetas.add(checkColumnMeta);
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceId", process -> String.valueOf(process.getProcessInstanceId())), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processName", process -> process.getProcessName()), this.constants.Name()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", process -> process.getProcessInstanceDescription()), this.constants.Process_Instance_Description()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("user_identity", process -> process.getInitiator()), this.constants.Initiator()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processVersion", process -> process.getProcessVersion()), this.constants.Version()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", process -> {
            switch (process.getState()) {
                case 1: {
                    return this.constants.Active();
                }
                case 3: {
                    return this.constants.Aborted();
                }
                case 2: {
                    return this.constants.Completed();
                }
                case 0: {
                    return this.constants.Pending();
                }
                case 4: {
                    return this.constants.Suspended();
                }
            }
            return this.constants.Unknown();
        }), this.constants.State()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("start_date", process -> DateUtils.getDateTimeStr((Date)process.getStartTime())), this.constants.Start_Date()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("lastModificationDate", process -> DateUtils.getDateTimeStr((Date)process.getLastModificationDate())), this.constants.Last_Modification_Date()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("correlationKey", process -> process.getCorrelationKey()), this.constants.Correlation_Key()));
        columnMetas.add(new ColumnMeta(errorCountColumn, this.constants.Errors()));
        columnMetas.add(new ColumnMeta(actionsColumn, this.constants.Actions()));
        List columPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        for (GridColumnPreference colPref : columPreferenceList) {
            if (this.isColumnAdded(columnMetas, colPref.getName())) continue;
            Column genericColumn = this.initGenericColumn(colPref.getName());
            genericColumn.setSortable(false);
            columnMetas.add((ColumnMeta<ProcessInstanceSummary>)new ColumnMeta(genericColumn, colPref.getName(), true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
        extendedPagedTable.setColumnWidth(checkColumnMeta.getColumn(), 38.0, Style.Unit.PX);
        extendedPagedTable.setColumnWidth(errorCountColumn, 65.0, Style.Unit.PX);
        extendedPagedTable.storeColumnToPreferences();
    }

    private boolean isColumnAdded(List<ColumnMeta<ProcessInstanceSummary>> columnMetas, String caption) {
        if (caption != null) {
            for (ColumnMeta<ProcessInstanceSummary> colMet : columnMetas) {
                if (!caption.equals(colMet.getColumn().getDataStoreName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDomainSpecifColumns(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable, Set<String> columns) {
        extendedPagedTable.storeColumnToPreferences();
        HashMap<String, String> modifiedCaptions = new HashMap<String, String>();
        ArrayList<ColumnMeta> existingExtraColumns = new ArrayList<ColumnMeta>();
        for (ColumnMeta cm : extendedPagedTable.getColumnMetaList()) {
            if (cm.isExtraColumn()) {
                existingExtraColumns.add(cm);
                continue;
            }
            if (!columns.contains(cm.getCaption())) continue;
            for (String c : columns) {
                if (!c.equals(cm.getCaption())) continue;
                modifiedCaptions.put(c, "Var_" + c);
            }
        }
        for (ColumnMeta colMet : existingExtraColumns) {
            if (!columns.contains(colMet.getCaption())) {
                extendedPagedTable.removeColumnMeta(colMet);
                continue;
            }
            columns.remove(colMet.getCaption());
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        String caption = "";
        Iterator<String> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String c;
            caption = c = iterator.next();
            if (modifiedCaptions.get(c) != null) {
                caption = (String)modifiedCaptions.get(c);
            }
            Column genericColumn = this.initGenericColumn(c);
            genericColumn.setSortable(false);
            columnMetas.add(new ColumnMeta(genericColumn, caption, true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column initGenericColumn(final String key) {
        Column<ProcessInstanceSummary, String> genericColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getDomainDataValue(key);
            }
        };
        genericColumn.setSortable(true);
        genericColumn.setDataStoreName(key);
        return genericColumn;
    }

    private void initBulkActions(final ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        this.bulkAbortNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        this.bulkAbortNavLink.setText(this.constants.Bulk_Abort());
        this.bulkSignalNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        this.bulkSignalNavLink.setText(this.constants.Bulk_Signal());
        ButtonGroup bulkActions = (ButtonGroup)GWT.create(ButtonGroup.class);
        Button bulkButton = (Button)GWT.create(Button.class);
        bulkButton.setText(this.constants.Bulk_Actions());
        bulkButton.setDataToggle(Toggle.DROPDOWN);
        bulkButton.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        bulkActions.add((Widget)bulkButton);
        DropDownMenu bulkDropDown = (DropDownMenu)GWT.create(DropDownMenu.class);
        bulkDropDown.addStyleName("dropdown-menu-right");
        bulkDropDown.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        bulkDropDown.add((Widget)this.bulkAbortNavLink);
        bulkDropDown.add((Widget)this.bulkSignalNavLink);
        bulkActions.add((Widget)bulkDropDown);
        this.bulkAbortNavLink.setIcon(IconType.BAN);
        this.bulkAbortNavLink.setIconFixedWidth(true);
        this.bulkAbortNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)ProcessInstanceListViewImpl.this.constants.Abort_Process_Instances())) {
                    ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).bulkAbort(ProcessInstanceListViewImpl.this.selectedProcessInstances);
                    ProcessInstanceListViewImpl.this.selectedProcessInstances.clear();
                    extendedPagedTable.redraw();
                }
            }
        });
        this.bulkSignalNavLink.setIcon(IconType.BELL);
        this.bulkSignalNavLink.setIconFixedWidth(true);
        this.bulkSignalNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).bulkSignal(ProcessInstanceListViewImpl.this.selectedProcessInstances);
                ProcessInstanceListViewImpl.this.selectedProcessInstances.clear();
                extendedPagedTable.redraw();
            }
        });
        extendedPagedTable.getRightActionsToolbar().add((Widget)bulkActions);
        this.controlBulkOperations();
    }

    private Column<ProcessInstanceSummary, ProcessInstanceSummary> initErrorCountColumn() {
        Column<ProcessInstanceSummary, ProcessInstanceSummary> column = new Column<ProcessInstanceSummary, ProcessInstanceSummary>((Cell)new AbstractCell<ProcessInstanceSummary>(new String[0]){

            public void render(Cell.Context context, ProcessInstanceSummary value, SafeHtmlBuilder sb) {
                int errCount = value != null ? value.getErrorCount() : 0;
                ProcessRuntimeCSS css = ProcessRuntimeResources.INSTANCE.css();
                String badgeHtml = null;
                if (errCount > 0) {
                    String linkToErrorView = "#ExecutionErrors";
                    String elementId = DOM.createUniqueId();
                    String popoverAttrs = "data-toggle=\"popover\" data-html=\"true\" data-placement=\"right\" data-content=\"" + ProcessInstanceListViewImpl.this.constants.ErrorCountNumber(errCount) + " | <a href='" + linkToErrorView + "' title='" + ProcessInstanceListViewImpl.this.constants.ErrorCountViewLink() + "'>" + ProcessInstanceListViewImpl.this.constants.ErrorCountViewLink() + "</a>\" data-container=\"body\" data-trigger=\"hover focus\"";
                    badgeHtml = "<a id=\"" + elementId + "\" href=\"#\" class=\"badge " + css.processInstanceErrorCount() + " " + css.processInstanceErrorCountPresent() + "\" " + popoverAttrs + ">" + errCount + "</a>";
                    Scheduler.get().scheduleDeferred(() -> ProcessInstanceListViewImpl.this.initPopover(elementId));
                } else {
                    badgeHtml = "<span class=\"badge " + css.processInstanceErrorCount() + "\">" + errCount + "</span>";
                }
                sb.appendHtmlConstant(badgeHtml);
            }
        }){

            public ProcessInstanceSummary getValue(ProcessInstanceSummary process) {
                return process;
            }
        };
        column.setSortable(true);
        column.setDataStoreName("errorCount");
        return column;
    }

    private native void initPopover(String var1);

    private Column<ProcessInstanceSummary, ProcessInstanceSummary> initActionsColumn() {
        LinkedList<ProcessInstanceSummaryActionCell> cells = new LinkedList<ProcessInstanceSummaryActionCell>();
        cells.add(new ProcessInstanceSummaryActionCell(this.constants.Signal(), new ActionCell.Delegate<ProcessInstanceSummary>(){

            public void execute(ProcessInstanceSummary processInstance) {
                ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).signalProcessInstance(processInstance);
            }
        }));
        cells.add(new ProcessInstanceSummaryActionCell(this.constants.Abort(), new ActionCell.Delegate<ProcessInstanceSummary>(){

            public void execute(ProcessInstanceSummary processInstance) {
                if (Window.confirm((String)ProcessInstanceListViewImpl.this.constants.Abort_Process_Instance())) {
                    ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).abortProcessInstance(processInstance.getDeploymentId(), processInstance.getProcessInstanceId());
                }
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<ProcessInstanceSummary, ProcessInstanceSummary> actionsColumn = new Column<ProcessInstanceSummary, ProcessInstanceSummary>((Cell)cell){

            public ProcessInstanceSummary getValue(ProcessInstanceSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName("Actions");
        return actionsColumn;
    }

    private ColumnMeta<ProcessInstanceSummary> initChecksColumn() {
        CheckboxCell checkboxCell = new CheckboxCell(true, false);
        Column<ProcessInstanceSummary, Boolean> checkColumn = new Column<ProcessInstanceSummary, Boolean>((Cell)checkboxCell){

            public Boolean getValue(ProcessInstanceSummary object) {
                return ProcessInstanceListViewImpl.this.selectedProcessInstances.contains(object);
            }
        };
        Header<Boolean> selectPageHeader = new Header<Boolean>((Cell)checkboxCell){

            public Boolean getValue() {
                List<ProcessInstanceSummary> displayedInstances = ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).getDisplayedProcessInstances();
                return displayedInstances.size() > 0 && ProcessInstanceListViewImpl.this.selectedProcessInstances.size() == ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).getDisplayedProcessInstances().size();
            }
        };
        selectPageHeader.setUpdater((ValueUpdater)new ValueUpdater<Boolean>(){

            public void update(Boolean value) {
                ProcessInstanceListViewImpl.this.selectedProcessInstances.clear();
                if (value.booleanValue()) {
                    ProcessInstanceListViewImpl.this.selectedProcessInstances.addAll(((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).getDisplayedProcessInstances());
                }
                ProcessInstanceListViewImpl.this.getListGrid().redraw();
                ProcessInstanceListViewImpl.this.controlBulkOperations();
            }
        });
        checkColumn.setSortable(false);
        checkColumn.setDataStoreName("Select");
        ColumnMeta checkColMeta = new ColumnMeta((Column)checkColumn, "");
        checkColMeta.setHeader((Header)selectPageHeader);
        return checkColMeta;
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        super.initDefaultFilters(preferences, createTabButton);
        this.initGenericTabFilter(((ProcessInstanceListPresenter)this.presenter).createActiveTabSettings(), TAB_ACTIVE, this.constants.Active(), this.constants.FilterActive(), preferences);
        this.initGenericTabFilter(((ProcessInstanceListPresenter)this.presenter).createCompletedTabSettings(), TAB_COMPLETED, this.constants.Completed(), this.constants.FilterCompleted(), preferences);
        this.initGenericTabFilter(((ProcessInstanceListPresenter)this.presenter).createAbortedTabSettings(), TAB_ABORTED, this.constants.Aborted(), this.constants.FilterAborted(), preferences);
        this.filterPagedTable.addAddTableButton(createTabButton);
        this.selectFirstTabAndEnableQueries();
    }

    private void initGenericTabFilter(FilterSettings tableSettings, String key, String tabName, String tabDesc, GridGlobalPreferences preferences) {
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        tableSettings.setUUID("jbpmProcessInstances");
        this.addNewTab(preferences, tableSettings);
    }

    public void resetDefaultFilterTitleAndDescription() {
        super.resetDefaultFilterTitleAndDescription();
        this.saveTabSettings(TAB_ACTIVE, this.constants.Active(), this.constants.FilterActive());
        this.saveTabSettings(TAB_COMPLETED, this.constants.Completed(), this.constants.FilterCompleted());
        this.saveTabSettings(TAB_ABORTED, this.constants.Aborted(), this.constants.FilterAborted());
    }
}

