/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.util.ConditionalButtonActionCell;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceSummaryErrorPopoverCell;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@Dependent
public class ProcessInstanceListViewImpl
extends AbstractMultiGridView<ProcessInstanceSummary, ProcessInstanceListPresenter>
implements ProcessInstanceListPresenter.ProcessInstanceListView {
    protected static final String TAB_ACTIVE = "DS_ProcessInstancesWithVariablesIncludedGrid_0";
    protected static final String TAB_COMPLETED = "DS_ProcessInstancesWithVariablesIncludedGrid_1";
    protected static final String TAB_ABORTED = "DS_ProcessInstancesWithVariablesIncludedGrid_2";
    private final Constants constants = Constants.INSTANCE;
    @Inject
    private ManagedInstance<ProcessInstanceSummaryErrorPopoverCell> popoverCellInstance;

    public List<String> getInitColumns() {
        return Arrays.asList("Select", "processInstanceId", "processName", "processInstanceDescription", "processVersion", "lastModificationDate", "errorCount", "Actions");
    }

    public List<String> getBannedColumns() {
        return Arrays.asList("Select", "processInstanceId", "processName", "processInstanceDescription", "Actions");
    }

    public String getGridGlobalPreferencesKey() {
        return "DS_ProcessInstancesWithVariablesIncludedGrid";
    }

    public String getNewFilterPopupTitle() {
        return this.constants.New_Process_InstanceList();
    }

    public void initSelectionModel(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Process_Instances_Found());
        extendedPagedTable.setSelectionCallback((pis, close) -> ((ProcessInstanceListPresenter)this.presenter).selectProcessInstance((ProcessInstanceSummary)pis, (Boolean)close));
        this.initBulkActions(extendedPagedTable);
    }

    public void initColumns(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        ColumnMeta checkColumnMeta = this.initChecksColumn(extendedPagedTable);
        Column<ProcessInstanceSummary, ProcessInstanceSummary> actionsColumn = this.initActionsColumn();
        Column<ProcessInstanceSummary, ProcessInstanceSummary> errorCountColumn = this.initErrorCountColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumn);
        extendedPagedTable.addSelectionIgnoreColumn(errorCountColumn);
        ArrayList<ColumnMeta<ProcessInstanceSummary>> columnMetas = new ArrayList<ColumnMeta<ProcessInstanceSummary>>();
        columnMetas.add(checkColumnMeta);
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceId", process -> String.valueOf(process.getProcessInstanceId())), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processName", process -> process.getProcessName()), this.constants.Name()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", process -> process.getProcessInstanceDescription()), this.constants.Process_Instance_Description()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("user_identity", process -> process.getInitiator()), this.constants.Initiator()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processVersion", process -> process.getProcessVersion()), this.constants.Version()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", process -> {
            switch (process.getState()) {
                case 1: {
                    return this.constants.Active();
                }
                case 3: {
                    return this.constants.Aborted();
                }
                case 2: {
                    return this.constants.Completed();
                }
                case 0: {
                    return this.constants.Pending();
                }
                case 4: {
                    return this.constants.Suspended();
                }
            }
            return this.constants.Unknown();
        }), this.constants.State()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("start_date", process -> DateUtils.getDateTimeStr((Date)process.getStartTime())), this.constants.Start_Date()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("lastModificationDate", process -> DateUtils.getDateTimeStr((Date)process.getLastModificationDate())), this.constants.Last_Modification_Date()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("correlationKey", process -> process.getCorrelationKey()), this.constants.Correlation_Key()));
        columnMetas.add(new ColumnMeta(errorCountColumn, this.constants.Errors()));
        columnMetas.add(new ColumnMeta(actionsColumn, this.constants.Actions()));
        List columPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        for (GridColumnPreference colPref : columPreferenceList) {
            if (this.isColumnAdded(columnMetas, colPref.getName())) continue;
            Column genericColumn = this.initGenericColumn(colPref.getName());
            genericColumn.setSortable(false);
            columnMetas.add((ColumnMeta<ProcessInstanceSummary>)new ColumnMeta(genericColumn, colPref.getName(), true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
        extendedPagedTable.setColumnWidth(checkColumnMeta.getColumn(), 38.0, Style.Unit.PX);
        extendedPagedTable.setColumnWidth(errorCountColumn, 65.0, Style.Unit.PX);
        extendedPagedTable.storeColumnToPreferences();
    }

    private boolean isColumnAdded(List<ColumnMeta<ProcessInstanceSummary>> columnMetas, String caption) {
        if (caption != null) {
            for (ColumnMeta<ProcessInstanceSummary> colMet : columnMetas) {
                if (!caption.equals(colMet.getColumn().getDataStoreName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDomainSpecifColumns(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable, Set<String> columns) {
        extendedPagedTable.storeColumnToPreferences();
        HashMap<String, String> modifiedCaptions = new HashMap<String, String>();
        ArrayList<ColumnMeta> existingExtraColumns = new ArrayList<ColumnMeta>();
        for (ColumnMeta cm : extendedPagedTable.getColumnMetaList()) {
            if (cm.isExtraColumn()) {
                existingExtraColumns.add(cm);
                continue;
            }
            if (!columns.contains(cm.getCaption())) continue;
            for (String c : columns) {
                if (!c.equals(cm.getCaption())) continue;
                modifiedCaptions.put(c, "Var_" + c);
            }
        }
        for (ColumnMeta colMet : existingExtraColumns) {
            if (!columns.contains(colMet.getCaption())) {
                extendedPagedTable.removeColumnMeta(colMet);
                continue;
            }
            columns.remove(colMet.getCaption());
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        String caption = "";
        Iterator<String> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String c;
            caption = c = iterator.next();
            if (modifiedCaptions.get(c) != null) {
                caption = (String)modifiedCaptions.get(c);
            }
            Column genericColumn = this.initGenericColumn(c);
            genericColumn.setSortable(false);
            columnMetas.add(new ColumnMeta(genericColumn, caption, true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column initGenericColumn(final String key) {
        Column<ProcessInstanceSummary, String> genericColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getDomainDataValue(key);
            }
        };
        genericColumn.setSortable(true);
        genericColumn.setDataStoreName(key);
        return genericColumn;
    }

    private void initBulkActions(final ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        extendedPagedTable.getRightActionsToolbar().clear();
        AnchorListItem bulkAbortNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        bulkAbortNavLink.setText(this.constants.Bulk_Abort());
        AnchorListItem bulkSignalNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        bulkSignalNavLink.setText(this.constants.Bulk_Signal());
        ButtonGroup bulkActions = (ButtonGroup)GWT.create(ButtonGroup.class);
        Button bulkButton = (Button)GWT.create(Button.class);
        bulkButton.setText(this.constants.Bulk_Actions());
        bulkButton.setDataToggle(Toggle.DROPDOWN);
        bulkButton.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        bulkActions.add((Widget)bulkButton);
        DropDownMenu bulkDropDown = (DropDownMenu)GWT.create(DropDownMenu.class);
        bulkDropDown.addStyleName("dropdown-menu-right");
        bulkDropDown.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        bulkDropDown.add((Widget)bulkAbortNavLink);
        bulkDropDown.add((Widget)bulkSignalNavLink);
        bulkActions.add((Widget)bulkDropDown);
        bulkAbortNavLink.setIcon(IconType.BAN);
        bulkAbortNavLink.setIconFixedWidth(true);
        bulkAbortNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)ProcessInstanceListViewImpl.this.constants.Abort_Process_Instances())) {
                    ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).bulkAbort(extendedPagedTable.getSelectedItems());
                    extendedPagedTable.deselectAllItems();
                    extendedPagedTable.redraw();
                }
            }
        });
        bulkSignalNavLink.setIcon(IconType.BELL);
        bulkSignalNavLink.setIconFixedWidth(true);
        bulkSignalNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).bulkSignal(extendedPagedTable.getSelectedItems());
                extendedPagedTable.deselectAllItems();
                extendedPagedTable.redraw();
            }
        });
        extendedPagedTable.getRightActionsToolbar().add((Widget)bulkActions);
    }

    private Column<ProcessInstanceSummary, ProcessInstanceSummary> initErrorCountColumn() {
        Column<ProcessInstanceSummary, ProcessInstanceSummary> column = new Column<ProcessInstanceSummary, ProcessInstanceSummary>((Cell)((ProcessInstanceSummaryErrorPopoverCell)((Object)this.popoverCellInstance.get())).init((ProcessInstanceListPresenter)this.presenter)){

            public ProcessInstanceSummary getValue(ProcessInstanceSummary process) {
                return process;
            }
        };
        column.setSortable(true);
        column.setDataStoreName("errorCount");
        return column;
    }

    private Column<ProcessInstanceSummary, ProcessInstanceSummary> initActionsColumn() {
        LinkedList<ConditionalButtonActionCell> cells = new LinkedList<ConditionalButtonActionCell>();
        cells.add(new ConditionalButtonActionCell(this.constants.Signal(), processInstance -> ((ProcessInstanceListPresenter)this.presenter).signalProcessInstance((ProcessInstanceSummary)processInstance), ((ProcessInstanceListPresenter)this.presenter).getSignalActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.Abort(), processInstance -> {
            if (Window.confirm((String)this.constants.Abort_Process_Instance())) {
                ((ProcessInstanceListPresenter)this.presenter).abortProcessInstance(processInstance.getDeploymentId(), processInstance.getProcessInstanceId());
            }
        }, ((ProcessInstanceListPresenter)this.presenter).getAbortActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.ViewJobs(), processInstance -> ((ProcessInstanceListPresenter)this.presenter).openJobsView(Long.toString(processInstance.getProcessInstanceId())), ((ProcessInstanceListPresenter)this.presenter).getViewJobsActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.ViewTasks(), processInstance -> ((ProcessInstanceListPresenter)this.presenter).openTaskView(Long.toString(processInstance.getProcessInstanceId())), ((ProcessInstanceListPresenter)this.presenter).getViewTasksActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.ViewErrors(), processInstance -> ((ProcessInstanceListPresenter)this.presenter).openErrorView(Long.toString(processInstance.getProcessInstanceId())), ((ProcessInstanceListPresenter)this.presenter).getViewErrorsActionCondition()));
        CompositeCell cell = new CompositeCell(cells);
        Column<ProcessInstanceSummary, ProcessInstanceSummary> actionsColumn = new Column<ProcessInstanceSummary, ProcessInstanceSummary>((Cell)cell){

            public ProcessInstanceSummary getValue(ProcessInstanceSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName("Actions");
        return actionsColumn;
    }

    public void initDefaultFilters() {
        super.initDefaultFilters();
        this.initTabFilter(((ProcessInstanceListPresenter)this.presenter).createActiveTabSettings(), TAB_ACTIVE, this.constants.Active(), this.constants.FilterActive(), "jbpmProcessInstances");
        this.initTabFilter(((ProcessInstanceListPresenter)this.presenter).createCompletedTabSettings(), TAB_COMPLETED, this.constants.Completed(), this.constants.FilterCompleted(), "jbpmProcessInstances");
        this.initTabFilter(((ProcessInstanceListPresenter)this.presenter).createAbortedTabSettings(), TAB_ABORTED, this.constants.Aborted(), this.constants.FilterAborted(), "jbpmProcessInstances");
    }
}

