/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.RuntimeLogSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;

@Dependent
public class RuntimeLogPresenter {
    public static final LogTemplates LOG_TEMPLATES = (LogTemplates)GWT.create(LogTemplates.class);
    public static String NODE_HUMAN_TASK = "HumanTaskNode";
    public static String NODE_START = "StartNode";
    public static String NODE_END = "EndNode";
    private Constants constants = Constants.INSTANCE;
    private Long processInstanceId;
    private String processName;
    private String serverTemplateId;
    private String deploymentId;
    @Inject
    private RuntimeLogView view;
    @Inject
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setServerTemplateId(String serverTemplateId) {
        this.serverTemplateId = serverTemplateId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void refreshProcessInstanceData(LogUtils.LogOrder logOrder, LogUtils.LogType logType) {
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call(logs -> {
            if (logOrder == LogUtils.LogOrder.ASC) {
                Collections.reverse(logs);
            }
            List<String> logsLine = logs.stream().map(rls -> this.getLogLine((RuntimeLogSummary)rls, logType)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            this.view.setLogs(logsLine);
        })).getProcessInstanceLogs(this.serverTemplateId, this.deploymentId, this.processInstanceId);
    }

    protected Optional<String> getLogLine(RuntimeLogSummary logSummary, LogUtils.LogType logType) {
        if (LogUtils.LogType.TECHNICAL.equals((Object)logType)) {
            String agent = this.constants.System();
            if (NODE_HUMAN_TASK.equals(logSummary.getNodeType()) && logSummary.isCompleted() || NODE_START.equals(logSummary.getNodeType()) && !logSummary.isCompleted()) {
                agent = this.constants.Human();
            }
            return Optional.of(LOG_TEMPLATES.getTechLog(DateUtils.getDateTimeStr((Date)logSummary.getDate()), logSummary.getNodeType(), SafeHtmlUtils.fromString((String)logSummary.getNodeName()), logSummary.isCompleted() ? " " + this.constants.Completed() : "", agent).asString());
        }
        String prettyTime = DateUtils.getPrettyTime((Date)logSummary.getDate());
        if (NODE_HUMAN_TASK.equals(logSummary.getNodeType())) {
            return Optional.of(LOG_TEMPLATES.getBusinessLog(prettyTime, this.constants.Task(), SafeHtmlUtils.fromString((String)logSummary.getNodeName()), logSummary.isCompleted() ? this.constants.WasCompleted() : this.constants.WasStarted()).asString());
        }
        if (NODE_START.equals(logSummary.getNodeType()) && !logSummary.isCompleted()) {
            return Optional.of(LOG_TEMPLATES.getBusinessLog(prettyTime, this.constants.Process(), SafeHtmlUtils.fromString((String)this.getProcessName()), this.constants.WasStarted()).asString());
        }
        if (NODE_END.equals(logSummary.getNodeType()) && logSummary.isCompleted()) {
            return Optional.of(LOG_TEMPLATES.getBusinessLog(prettyTime, this.constants.Process(), SafeHtmlUtils.fromString((String)this.getProcessName()), this.constants.WasCompleted()).asString());
        }
        return Optional.empty();
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.setProcessInstanceId(event.getProcessInstanceId());
        this.setProcessName(event.getProcessDefName());
        this.setServerTemplateId(event.getServerTemplateId());
        this.setDeploymentId(event.getDeploymentId());
        this.view.setActiveLogOrderButton(LogUtils.LogOrder.ASC);
        this.view.setActiveLogTypeButton(LogUtils.LogType.BUSINESS);
        this.refreshProcessInstanceData(LogUtils.LogOrder.ASC, LogUtils.LogType.BUSINESS);
    }

    @Inject
    public void setProcessRuntimeDataService(Caller<ProcessRuntimeDataService> processRuntimeDataService) {
        this.processRuntimeDataService = processRuntimeDataService;
    }

    public static interface LogTemplates
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="{0}: {1} '{2}' {3}")
        public SafeHtml getBusinessLog(String var1, String var2, SafeHtml var3, String var4);

        @SafeHtmlTemplates.Template(value="{0}: {1} ({2}){3} - {4}")
        public SafeHtml getTechLog(String var1, String var2, SafeHtml var3, String var4, String var5);
    }

    public static interface RuntimeLogView
    extends IsWidget {
        public void init(RuntimeLogPresenter var1);

        public void setActiveLogTypeButton(LogUtils.LogType var1);

        public void setActiveLogOrderButton(LogUtils.LogOrder var1);

        public void setLogs(List<String> var1);
    }
}

