/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.AbstractMultiGridViewTest;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.util.GenericErrorSummaryCountCell;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListViewImpl;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceListViewImplTest
extends AbstractMultiGridViewTest<ProcessInstanceSummary> {
    @Mock
    private ProcessInstanceListPresenter presenter;
    @Spy
    private GenericErrorSummaryCountCell cellMock;
    @Mock
    private ManagedInstance<GenericErrorSummaryCountCell> popoverCellInstance;
    @Mock
    private ConfirmPopup confirmPopup;
    @GwtMock
    private AnchorListItem anchorListItem;
    @InjectMocks
    @Spy
    private ProcessInstanceListViewImpl view;

    protected AbstractMultiGridView getView() {
        return this.view;
    }

    protected AbstractMultiGridPresenter getPresenter() {
        return this.presenter;
    }

    public List<String> getExpectedInitialColumns() {
        return Arrays.asList("Select", "processInstanceId", "processName", "processInstanceDescription", "processVersion", "lastModificationDate", "errorCount", "Actions");
    }

    public List<String> getExpectedBannedColumns() {
        return Arrays.asList("Select", "processInstanceId", "processName", "processInstanceDescription", "Actions");
    }

    public Integer getExpectedNumberOfColumns() {
        return 14;
    }

    @Before
    public void setupMocks() {
        super.setupMocks();
        Mockito.when((Object)this.popoverCellInstance.get()).thenReturn((Object)this.cellMock);
    }

    @Test
    public void testSignalCommand() {
        ExtendedPagedTable table = (ExtendedPagedTable)Mockito.mock(ExtendedPagedTable.class);
        this.view.getSignalCommand(table).execute();
        ((ProcessInstanceListPresenter)Mockito.verify((Object)this.presenter)).bulkSignal((List)Mockito.any());
        ((ExtendedPagedTable)Mockito.verify((Object)table)).deselectAllItems();
    }

    @Test
    public void testBulkSignal() {
        ((AnchorListItem)Mockito.doAnswer(invocation -> {
            ClickHandler handler = (ClickHandler)invocation.getArguments()[0];
            handler.onClick((ClickEvent)Mockito.mock(ClickEvent.class));
            return null;
        }).when((Object)this.anchorListItem)).addClickHandler((ClickHandler)Mockito.any());
        ExtendedPagedTable table = (ExtendedPagedTable)Mockito.mock(ExtendedPagedTable.class);
        this.view.getBulkSignal(table);
        ((ProcessInstanceListPresenter)Mockito.verify((Object)this.presenter)).bulkSignal((List)Mockito.any());
        ((ExtendedPagedTable)Mockito.verify((Object)table)).deselectAllItems();
    }

    @Test
    public void testBulkAbort() {
        ((AnchorListItem)Mockito.doAnswer(invocation -> {
            ClickHandler handler = (ClickHandler)invocation.getArguments()[0];
            handler.onClick((ClickEvent)Mockito.mock(ClickEvent.class));
            return null;
        }).when((Object)this.anchorListItem)).addClickHandler((ClickHandler)Mockito.any());
        ExtendedPagedTable table = (ExtendedPagedTable)Mockito.mock(ExtendedPagedTable.class);
        this.view.getBulkAbort(table);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Command.class);
        ((ConfirmPopup)Mockito.verify((Object)this.confirmPopup)).show((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), (Command)captor.capture());
        ((Command)captor.getValue()).execute();
        ((ProcessInstanceListPresenter)Mockito.verify((Object)this.presenter)).bulkAbort((List)Mockito.any());
        ((ExtendedPagedTable)Mockito.verify((Object)table)).deselectAllItems();
    }

    @Test
    public void testAbortCommand() {
        ExtendedPagedTable table = (ExtendedPagedTable)Mockito.mock(ExtendedPagedTable.class);
        this.view.getAbortCommand(table).execute();
        ((ProcessInstanceListPresenter)Mockito.verify((Object)this.presenter)).bulkAbort((List)Mockito.any());
        ((ExtendedPagedTable)Mockito.verify((Object)table)).deselectAllItems();
    }
}

