/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.details;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.workbench.common.client.menu.PrimaryActionMenuBuilder;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.display.views.PopupFormDisplayerView;
import org.jbpm.workbench.forms.display.api.ProcessDisplayerConfig;
import org.jbpm.workbench.pr.client.editors.definition.details.ProcessDefinitionDetailsTabPresenter;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProcessDefinitionDetailsScreen")
public class ProcessDefinitionDetailsPresenter
implements RefreshMenuBuilder.SupportsRefresh {
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private ProcessDefinitionDetailsTabPresenter detailPresenter;
    @Inject
    private Event<ProcessDefSelectionEvent> processDefSelectionEvent;
    @Inject
    private ProcessDiagramPresenter processDiagramPresenter;
    @Inject
    protected ProcessDefinitionDetailsView view;
    @Inject
    protected PopupFormDisplayerView formDisplayPopUp;
    @Inject
    protected StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    private String deploymentId = "";
    private String processId = "";
    private String processDefName = "";
    private String serverTemplateId = "";
    private boolean dynamic;
    protected PrimaryActionMenuBuilder primaryActionMenuBuilder;
    private PlaceRequest place;

    @PostConstruct
    public void init() {
        this.setPrimaryActionMenuBuilder(new PrimaryActionMenuBuilder(Constants.INSTANCE.New_Process_Instance(), () -> this.createNewProcessInstance()));
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @WorkbenchPartView
    public UberView<ProcessDefinitionDetailsPresenter> getView() {
        return this.view;
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.primaryActionMenuBuilder).endMenu()).build();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Details();
    }

    public void onRefresh() {
        this.processDefSelectionEvent.fire((Object)new ProcessDefSelectionEvent(this.processId, this.deploymentId, this.serverTemplateId, this.processDefName, this.dynamic));
    }

    protected void setPrimaryActionMenuBuilder(PrimaryActionMenuBuilder primaryActionMenuBuilder) {
        this.primaryActionMenuBuilder = primaryActionMenuBuilder;
    }

    public void onProcessSelectionEvent(@Observes ProcessDefSelectionEvent event) {
        this.deploymentId = event.getDeploymentId();
        this.processId = event.getProcessId();
        this.processDefName = event.getProcessDefName();
        this.serverTemplateId = event.getServerTemplateId();
        this.dynamic = event.isDynamic();
        this.primaryActionMenuBuilder.setVisible(!this.dynamic);
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(this.deploymentId) + " - " + this.processDefName));
    }

    public void createNewProcessInstance() {
        ProcessDisplayerConfig config = new ProcessDisplayerConfig(new ProcessDefinitionKey(this.serverTemplateId, this.deploymentId, this.processId, this.processDefName), this.processDefName);
        this.formDisplayPopUp.setTitle(this.processDefName);
        this.startProcessDisplayProvider.setup(config, (FormDisplayerView)this.formDisplayPopUp);
    }

    public IsWidget getDetailsView() {
        return this.detailPresenter.getWidget();
    }

    public IsWidget getProcessDiagramView() {
        return this.processDiagramPresenter.getView();
    }

    public static interface ProcessDefinitionDetailsView
    extends UberView<ProcessDefinitionDetailsPresenter> {
    }
}

