/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.user.client.TakesValue;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.AbstractView;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;

@Dependent
@Templated
public class ProcessInstanceLogItemView
extends AbstractView<ProcessInstanceLogPresenter>
implements TakesValue<ProcessInstanceLogSummary>,
IsElement {
    private Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="list-group-item")
    Div listGroupItem;
    @Inject
    @DataField(value="logIcon")
    Span logIcon;
    @Inject
    @DataField(value="logTime")
    Span logTime;
    @Inject
    @DataField(value="nodeTypeDesc")
    Span nodeTypeDesc;
    @Inject
    @DataField(value="logCompleted")
    Span logCompleted;
    @Inject
    @AutoBound
    private DataBinder<ProcessInstanceLogSummary> logSummary;

    @PostConstruct
    public void init() {
        this.tooltip((HTMLElement)this.logIcon);
    }

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public ProcessInstanceLogSummary getValue() {
        return (ProcessInstanceLogSummary)this.logSummary.getModel();
    }

    public void setValue(ProcessInstanceLogSummary model) {
        String iconClass = "list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm";
        this.logSummary.setModel((Object)model);
        this.logTime.setTextContent(DateUtils.getPrettyTime((Date)model.getDate()));
        String agent = this.constants.System();
        if (LogUtils.NODE_HUMAN_TASK.equals(model.getNodeType()) || LogUtils.NODE_START.equals(model.getNodeType()) && !model.isCompleted()) {
            iconClass = iconClass + " fa fa-user";
            agent = this.constants.Human();
            this.tooltip((HTMLElement)this.logIcon);
            this.logIcon.setAttribute("data-original-title", this.constants.Human_Task());
        } else {
            iconClass = iconClass + " fa fa-cogs";
            this.logIcon.setAttribute("data-original-title", this.constants.System_Task());
        }
        if (model.isCompleted()) {
            iconClass = iconClass + " kie-timeline-icon--completed";
            this.logCompleted.setTextContent(this.constants.NodeWasLeft(agent));
        } else {
            this.logCompleted.setTextContent(this.constants.NodeWasEntered(agent));
        }
        this.logIcon.setClassName(iconClass);
        this.nodeTypeDesc.setTextContent(this.getLogTitle(model));
    }

    private String getLogTitle(ProcessInstanceLogSummary logsum) {
        if (LogUtils.NODE_HUMAN_TASK.equals(logsum.getNodeType())) {
            return this.constants.Task_(logsum.getName());
        }
        return logsum.getNodeType();
    }
}

