/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogFilterSettingsManager;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogSummaryDataSetMapper;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;

@Dependent
public class ProcessInstanceLogPresenter {
    public static final int PAGE_SIZE = 10;
    private String serverTemplateId;
    @Inject
    private ProcessInstanceLogView view;
    int currentPage = 0;
    List<ProcessInstanceLogSummary> visibleLogs = new ArrayList<ProcessInstanceLogSummary>();
    protected DataSetQueryHelper dataSetQueryHelper;
    protected ProcessInstanceLogFilterSettingsManager filterSettingsManager;
    @Inject
    protected ErrorPopupPresenter errorPopup;

    public int getPageSize() {
        return 10;
    }

    public void setCurrentPage(int i) {
        this.currentPage = i;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    @Inject
    public void setDataSetQueryHelper(DataSetQueryHelper dataSetQueryHelper) {
        this.dataSetQueryHelper = dataSetQueryHelper;
    }

    @Inject
    public void setFilterSettingsManager(ProcessInstanceLogFilterSettingsManager filterSettingsManager) {
        this.filterSettingsManager = filterSettingsManager;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    public void setServerTemplateId(String serverTemplateId) {
        this.serverTemplateId = serverTemplateId;
    }

    public void loadProcessInstanceLogs() {
        try {
            final FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
            currentTableSettings.setServerTemplateId(this.serverTemplateId);
            currentTableSettings.setTablePageSize(10);
            this.dataSetQueryHelper.setCurrentTableSettings(currentTableSettings);
            this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
            this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(this.currentPage * this.getPageSize()), new DataSetReadyCallback(){

                public void callback(DataSet dataSet) {
                    if (dataSet != null && ProcessInstanceLogPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(currentTableSettings.getKey())) {
                        ArrayList<ProcessInstanceLogSummary> logs = new ArrayList<ProcessInstanceLogSummary>();
                        for (int i = 0; i < dataSet.getRowCount(); ++i) {
                            logs.add(new ProcessInstanceLogSummaryDataSetMapper().apply(dataSet, i));
                        }
                        ProcessInstanceLogPresenter.this.visibleLogs.addAll(logs);
                        ProcessInstanceLogPresenter.this.view.hideLoadButton(logs.size() < 10);
                        ProcessInstanceLogPresenter.this.view.setLogsList(ProcessInstanceLogPresenter.this.visibleLogs.stream().collect(Collectors.toList()));
                    }
                }

                public void notFound() {
                    ProcessInstanceLogPresenter.this.errorPopup.showMessage(Constants.INSTANCE.DataSetNotFound(currentTableSettings.getDataSet().getUUID()));
                }

                public boolean onError(ClientRuntimeError error) {
                    ProcessInstanceLogPresenter.this.errorPopup.showMessage(Constants.INSTANCE.DataSetError(currentTableSettings.getDataSet().getUUID(), error.getMessage()));
                    return false;
                }
            });
        }
        catch (Exception e) {
            this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(e.getMessage()));
        }
    }

    public void loadMoreProcessInstanceLogs() {
        this.setCurrentPage(this.currentPage + 1);
        this.loadProcessInstanceLogs();
    }

    public void resetLogsList() {
        this.currentPage = 0;
        this.visibleLogs = new ArrayList<ProcessInstanceLogSummary>();
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.serverTemplateId = event.getServerTemplateId();
        this.resetLogsList();
        this.dataSetQueryHelper.setCurrentTableSettings(this.filterSettingsManager.createDefaultFilterSettingsPrototype(event.getProcessInstanceId()));
        this.loadProcessInstanceLogs();
    }

    public static interface ProcessInstanceLogView
    extends UberElement<ProcessInstanceLogPresenter> {
        public void setLogsList(List<ProcessInstanceLogSummary> var1);

        public void hideLoadButton(boolean var1);
    }
}

