/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.common.collect.Lists;
import com.google.gwt.dev.util.collect.HashSet;
import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterAddEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterRemoveEvent;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsJSONMarshaller;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListViewImpl;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.service.ProcessService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceListPresenterTest {
    private static final String PERSPECTIVE_ID = "ProcessInstances";
    private String datasetUId = "jbpmProcessInstances";
    private org.jbpm.workbench.common.client.resources.i18n.Constants commonConstants;
    @Mock
    protected PlaceManager placeManager;
    private CallerMock<ProcessService> remoteProcessServiceCaller;
    @Mock
    private ProcessService processService;
    @Mock
    private ProcessInstanceListViewImpl viewMock;
    @Mock
    private DataSetQueryHelper dataSetQueryHelper;
    @Mock
    private DataSet dataSet;
    @Mock
    private DataSet dataSetProcessVar;
    @Mock
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Mock
    private ListTable extendedPagedTable;
    @Spy
    private FilterSettings filterSettings;
    @Mock
    private FilterSettingsJSONMarshaller filterSettingsJSONMarshaller;
    @Spy
    private DataSetLookup dataSetLookup;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private User identity;
    @Mock
    ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder;
    @Mock
    UberfireBreadcrumbs breadcrumbs;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private PerspectiveActivity perspectiveActivity;
    private ArrayList<ProcessInstanceSummary> processInstanceSummaries;
    @Mock
    private FilterSettingsManager filterSettingsManager;
    @Mock
    EventSourceMock<ProcessInstanceSelectionEvent> processInstanceSelectionEvent = new EventSourceMock();
    @InjectMocks
    private ProcessInstanceListPresenter presenter;

    public static ProcessInstanceSummary createProcessInstanceSummary(Long key) {
        return ProcessInstanceListPresenterTest.createProcessInstanceSummary(key, 1);
    }

    public static ProcessInstanceSummary createProcessInstanceSummary(Long key, Integer status) {
        return new ProcessInstanceSummary(key, "procTest", "test.0.1", "Test Proc", "1.0", status, new Date(), new Date(), "intiatior", "procTestInstanceDesc", "cKey", Long.valueOf(0L), new Date(), Integer.valueOf(0), null, Integer.valueOf(0));
    }

    protected static void testProcessInstanceStatusCondition(Predicate<ProcessInstanceSummary> predicate, Integer ... validStatutes) {
        ArrayList allStatus = Lists.newArrayList((Object[])new Integer[]{3, 1, 2, 0, 4});
        List<Integer> validStatuses = Arrays.asList(validStatutes);
        allStatus.removeAll(validStatuses);
        allStatus.forEach(s -> Assert.assertFalse((boolean)predicate.test(ProcessInstanceListPresenterTest.createProcessInstanceSummary(1L, s))));
        validStatuses.forEach(s -> Assert.assertTrue((boolean)predicate.test(ProcessInstanceListPresenterTest.createProcessInstanceSummary(1L, s))));
    }

    @Before
    public void setupMocks() {
        this.remoteProcessServiceCaller = new CallerMock((Object)this.processService);
        this.processInstanceSummaries = this.createProcessInstanceSummaryList(5);
        this.filterSettings.setKey("key");
        this.filterSettings.setDataSetLookup(this.dataSetLookup);
        this.dataSetLookup.setDataSetUUID(this.datasetUId);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn((Object)this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.filterSettingsJSONMarshaller.fromJsonString(Mockito.anyString())).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.filterSettings.getUUID()).thenReturn((Object)this.datasetUId);
        Mockito.when((Object)this.filterSettingsManager.getVariablesFilterSettings((List)Mockito.any())).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.serverTemplateSelectorMenuBuilder.getView()).thenReturn(Mockito.mock(ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView.class));
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)this.perspectiveActivity);
        Mockito.when((Object)this.perspectiveActivity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(ProcessInstanceListPresenterTest.this.dataSet);
                return null;
            }
        }).when((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(ProcessInstanceListPresenterTest.this.dataSetProcessVar);
                return null;
            }
        }).when((Object)this.dataSetQueryHelperDomainSpecific)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        this.commonConstants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;
        this.presenter.setProcessService(this.remoteProcessServiceCaller);
    }

    @Test
    public void getDataTest() {
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific, (VerificationMode)Mockito.never())).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).hideBusyIndicator();
    }

    @Test
    public void isFilteredByProcessIdTest() {
        String processId = "testProc";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"processId", (Comparable)((Object)"testProc"))});
        String filterProcessId = this.presenter.isFilteredByProcessId(Collections.singletonList(filter));
        Assert.assertEquals((Object)"testProc", (Object)filterProcessId);
    }

    @Test
    public void isFilteredByProcessIdInvalidTest() {
        String processId = "testProc";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.likeTo((String)"processId", (String)"testProc")});
        String filterProcessId = this.presenter.isFilteredByProcessId(Collections.singletonList(filter));
        Assert.assertNull((Object)filterProcessId);
    }

    @Test
    public void abortProcessInstanceTest() {
        Long processInstanceId = new Random().nextLong();
        String containerId = "container";
        this.presenter.abortProcessInstance("container", processInstanceId.longValue());
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstance(Mockito.anyString(), (String)Mockito.eq((Object)"container"), (Long)Mockito.eq((Object)processInstanceId));
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification(Constants.INSTANCE.Aborting_Process_Instance((Object)processInstanceId));
    }

    @Test
    public void abortProcessInstancesTest() {
        Random random = new Random();
        Map<String, List<Long>> containerInstance = Collections.singletonMap("container", Arrays.asList(random.nextLong(), random.nextLong(), random.nextLong()));
        this.presenter.abortProcessInstances(containerInstance);
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstances(Mockito.anyString(), (Map)Mockito.eq(containerInstance));
    }

    @Test
    public void bulkAbortProcessInstancesTest() {
        HashMap<String, List> containerInstance = new HashMap<String, List>();
        for (ProcessInstanceSummary summary : this.processInstanceSummaries) {
            containerInstance.computeIfAbsent(summary.getDeploymentId(), key -> new ArrayList()).add(summary.getProcessInstanceId());
        }
        this.presenter.bulkAbort(this.processInstanceSummaries);
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstances(Mockito.anyString(), (Map)Mockito.eq(containerInstance));
    }

    @Test
    public void bulkAbortProcessInstancesStateTest() {
        this.processInstanceSummaries.add(ProcessInstanceListPresenterTest.createProcessInstanceSummary(new Random().nextLong(), 3));
        HashMap<String, List> containerInstance = new HashMap<String, List>();
        for (ProcessInstanceSummary summary : this.processInstanceSummaries) {
            if (summary.getState() != 1) continue;
            containerInstance.computeIfAbsent(summary.getDeploymentId(), key -> new ArrayList()).add(summary.getProcessInstanceId());
        }
        this.presenter.bulkAbort(this.processInstanceSummaries);
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstances(Mockito.anyString(), (Map)Mockito.eq(containerInstance));
    }

    @Test
    public void bulkSignalProcessInstanceSingleAbortedTest() {
        ArrayList<ProcessInstanceSummary> processInstanceSummaries = new ArrayList<ProcessInstanceSummary>();
        processInstanceSummaries.add(ProcessInstanceListPresenterTest.createProcessInstanceSummary(new Random().nextLong(), 3));
        this.presenter.bulkSignal(processInstanceSummaries);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)Mockito.any(PlaceRequest.class));
    }

    @Test
    public void bulkSignalProcessInstancesStateTest() {
        this.processInstanceSummaries.add(ProcessInstanceListPresenterTest.createProcessInstanceSummary(new Random().nextLong(), 3));
        ArrayList<Long> pIds = new ArrayList<Long>();
        for (ProcessInstanceSummary summary : this.processInstanceSummaries) {
            if (summary.getState() != 1) continue;
            pIds.add(summary.getProcessInstanceId());
        }
        this.presenter.bulkSignal(this.processInstanceSummaries);
        ArgumentCaptor placeRequest = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)placeRequest.capture());
        Assert.assertEquals((Object)"Signal Process Popup", (Object)((PlaceRequest)placeRequest.getValue()).getIdentifier());
        Assert.assertEquals((Object)StringUtils.join(pIds, (String)","), (Object)((PlaceRequest)placeRequest.getValue()).getParameter("processInstanceId", null));
    }

    @Test
    public void getDomainSpecifDataForProcessInstancesTest() {
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"processId", (Comparable)((Object)"testProc"))});
        this.filterSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        Mockito.when((Object)this.dataSet.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSet.getValueAt(0, "processInstanceId")).thenReturn((Object)1L);
        Mockito.when((Object)this.dataSetProcessVar.getRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processInstanceId")).thenReturn((Object)1L);
        String processVariable1 = "var1";
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "variableId")).thenReturn((Object)processVariable1);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "value")).thenReturn((Object)"value1");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(1, "processInstanceId")).thenReturn((Object)1L);
        String processVariable2 = "var2";
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(1, "variableId")).thenReturn((Object)processVariable2);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(1, "value")).thenReturn((Object)"value2");
        Object expectedColumns = new HashSet();
        expectedColumns.add(processVariable1);
        expectedColumns.add(processVariable2);
        this.presenter.getData(new Range(0, 5));
        ArgumentCaptor argument = ArgumentCaptor.forClass(Set.class);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addDomainSpecifColumns((ExtendedPagedTable)Mockito.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals((Object)expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).setLastOrderedColumn("processInstanceId");
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).setLastSortOrder(SortOrder.ASCENDING);
        Mockito.when((Object)this.dataSetProcessVar.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processInstanceId")).thenReturn((Object)1L);
        processVariable1 = "varTest1";
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "variableId")).thenReturn((Object)processVariable1);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "value")).thenReturn((Object)"value1");
        expectedColumns = Collections.singleton(processVariable1);
        this.presenter.getData(new Range(0, 5));
        argument = ArgumentCaptor.forClass(Set.class);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).addDomainSpecifColumns((ExtendedPagedTable)Mockito.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals((Object)expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
    }

    public ArrayList<ProcessInstanceSummary> createProcessInstanceSummaryList(int listSize) {
        ArrayList<ProcessInstanceSummary> pIList = new ArrayList<ProcessInstanceSummary>();
        for (long i = 1L; i <= (long)listSize; ++i) {
            pIList.add(ProcessInstanceListPresenterTest.createProcessInstanceSummary(i));
        }
        return pIList;
    }

    @Test
    public void testDataSetQueryHelperColumnMapping() {
        Long TEST_PROC_INST_ID = 55L;
        String TEST_PROC_ID = "TEST_PROC_ID";
        String TEST_EXT_ID = "TEST_EXT_ID";
        String TEST_PROC_NAME = "TEST_PROC_NAME";
        String TEST_PROC_VER = "TEST_PROC_VER";
        Integer TEST_STATE = 7;
        Date TEST_START_DATE = new Date(new Date().getTime() - 0x6DDD00L);
        Date TEST_END_DATE = new Date(new Date().getTime() + 0x6DDD00L);
        String TEST_IDENTITY = "TEST_IDENTITY";
        String TEST_INST_DESC = "TEST_INST_DESC";
        String TEST_CORREL_KEY = "TEST_CORREL_KEY";
        Long TEST_PARENT_PROC_INST_ID = 66L;
        Date TEST_LAST_MODIF_DATE = new Date();
        Integer TEST_ERROR_COUNT = 66;
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processInstanceId")).thenReturn((Object)TEST_PROC_INST_ID);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processId")).thenReturn((Object)"TEST_PROC_ID");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "externalId")).thenReturn((Object)"TEST_EXT_ID");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processName")).thenReturn((Object)"TEST_PROC_NAME");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processVersion")).thenReturn((Object)"TEST_PROC_VER");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "status")).thenReturn((Object)TEST_STATE);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "start_date")).thenReturn((Object)TEST_START_DATE);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "end_date")).thenReturn((Object)TEST_END_DATE);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "user_identity")).thenReturn((Object)"TEST_IDENTITY");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "processInstanceDescription")).thenReturn((Object)"TEST_INST_DESC");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "correlationKey")).thenReturn((Object)"TEST_CORREL_KEY");
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "parentProcessInstanceId")).thenReturn((Object)TEST_PARENT_PROC_INST_ID);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "lastModificationDate")).thenReturn((Object)TEST_LAST_MODIF_DATE);
        Mockito.when((Object)this.dataSetProcessVar.getValueAt(0, "errorCount")).thenReturn((Object)TEST_ERROR_COUNT);
        ProcessInstanceSummary pis = this.presenter.createProcessInstanceSummaryFromDataSet(this.dataSetProcessVar, 0);
        Assert.assertEquals((Object)TEST_PROC_INST_ID, (Object)pis.getProcessInstanceId());
        Assert.assertEquals((Object)"TEST_PROC_ID", (Object)pis.getProcessId());
        Assert.assertEquals((Object)"TEST_EXT_ID", (Object)pis.getDeploymentId());
        Assert.assertEquals((Object)"TEST_PROC_NAME", (Object)pis.getProcessName());
        Assert.assertEquals((Object)"TEST_PROC_VER", (Object)pis.getProcessVersion());
        Assert.assertEquals((Object)TEST_STATE, (Object)pis.getState());
        Assert.assertEquals((Object)TEST_START_DATE, (Object)pis.getStartTime());
        Assert.assertEquals((Object)TEST_END_DATE, (Object)pis.getEndTime());
        Assert.assertEquals((Object)"TEST_IDENTITY", (Object)pis.getInitiator());
        Assert.assertEquals((Object)"TEST_INST_DESC", (Object)pis.getProcessInstanceDescription());
        Assert.assertEquals((Object)"TEST_CORREL_KEY", (Object)pis.getCorrelationKey());
        Assert.assertEquals((Object)TEST_PARENT_PROC_INST_ID, (Object)pis.getParentId());
        Assert.assertEquals((Object)TEST_LAST_MODIF_DATE, (Object)pis.getLastModificationDate());
        Assert.assertEquals((Object)TEST_ERROR_COUNT, (Object)pis.getErrorCount());
    }

    @Test
    public void testDefaultActiveSearchFilters() {
        this.presenter.setupDefaultActiveSearchFilters();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((ActiveFilterItem)captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)Constants.INSTANCE.State(), (Object)((ActiveFilterItem)captor.getValue()).getKey());
        Assert.assertEquals((Object)(Constants.INSTANCE.State() + ": " + Constants.INSTANCE.Active()), (Object)((ActiveFilterItem)captor.getValue()).getLabelValue());
        Assert.assertEquals((Object)1, (Object)((ActiveFilterItem)captor.getValue()).getValue());
    }

    @Test
    public void testActiveSearchFilters() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)place.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn(null);
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((ActiveFilterItem)captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)Constants.INSTANCE.State(), (Object)((ActiveFilterItem)captor.getValue()).getKey());
        Assert.assertEquals((Object)(Constants.INSTANCE.State() + ": " + Constants.INSTANCE.Active()), (Object)((ActiveFilterItem)captor.getValue()).getLabelValue());
        Assert.assertEquals((Object)1, (Object)((ActiveFilterItem)captor.getValue()).getValue());
    }

    @Test
    public void testActiveSearchFiltersProcessDefinitionId() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        String processDefinitionId = "defId";
        Mockito.when((Object)place.getParameter("processDefinitionId", null)).thenReturn((Object)"defId");
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((ActiveFilterItem)captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)Constants.INSTANCE.Process_Definition_Id(), (Object)((ActiveFilterItem)captor.getValue()).getKey());
        Assert.assertEquals((Object)(Constants.INSTANCE.Process_Definition_Id() + ": " + "defId"), (Object)((ActiveFilterItem)captor.getValue()).getLabelValue());
        Assert.assertEquals((Object)"defId", (Object)((ActiveFilterItem)captor.getValue()).getValue());
    }

    @Test
    public void testActiveSearchFiltersProcessInstanceId() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        String processInstanceId = "1";
        Mockito.when((Object)place.getParameter("processDefinitionId", null)).thenReturn(null);
        Mockito.when((Object)place.getParameter("processInstanceId", null)).thenReturn((Object)"1");
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((ActiveFilterItem)captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)Constants.INSTANCE.Id(), (Object)((ActiveFilterItem)captor.getValue()).getKey());
        Assert.assertEquals((Object)(Constants.INSTANCE.Id() + ": " + "1"), (Object)((ActiveFilterItem)captor.getValue()).getLabelValue());
        Assert.assertEquals((Object)1, (Object)((ActiveFilterItem)captor.getValue()).getValue());
    }

    @Test
    public void testIsAuthorizedForTaskAdminView() {
        this.testIsAuthorizedForView("TaskAdmin");
    }

    @Test
    public void testIsAuthorizedForTaskView() {
        this.testIsAuthorizedForView("Tasks");
    }

    private void testIsAuthorizedForView(String perspectiveId) {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Assert.assertTrue((boolean)this.presenter.isUserAuthorizedForPerspective(perspectiveId));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ResourceRef.class);
        ((AuthorizationManager)Mockito.verify((Object)this.authorizationManager)).authorize((Resource)captor.capture(), (User)Mockito.eq((Object)this.identity));
        Assert.assertEquals((Object)perspectiveId, (Object)((ResourceRef)captor.getValue()).getIdentifier());
        Assert.assertEquals((Object)ActivityResourceType.PERSPECTIVE, (Object)((ResourceRef)captor.getValue()).getResourceType());
        Assert.assertFalse((boolean)this.presenter.isUserAuthorizedForPerspective(perspectiveId));
    }

    @Test
    public void testViewTasksActionCondition() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("TaskAdmin")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        Assert.assertTrue((boolean)this.presenter.getViewTasksActionCondition().test(new ProcessInstanceSummary()));
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("Tasks")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        Assert.assertTrue((boolean)this.presenter.getViewTasksActionCondition().test(new ProcessInstanceSummary()));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.presenter.getViewJobsActionCondition().test(new ProcessInstanceSummary()));
    }

    @Test
    public void testViewJobsActionCondition() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("Requests")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        Assert.assertTrue((boolean)this.presenter.getViewJobsActionCondition().test(new ProcessInstanceSummary()));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.presenter.getViewJobsActionCondition().test(new ProcessInstanceSummary()));
    }

    @Test
    public void testViewErrorsActionCondition() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("ExecutionErrors")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        ProcessInstanceSummary okProcInst = new ProcessInstanceSummary();
        ProcessInstanceSummary errProcInst = new ProcessInstanceSummary();
        errProcInst.setErrorCount(Integer.valueOf(1));
        Predicate viewErrCondition = this.presenter.getViewErrorsActionCondition();
        Assert.assertFalse((boolean)viewErrCondition.test(okProcInst));
        Assert.assertTrue((boolean)viewErrCondition.test(errProcInst));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Assert.assertFalse((boolean)viewErrCondition.test(okProcInst));
        Assert.assertFalse((boolean)viewErrCondition.test(errProcInst));
    }

    @Test
    public void testAbortActionCondition() {
        ProcessInstanceListPresenterTest.testProcessInstanceStatusCondition(this.presenter.getAbortActionCondition(), 1);
    }

    @Test
    public void testSignalActionCondition() {
        ProcessInstanceListPresenterTest.testProcessInstanceStatusCondition(this.presenter.getSignalActionCondition(), 1);
    }

    @Test
    public void testOpenTaskView() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true, (Object[])new Boolean[]{false});
        this.presenter.openTaskView("");
        this.presenter.openTaskView("");
        ArgumentCaptor captor = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)2))).goTo((PlaceRequest)captor.capture());
        Assert.assertEquals((long)2L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)"TaskAdmin", (Object)((PlaceRequest)captor.getAllValues().get(0)).getIdentifier());
        Assert.assertEquals((Object)"Tasks", (Object)((PlaceRequest)captor.getAllValues().get(1)).getIdentifier());
    }

    @Test
    public void testCreateDataSetProcessInstanceCallbackOnError() {
        ProcessInstanceListPresenter spy = (ProcessInstanceListPresenter)Mockito.spy((Object)this.presenter);
        ClientRuntimeError error = new ClientRuntimeError("");
        FilterSettings filterSettings = (FilterSettings)Mockito.mock(FilterSettings.class);
        DataSetReadyCallback callback = spy.getDataSetReadyCallback(Integer.valueOf(0), filterSettings);
        ((ProcessInstanceListPresenter)Mockito.doNothing().when((Object)spy)).showErrorPopup((String)Mockito.any());
        Assert.assertFalse((boolean)callback.onError(error));
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).hideBusyIndicator();
        ((ProcessInstanceListPresenter)Mockito.verify((Object)spy)).showErrorPopup(Constants.INSTANCE.ResourceCouldNotBeLoaded(this.commonConstants.Process_Instances()));
    }

    @Test
    public void testListBreadcrumbCreation() {
        this.presenter.createListBreadcrumb();
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).clearBreadcrumbs(PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Manage_Process_Instances()), (Command)Mockito.eq((Object)Commands.DO_NOTHING));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.breadcrumbs});
    }

    @Test
    public void testSetupDetailBreadcrumb() {
        String detailLabel = "detailLabel";
        String detailScreenId = "screenId";
        PlaceManager placeManagerMock = (PlaceManager)Mockito.mock(PlaceManager.class);
        this.presenter.setPlaceManager(placeManagerMock);
        this.presenter.setupDetailBreadcrumb(placeManagerMock, this.commonConstants.Manage_Process_Instances(), detailLabel, detailScreenId);
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).clearBreadcrumbs(PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Manage_Process_Instances()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).closePlace(detailScreenId);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)detailLabel), (Command)Mockito.eq((Object)Commands.DO_NOTHING));
    }

    @Test
    public void testOnBasicFilterAddEvent() {
        ActiveFilterItem filter = new ActiveFilterItem("key1", null, null, null, null);
        ColumnFilter columnFilter = (ColumnFilter)Mockito.mock(ColumnFilter.class);
        this.presenter.onBasicFilterAddEvent(new BasicFilterAddEvent("ProcessInstanceLogDataset", filter, columnFilter));
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).addActiveFilter(filter);
        ((FilterSettings)Mockito.verify((Object)this.filterSettings, (VerificationMode)Mockito.never())).addColumnFilter(columnFilter);
        this.presenter.onBasicFilterAddEvent(new BasicFilterAddEvent(this.datasetUId, filter, columnFilter));
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter(filter);
        ((FilterSettings)Mockito.verify((Object)this.filterSettings)).addColumnFilter(columnFilter);
    }

    @Test
    public void testOnBasicFilterRemoveEvent() {
        ActiveFilterItem filter = new ActiveFilterItem("key1", null, null, null, null);
        ColumnFilter columnFilter = (ColumnFilter)Mockito.mock(ColumnFilter.class);
        this.presenter.onBasicFilterRemoveEvent(new BasicFilterRemoveEvent("ProcessInstanceLogDataset", filter, columnFilter));
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).removeActiveFilter(filter);
        ((FilterSettings)Mockito.verify((Object)this.filterSettings, (VerificationMode)Mockito.never())).removeColumnFilter(columnFilter);
        this.presenter.onBasicFilterRemoveEvent(new BasicFilterRemoveEvent(this.datasetUId, filter, columnFilter));
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock)).removeActiveFilter(filter);
        ((FilterSettings)Mockito.verify((Object)this.filterSettings)).removeColumnFilter(columnFilter);
    }

    @Test
    public void testSelectProcessInstance() {
        this.presenter.setProcessInstanceSelectedEvent(this.processInstanceSelectionEvent);
        ProcessInstanceSummary okProcInst = new ProcessInstanceSummary();
        this.presenter.selectSummaryItem(okProcInst);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ProcessInstanceSelectionEvent.class);
        ((EventSourceMock)Mockito.verify(this.processInstanceSelectionEvent)).fire(argument.capture());
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("ProcessInstanceDetailsScreen");
        ((ProcessInstanceListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).displayNotification(Mockito.anyString());
    }

    @Test
    public void testFilterInitiator() {
        String variableNameWithInitiator = "initiator";
        String variableValueWithInitiator = "initiator people";
        String variableNameWithoutInitiator = "noinitiator";
        String variableValueWithoutInitiator = "other people";
        Assert.assertEquals((Object)true, (Object)this.presenter.filterInitiator(variableNameWithInitiator, variableValueWithInitiator, variableValueWithInitiator));
        Assert.assertEquals((Object)false, (Object)this.presenter.filterInitiator(variableNameWithoutInitiator, variableValueWithoutInitiator, variableValueWithoutInitiator));
        Assert.assertEquals((Object)false, (Object)this.presenter.filterInitiator(variableNameWithInitiator, variableValueWithInitiator, variableValueWithoutInitiator));
        Assert.assertEquals((Object)false, (Object)this.presenter.filterInitiator(variableNameWithoutInitiator, variableValueWithoutInitiator, variableValueWithInitiator));
    }

    protected class PerspectiveAnswer
    implements Answer<Boolean> {
        private String perspectiveId;

        public PerspectiveAnswer(String perspectiveId) {
            this.perspectiveId = perspectiveId;
        }

        public Boolean answer(InvocationOnMock invocation) throws Throwable {
            return this.perspectiveId.equals(((ResourceRef)invocation.getArguments()[0]).getIdentifier());
        }
    }
}

