/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.active.ClearAllActiveFiltersEvent;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.service.TaskService;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogBasicFiltersPresenter;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogFilterSettingsManager;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogHumanTaskView;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceLogPresenterTest {
    @Mock
    ProcessInstanceLogPresenter.ProcessInstanceLogView view;
    @Mock
    protected ErrorPopupPresenter errorPopup;
    @Mock
    protected DataSetQueryHelper logsDataSetQueryHelper;
    @Mock
    protected ProcessInstanceLogFilterSettingsManager filterSettingsManager;
    @Mock
    protected ProcessInstanceLogBasicFiltersPresenter processInstanceLogBasicFiltersPresenter;
    @Mock
    FilterSettings currentFilterSettings;
    @Mock
    private DataSet dataSet;
    @Mock
    TaskService taskServiceMock;
    Caller<TaskService> taskService;
    @InjectMocks
    ProcessInstanceLogPresenter presenter;
    private String processName = "processName";
    private String testTask = "testTask";
    private String datasetUID = "jbpmProcessInstanceLogs";
    private Date logDate = new Date();
    private Long[] pilIds = new Long[4];
    private String[] pilNodeType = new String[4];
    private String[] pilNodeNames = new String[4];
    private Boolean[] pilCompleted = new Boolean[4];

    @Before
    public void setup() {
        this.pilIds[0] = 1L;
        this.pilIds[1] = 2L;
        this.pilIds[2] = 3L;
        this.pilIds[3] = 4L;
        this.pilNodeNames[0] = "";
        this.pilNodeNames[1] = this.testTask;
        this.pilNodeNames[2] = "";
        this.pilNodeNames[3] = "";
        this.pilNodeType[0] = LogUtils.NODE_TYPE_START;
        this.pilNodeType[1] = LogUtils.NODE_TYPE_HUMAN_TASK;
        this.pilNodeType[2] = LogUtils.NODE_TYPE_END;
        this.pilNodeType[3] = "Split";
        this.pilCompleted[0] = false;
        this.pilCompleted[1] = false;
        this.pilCompleted[2] = true;
        this.pilCompleted[3] = false;
        for (int i = 0; i < this.pilIds.length; ++i) {
            this.defineDatasetAnswer(i, this.pilIds[i], this.logDate, this.pilNodeNames[i], this.pilNodeType[i], this.pilCompleted[i]);
        }
        Mockito.when((Object)this.dataSet.getRowCount()).thenReturn((Object)4);
        Mockito.when((Object)this.dataSet.getUUID()).thenReturn((Object)this.datasetUID);
        this.presenter.setDataSetQueryHelper(this.logsDataSetQueryHelper);
        this.presenter.setFilterSettingsManager(this.filterSettingsManager);
        this.presenter.setProcessInstanceLogBasicFiltersPresenter(this.processInstanceLogBasicFiltersPresenter);
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(ProcessInstanceLogPresenterTest.this.dataSet);
                return null;
            }
        }).when((Object)this.logsDataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        Mockito.when((Object)this.logsDataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.currentFilterSettings);
        Mockito.when((Object)this.filterSettingsManager.createDefaultFilterSettingsPrototype(Long.valueOf(Mockito.anyLong()))).thenReturn((Object)this.currentFilterSettings);
        Mockito.when((Object)this.currentFilterSettings.getKey()).thenReturn((Object)"key");
        Mockito.when((Object)this.currentFilterSettings.getDataSet()).thenReturn((Object)this.dataSet);
        this.taskService = new CallerMock((Object)this.taskServiceMock);
        this.presenter.setTaskService(this.taskService);
    }

    private void assertProcessInstanceLogContent(Long id, Date date, String nodeName, String nodeType, boolean completed, ProcessInstanceLogSummary processInstanceLogSummaryDest) {
        Assert.assertEquals((Object)id, (Object)processInstanceLogSummaryDest.getId());
        Assert.assertEquals((Object)date, (Object)processInstanceLogSummaryDest.getDate());
        Assert.assertEquals((Object)nodeName, (Object)processInstanceLogSummaryDest.getName());
        Assert.assertEquals((Object)nodeType, (Object)processInstanceLogSummaryDest.getNodeType());
        Assert.assertEquals((Object)completed, (Object)processInstanceLogSummaryDest.isCompleted());
    }

    public void defineDatasetAnswer(int position, Long id, Date date, String nodeName, String nodeType, boolean completed) {
        Mockito.when((Object)this.dataSet.getValueAt(position, "nodeInstanceId")).thenReturn((Object)id);
        Mockito.when((Object)this.dataSet.getValueAt(position, "log_date")).thenReturn((Object)date);
        Mockito.when((Object)this.dataSet.getValueAt(position, "nodeName")).thenReturn((Object)nodeName);
        Mockito.when((Object)this.dataSet.getValueAt(position, "nodeType")).thenReturn((Object)nodeType);
        Mockito.when((Object)this.dataSet.getValueAt(position, "type")).thenReturn((Object)(completed ? 1 : 0));
    }

    @Test
    public void datasetLookupNotFoundTest() {
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).notFound();
                return null;
            }
        }).when((Object)this.logsDataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        this.presenter.loadProcessInstanceLogs();
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopup)).showMessage((String)Mockito.eq((Object)org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.DataSetNotFound(this.datasetUID)));
    }

    @Test
    public void datasetLookupErrorTest() {
        final String errorMessage = "error message";
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).onError(new ClientRuntimeError(errorMessage));
                return null;
            }
        }).when((Object)this.logsDataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        this.presenter.loadProcessInstanceLogs();
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopup)).showMessage((String)Mockito.eq((Object)org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.DataSetError(this.datasetUID, errorMessage)));
    }

    @Test
    public void testLoadMoreProcessInstanceLogs() {
        this.presenter.setCurrentPage(0);
        this.presenter.loadProcessInstanceLogs();
        Assert.assertEquals((long)0L, (long)this.presenter.getCurrentPage());
        ((DataSetQueryHelper)Mockito.verify((Object)this.logsDataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.eq((int)(this.presenter.getPageSize() * this.presenter.getCurrentPage()))), (DataSetReadyCallback)Mockito.any());
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view)).setLogsList((List)argumentDESC.capture());
        Assert.assertEquals((long)4L, (long)((List)argumentDESC.getValue()).size());
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view)).hideLoadButton(true);
        this.presenter.loadMoreProcessInstanceLogs();
        Assert.assertEquals((long)1L, (long)this.presenter.getCurrentPage());
        ((DataSetQueryHelper)Mockito.verify((Object)this.logsDataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.eq((int)(this.presenter.getPageSize() * this.presenter.getCurrentPage()))), (DataSetReadyCallback)Mockito.any());
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setLogsList((List)argumentDESC.capture());
        Assert.assertEquals((long)8L, (long)((List)argumentDESC.getValue()).size());
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setLogsList(Mockito.anyList());
    }

    @Test
    public void testLoadTaskDetails() {
        Long workItemId = 1L;
        String containerId = "deploymentId";
        String serverTemplateId = "server-template-id";
        TaskSummary task = TaskSummary.builder().id(workItemId).actualOwner("owner").createdOn(new Date()).description("description").build();
        ProcessInstanceLogHumanTaskView humanTaskView = (ProcessInstanceLogHumanTaskView)Mockito.mock(ProcessInstanceLogHumanTaskView.class);
        Mockito.when((Object)this.taskServiceMock.getTaskByWorkItemId(serverTemplateId, containerId, workItemId)).thenReturn((Object)task);
        ProcessInstanceSelectionEvent selectionEventMock = (ProcessInstanceSelectionEvent)Mockito.mock(ProcessInstanceSelectionEvent.class);
        Mockito.when((Object)selectionEventMock.getDeploymentId()).thenReturn((Object)containerId);
        Mockito.when((Object)selectionEventMock.getServerTemplateId()).thenReturn((Object)serverTemplateId);
        this.presenter.onProcessInstanceSelectionEvent(selectionEventMock);
        this.presenter.loadTaskDetails(workItemId, this.logDate, humanTaskView);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getTaskByWorkItemId(serverTemplateId, containerId, workItemId);
        ((ProcessInstanceLogHumanTaskView)Mockito.verify((Object)humanTaskView)).setDetailsData(task, this.logDate);
    }

    @Test
    public void onProcessInstaceSelectionTest() {
        Long processInstanceId = 1L;
        String processDefId = "processDefId";
        String deploymentId = "deploymentId";
        Integer processInstanceStatus = 0;
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.logsDataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.currentFilterSettings);
        this.presenter.onProcessInstanceSelectionEvent(new ProcessInstanceSelectionEvent(deploymentId, processInstanceId, processDefId, this.processName, processInstanceStatus, serverTemplateId));
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addActiveFilter((ActiveFilterItem)Mockito.any(ActiveFilterItem.class));
        ((FilterSettings)Mockito.verify((Object)this.currentFilterSettings)).setServerTemplateId(serverTemplateId);
        ((FilterSettings)Mockito.verify((Object)this.currentFilterSettings)).setTablePageSize(this.presenter.getPageSize());
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view)).setLogsList((List)argumentDESC.capture());
        Assert.assertEquals((long)4L, (long)((List)argumentDESC.getValue()).size());
        for (int i = 0; i < ((List)argumentDESC.getValue()).size(); ++i) {
            this.assertProcessInstanceLogContent(this.pilIds[i], this.logDate, this.pilNodeNames[i], this.pilNodeType[i], this.pilCompleted[i], (ProcessInstanceLogSummary)((List)argumentDESC.getValue()).get(i));
        }
    }

    @Test
    public void processInstaceSelectionDefaultFiltersAdditionTest() {
        String serverTemplateId = "serverTemplateId";
        DataSetQueryHelper dataSetQueryHelperSpy = (DataSetQueryHelper)Mockito.spy(DataSetQueryHelper.class);
        this.presenter.setDataSetQueryHelper(dataSetQueryHelperSpy);
        this.presenter.onProcessInstanceSelectionEvent(new ProcessInstanceSelectionEvent("deploymentId", Long.valueOf(1L), "processDefId", "processName", Integer.valueOf(0), serverTemplateId));
        ((ProcessInstanceLogBasicFiltersPresenter)Mockito.verify((Object)this.processInstanceLogBasicFiltersPresenter)).onClearAllActiveFiltersEvent((ClearAllActiveFiltersEvent)Mockito.any(ClearAllActiveFiltersEvent.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addActiveFilter((ActiveFilterItem)captor.capture());
        ActiveFilterItem nodeTypefilterItem = (ActiveFilterItem)captor.getAllValues().get(0);
        Assert.assertNotNull((Object)nodeTypefilterItem);
        Assert.assertEquals((Object)Constants.INSTANCE.EventNodeType(), (Object)nodeTypefilterItem.getKey());
        List values = (List)nodeTypefilterItem.getValue();
        Assert.assertEquals((long)8L, (long)values.size());
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_START, values.get(0));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_END, values.get(1));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_HUMAN_TASK, values.get(2));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_ACTION, values.get(3));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_MILESTONE, values.get(4));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_SUBPROCESS, values.get(5));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_RULE_SET, values.get(6));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_WORK_ITEM, values.get(7));
        ActiveFilterItem typeFilterItem = (ActiveFilterItem)captor.getAllValues().get(1);
        Assert.assertNotNull((Object)typeFilterItem);
        Assert.assertEquals((Object)Constants.INSTANCE.EventType(), (Object)typeFilterItem.getKey());
        Assert.assertEquals(Collections.emptyList(), (Object)typeFilterItem.getValue());
        ((FilterSettings)Mockito.verify((Object)this.currentFilterSettings, (VerificationMode)Mockito.times((int)2))).setServerTemplateId(serverTemplateId);
        ((FilterSettings)Mockito.verify((Object)this.currentFilterSettings, (VerificationMode)Mockito.times((int)2))).setTablePageSize(this.presenter.getPageSize());
    }

    @Test
    public void testDefaultActiveSearchFilters() {
        this.presenter.setupDefaultActiveSearchFilters();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addActiveFilter((ActiveFilterItem)captor.capture());
        ActiveFilterItem nodeTypefilterItem = (ActiveFilterItem)captor.getAllValues().get(0);
        Assert.assertNotNull((Object)nodeTypefilterItem);
        Assert.assertEquals((Object)Constants.INSTANCE.EventNodeType(), (Object)nodeTypefilterItem.getKey());
        List values = (List)nodeTypefilterItem.getValue();
        Assert.assertEquals((long)8L, (long)values.size());
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_START, values.get(0));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_END, values.get(1));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_HUMAN_TASK, values.get(2));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_ACTION, values.get(3));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_MILESTONE, values.get(4));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_SUBPROCESS, values.get(5));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_RULE_SET, values.get(6));
        Assert.assertEquals((Object)LogUtils.NODE_TYPE_WORK_ITEM, values.get(7));
        ActiveFilterItem typeFilterItem = (ActiveFilterItem)captor.getAllValues().get(1);
        Assert.assertNotNull((Object)typeFilterItem);
        Assert.assertEquals((Object)Constants.INSTANCE.EventType(), (Object)typeFilterItem.getKey());
        Assert.assertEquals(Collections.emptyList(), (Object)typeFilterItem.getValue());
    }
}

