/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.user.client.TakesValue;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.AbstractView;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogItemDetailsView;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;

@Dependent
@Templated
public class ProcessInstanceLogItemView
extends AbstractView<ProcessInstanceLogPresenter>
implements TakesValue<ProcessInstanceLogSummary>,
IsElement {
    private Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="list-group-item")
    Div listGroupItem;
    @Inject
    @DataField(value="logIcon")
    Span logIcon;
    @Inject
    @DataField(value="logTime")
    Span logTime;
    @Inject
    @DataField(value="nodeTypeDesc")
    Span nodeTypeDesc;
    @Inject
    @DataField(value="logCompleted")
    Span logCompleted;
    @Inject
    @DataField(value="detailsPanelDiv")
    Div detailsPanelDiv;
    @Inject
    @DataField(value="detailsLink")
    Anchor detailsLink;
    @Inject
    @DataField(value="detailsInfoDiv")
    Div detailsInfoDiv;
    @Inject
    @AutoBound
    private DataBinder<ProcessInstanceLogSummary> logSummary;
    @Inject
    ProcessInstanceLogItemDetailsView workItemView;

    @PostConstruct
    public void init() {
        this.tooltip((HTMLElement)this.logIcon);
    }

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public ProcessInstanceLogSummary getValue() {
        return (ProcessInstanceLogSummary)this.logSummary.getModel();
    }

    public void setValue(ProcessInstanceLogSummary model) {
        String iconClass = "list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm";
        this.logSummary.setModel((Object)model);
        this.logTime.setTextContent(DateUtils.getPrettyTime((Date)model.getDate()));
        String agent = this.constants.System();
        if (LogUtils.NODE_TYPE_HUMAN_TASK.equals(model.getNodeType()) || LogUtils.NODE_TYPE_START.equals(model.getNodeType()) && !model.isCompleted()) {
            iconClass = iconClass + " fa fa-user";
            agent = this.constants.Human();
            this.tooltip((HTMLElement)this.logIcon);
            this.logIcon.setAttribute("data-original-title", this.constants.Human_Task());
        } else {
            iconClass = iconClass + " fa fa-cogs";
            this.logIcon.setAttribute("data-original-title", this.constants.System_Task());
        }
        if (model.isCompleted()) {
            iconClass = iconClass + " kie-timeline-icon--completed";
            this.logCompleted.setTextContent(this.constants.NodeWasLeft(agent));
        } else {
            this.logCompleted.setTextContent(this.constants.NodeWasEntered(agent));
        }
        this.logIcon.setClassName(iconClass);
        this.nodeTypeDesc.setTextContent(this.getLogTitle(model));
        if (model.getWorkItemId() == null) {
            this.detailsPanelDiv.setHidden(true);
        } else {
            this.setDetailsPanelAttributes(model);
            this.detailsPanelDiv.setHidden(false);
        }
    }

    private String getLogTitle(ProcessInstanceLogSummary logsum) {
        if (LogUtils.NODE_TYPE_HUMAN_TASK.equals(logsum.getNodeType())) {
            return this.constants.Task_(logsum.getName());
        }
        String name = logsum.getName();
        if (name != null && name.trim().length() > 0) {
            return logsum.getNodeType() + " '" + name + "' ";
        }
        return logsum.getNodeType();
    }

    private void setDetailsPanelAttributes(ProcessInstanceLogSummary model) {
        String panelId = ((Long)model.getId()).toString() + model.getDate().getTime();
        this.detailsLink.setAttribute("href", "#" + panelId);
        this.detailsInfoDiv.setId(panelId);
    }

    @EventHandler(value={"detailsLink"})
    public void loadProcessInstanceLogsDetails(@ForEvent(value={"click"}) MouseEvent event) {
        if (!this.detailsInfoDiv.hasChildNodes() && ((ProcessInstanceLogSummary)this.logSummary.getModel()).getWorkItemId() != null) {
            if (LogUtils.NODE_TYPE_HUMAN_TASK.equals(((ProcessInstanceLogSummary)this.logSummary.getModel()).getNodeType())) {
                ((ProcessInstanceLogPresenter)((Object)this.presenter)).loadTaskDetails(((ProcessInstanceLogSummary)this.logSummary.getModel()).getWorkItemId(), ((ProcessInstanceLogSummary)this.logSummary.getModel()).getDate(), this.workItemView);
            } else {
                ((ProcessInstanceLogPresenter)((Object)this.presenter)).loadWorkItemDetails(((ProcessInstanceLogSummary)this.logSummary.getModel()).getWorkItemId(), this.workItemView);
            }
            this.detailsInfoDiv.appendChild((Node)this.workItemView.getElement());
        }
    }
}

