/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.details;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.model.TaskDefSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;

@Dependent
public class ProcessDefinitionDetailsTabPresenter {
    private Constants constants = Constants.INSTANCE;
    private String currentProcessDefId = "";
    private String currentDeploymentId = "";
    private String currentServerTemplateId = "";
    @Inject
    private AdvancedProcessDefDetailsView view;
    @Inject
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;

    public void onProcessDefSelectionEvent(@Observes ProcessDefSelectionEvent event) {
        this.currentProcessDefId = event.getProcessId();
        this.currentDeploymentId = event.getDeploymentId();
        this.currentServerTemplateId = event.getServerTemplateId();
        this.refreshView(this.currentProcessDefId, this.currentDeploymentId);
        this.refreshProcessDef(this.currentServerTemplateId, this.currentDeploymentId, this.currentProcessDefId, event.isDynamic());
    }

    public IsWidget getWidget() {
        return this.view;
    }

    protected void refreshView(String processId, String deploymentId) {
        this.view.setProcessIdText(processId);
        this.view.setDeploymentIdText(deploymentId);
    }

    private void refreshServiceTasks(Map<String, String> services) {
        this.view.setProcessServicesListBox("");
        SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
        if (services.keySet().isEmpty()) {
            safeHtmlBuilder.appendEscaped(this.constants.NoServicesRequiredForThisProcess());
            this.view.setProcessServicesListBox(safeHtmlBuilder.toSafeHtml().asString());
        } else {
            for (String key : services.keySet()) {
                safeHtmlBuilder.appendEscapedLines(key + " - " + services.get(key) + "\n");
            }
            this.view.setProcessServicesListBox(safeHtmlBuilder.toSafeHtml().asString());
        }
    }

    private void refreshProcessItems(ProcessSummary process) {
        if (process != null) {
            this.view.setProcessNameText(process.getName());
        } else {
            this.view.setProcessNameText("");
        }
    }

    private void refreshReusableSubProcesses(Collection<String> subprocesses) {
        this.view.setSubProcessListBox("");
        SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
        if (subprocesses.isEmpty()) {
            safeHtmlBuilder.appendEscapedLines(this.constants.NoSubprocessesRequiredByThisProcess());
            this.view.setSubProcessListBox(safeHtmlBuilder.toSafeHtml().asString());
        } else {
            for (String key : subprocesses) {
                safeHtmlBuilder.appendEscapedLines(key + "\n");
            }
            this.view.setSubProcessListBox(safeHtmlBuilder.toSafeHtml().asString());
        }
    }

    private void refreshRequiredInputData(Map<String, String> inputs) {
        this.view.setProcessDataListBox("");
        SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
        if (inputs.keySet().isEmpty()) {
            safeHtmlBuilder.appendEscapedLines(this.constants.NoProcessVariablesDefinedForThisProcess());
            this.view.setProcessDataListBox(safeHtmlBuilder.toSafeHtml().asString());
        } else {
            for (String key : inputs.keySet()) {
                safeHtmlBuilder.appendEscapedLines(key + " - " + inputs.get(key) + "\n");
            }
            this.view.setProcessDataListBox(safeHtmlBuilder.toSafeHtml().asString());
        }
    }

    private void refreshAssociatedEntities(Map<String, String[]> entities) {
        this.view.setUsersGroupsListBox("");
        SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
        if (entities.keySet().isEmpty()) {
            safeHtmlBuilder.appendEscapedLines(this.constants.NoUserOrGroupUsedInThisProcess());
            this.view.setUsersGroupsListBox(safeHtmlBuilder.toSafeHtml().asString());
        } else {
            for (String key : entities.keySet()) {
                StringBuffer names = new StringBuffer();
                String[] entityNames = entities.get(key);
                if (entityNames != null) {
                    for (String entity : entityNames) {
                        names.append("'" + entity + "' ");
                    }
                }
                safeHtmlBuilder.appendEscapedLines(names + " - " + key + "\n");
            }
            this.view.setUsersGroupsListBox(safeHtmlBuilder.toSafeHtml().asString());
        }
    }

    private void refreshTaskDef(String serverTemplateId, String deploymentId, String processId) {
        this.view.setNumberOfHumanTasksText("");
        this.view.setHumanTasksListBox("");
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<List<TaskDefSummary>>(){

            public void callback(List<TaskDefSummary> userTaskSummaries) {
                ProcessDefinitionDetailsTabPresenter.this.view.setNumberOfHumanTasksText(String.valueOf(userTaskSummaries.size()));
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                if (userTaskSummaries.isEmpty()) {
                    safeHtmlBuilder.appendEscapedLines(ProcessDefinitionDetailsTabPresenter.this.constants.NoUserTasksDefinedInThisProcess());
                    ProcessDefinitionDetailsTabPresenter.this.view.setHumanTasksListBox(safeHtmlBuilder.toSafeHtml().asString());
                } else {
                    for (TaskDefSummary t : userTaskSummaries) {
                        safeHtmlBuilder.appendEscapedLines(t.getName() + "\n");
                    }
                    ProcessDefinitionDetailsTabPresenter.this.view.setHumanTasksListBox(safeHtmlBuilder.toSafeHtml().asString());
                }
            }
        })).getProcessUserTasks(serverTemplateId, deploymentId, processId);
    }

    protected void refreshProcessDef(final String serverTemplateId, final String deploymentId, final String processId, boolean isDynamic) {
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<ProcessSummary>(){

            public void callback(ProcessSummary process) {
                if (process != null) {
                    ProcessDefinitionDetailsTabPresenter.this.refreshTaskDef(serverTemplateId, deploymentId, processId);
                    ProcessDefinitionDetailsTabPresenter.this.refreshAssociatedEntities(process.getAssociatedEntities());
                    ProcessDefinitionDetailsTabPresenter.this.refreshRequiredInputData(process.getProcessVariables());
                    ProcessDefinitionDetailsTabPresenter.this.refreshReusableSubProcesses(process.getReusableSubProcesses());
                    ProcessDefinitionDetailsTabPresenter.this.refreshProcessItems(process);
                    ProcessDefinitionDetailsTabPresenter.this.refreshServiceTasks(process.getServiceTasks());
                }
            }
        })).getProcess(serverTemplateId, new ProcessDefinitionKey(serverTemplateId, deploymentId, processId, isDynamic));
    }

    public static interface AdvancedProcessDefDetailsView
    extends IsWidget {
        public void setNumberOfHumanTasksText(String var1);

        public void setHumanTasksListBox(String var1);

        public void setUsersGroupsListBox(String var1);

        public void setProcessDataListBox(String var1);

        public void setProcessServicesListBox(String var1);

        public void setSubProcessListBox(String var1);

        public void displayNotification(String var1);

        public void setProcessNameText(String var1);

        public void setProcessIdText(String var1);

        public void setDeploymentIdText(String var1);
    }
}

