/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.pr.client.editors.instance.ProcessInstanceSummaryAware;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.UserTaskSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;

@Dependent
public class ProcessInstanceDetailsTabPresenter
implements ProcessInstanceSummaryAware {
    private ProcessInstanceDetailsTabView view;
    private Constants constants = Constants.INSTANCE;
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;

    @Inject
    public void setView(ProcessInstanceDetailsTabView view) {
        this.view = view;
    }

    @Inject
    public void setProcessRuntimeDataService(Caller<ProcessRuntimeDataService> processRuntimeDataService) {
        this.processRuntimeDataService = processRuntimeDataService;
    }

    public IsWidget getWidget() {
        return this.view;
    }

    @Override
    public void setProcessInstance(ProcessInstanceSummary process) {
        this.view.setProcessDefinitionIdText("");
        this.view.setProcessVersionText("");
        this.view.setProcessDeploymentText("");
        this.view.setCorrelationKeyText("");
        this.view.setParentProcessInstanceIdText("");
        this.view.setActiveTasksListBox("");
        this.view.setStateText("");
        this.view.setCurrentActivitiesListBox("");
        this.view.setProcessDefinitionIdText(process.getProcessId());
        this.view.setProcessVersionText(process.getProcessVersion());
        this.view.setProcessDeploymentText(process.getDeploymentId());
        this.view.setCorrelationKeyText(process.getCorrelationKey());
        if (process.getParentId() > 0L) {
            this.view.setParentProcessInstanceIdText(process.getParentId().toString());
        } else {
            this.view.setParentProcessInstanceIdText(this.constants.No_Parent_Process_Instance());
        }
        String statusStr = this.constants.Unknown();
        switch (process.getState()) {
            case 1: {
                statusStr = this.constants.Active();
                break;
            }
            case 3: {
                statusStr = this.constants.Aborted();
                break;
            }
            case 2: {
                statusStr = this.constants.Completed();
                break;
            }
            case 0: {
                statusStr = this.constants.Pending();
                break;
            }
            case 4: {
                statusStr = this.constants.Suspended();
                break;
            }
        }
        this.view.setStateText(statusStr);
        String slaComplianceStr = this.mapSlaCompliance(process);
        this.view.setSlaComplianceText(slaComplianceStr);
        if (process.getActiveTasks() != null && !process.getActiveTasks().isEmpty()) {
            SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
            for (UserTaskSummary uts : process.getActiveTasks()) {
                safeHtmlBuilder.appendEscapedLines(uts.getName() + " (" + uts.getStatus() + ")  " + this.constants.Owner() + ": " + uts.getOwner() + " \n");
            }
            this.view.setActiveTasksListBox(safeHtmlBuilder.toSafeHtml().asString());
        }
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call(details -> {
            SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
            for (NodeInstanceSummary nis : details) {
                safeHtmlBuilder.appendEscapedLines(nis.getTimestamp() + ": " + nis.getId() + " - " + nis.getName() + " (" + nis.getType() + ") \n");
            }
            this.view.setCurrentActivitiesListBox(safeHtmlBuilder.toSafeHtml().asString());
        })).getProcessInstanceActiveNodes(process.getProcessInstanceKey());
    }

    protected String mapSlaCompliance(ProcessInstanceSummary process) {
        String slaComplianceStr = this.constants.Unknown();
        switch (process.getSlaCompliance()) {
            case 0: {
                slaComplianceStr = this.constants.SlaNA();
                break;
            }
            case 1: {
                slaComplianceStr = this.constants.SlaPending();
                break;
            }
            case 2: {
                slaComplianceStr = this.constants.SlaMet();
                break;
            }
            case 4: {
                slaComplianceStr = this.constants.SlaAborted();
                break;
            }
            case 3: {
                slaComplianceStr = this.constants.SlaViolated();
                break;
            }
        }
        return slaComplianceStr;
    }

    public static interface ProcessInstanceDetailsTabView
    extends IsWidget {
        public void setCurrentActivitiesListBox(String var1);

        public void setActiveTasksListBox(String var1);

        public void setProcessDefinitionIdText(String var1);

        public void setStateText(String var1);

        public void setProcessDeploymentText(String var1);

        public void setProcessVersionText(String var1);

        public void setCorrelationKeyText(String var1);

        public void setParentProcessInstanceIdText(String var1);

        public void setSlaComplianceText(String var1);
    }
}

