/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.diagram;

import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.ui.Composite;
import elemental2.dom.HTMLDivElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramWidgetViewImpl;
import org.jbpm.workbench.pr.client.editors.instance.diagram.NodeCounterView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.NodeInstancesView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessInstanceDiagramView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessNodeItemView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.TimerInstancesView;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessNodeSummary;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.views.pfly.widgets.D3;
import org.uberfire.client.views.pfly.widgets.Select;

@Dependent
@Templated(stylesheet="ProcessInstanceDiagram.css")
public class ProcessInstanceDiagramViewImpl
extends Composite
implements ProcessInstanceDiagramView {
    @Inject
    @DataField(value="diagram")
    private ProcessDiagramWidgetViewImpl diagram;
    @Inject
    @DataField(value="available-nodes")
    private Select processNodes;
    @Inject
    @DataField(value="node-details-panel")
    private ProcessNodeItemView processNodeSummaryView;
    @Inject
    @DataField(value="node-instances")
    private NodeInstancesView nodeInstancesView;
    @Inject
    @DataField(value="timer-instances")
    private TimerInstancesView timerInstancesView;
    @Inject
    @DataField(value="node-actions-panel")
    private HTMLDivElement nodeActionsPanel;
    @Inject
    private NodeCounterView nodeCounterView;
    private Callback<String> onProcessNodeSelectedCallback;
    private boolean renderBadges = true;
    private Map<String, Long> badges = new HashMap<String, Long>();

    @PostConstruct
    public void init() {
        this.nodeCounterView.setCallback(() -> this.showHideBadges());
    }

    @Override
    public void setOnProcessNodeSelectedCallback(Callback<String> callback) {
        this.onProcessNodeSelectedCallback = callback;
    }

    @Override
    public void setOnDiagramNodeSelectionCallback(Callback<String> callback) {
        this.diagram.setOnDiagramNodeSelectionCallback(callback);
    }

    @Override
    public void setProcessNodes(List<ProcessNodeSummary> nodes) {
        this.processNodes.removeAllOptions();
        nodes.forEach(node -> this.processNodes.addOption(node.getLabel(), node.getUniqueId()));
        this.processNodes.refresh();
    }

    public ProcessNodeSummary getValue() {
        return this.processNodeSummaryView.getValue();
    }

    public void setValue(ProcessNodeSummary node) {
        this.processNodeSummaryView.setValue(node);
        if (node.getId() == null) {
            this.processNodeSummaryView.getElement().classList.add(new String[]{"hidden"});
            this.processNodes.setValue("");
        } else {
            this.processNodeSummaryView.getElement().classList.remove(new String[]{"hidden"});
            this.processNodes.setValue(node.getUniqueId());
        }
    }

    @Override
    public void setNodeInstances(List<NodeInstanceSummary> nodes) {
        if (nodes.isEmpty()) {
            this.nodeInstancesView.getElement().classList.add(new String[]{"hidden"});
        } else {
            this.nodeInstancesView.getElement().classList.remove(new String[]{"hidden"});
        }
        this.nodeInstancesView.setValue(nodes);
    }

    @Override
    public void setTimerInstances(List<TimerInstanceSummary> timers) {
        if (timers.isEmpty()) {
            this.timerInstancesView.getElement().classList.add(new String[]{"hidden"});
        } else {
            this.timerInstancesView.getElement().classList.remove(new String[]{"hidden"});
        }
        this.timerInstancesView.setValue(timers);
    }

    @EventHandler(value={"available-nodes"})
    public void onProcessNodeChange(@ForEvent(value={"change"}) Event e) {
        this.processNodes.toggle();
        if (this.onProcessNodeSelectedCallback != null) {
            String node = this.processNodes.getValue();
            this.onProcessNodeSelectedCallback.callback(node == null || node.trim().isEmpty() ? null : node);
        }
    }

    @Override
    public void hideNodeActions() {
        this.nodeActionsPanel.classList.remove(new String[]{"col-md-2"});
        this.nodeActionsPanel.classList.add(new String[]{"hidden"});
        this.diagram.expandDiagramContanier();
    }

    @Override
    public void displayImage(String svgContent) {
        this.diagram.displayImage(svgContent);
        this.diagram.getElement().appendChild((Node)this.nodeCounterView.getElement());
    }

    @Override
    public void setNodeBadges(Map<String, Long> badges) {
        this.badges = badges;
        this.renderBadges = true;
    }

    @Override
    public void onShow() {
        this.renderBadges();
    }

    protected void showHideBadges() {
        D3 d3 = D3.Builder.get();
        D3.Selection nodes = d3.selectAll("#processDiagramDiv svg [jbpm-node-badge]");
        nodes.attr("visibility", (Object)(this.nodeCounterView.showBadges() ? "visible" : "hidden"));
    }

    protected void renderBadges() {
        if (!this.renderBadges) {
            return;
        }
        D3 d3 = D3.Builder.get();
        D3.Selection svg = d3.select("#processDiagramDiv svg");
        D3.DOMRect svgRect = svg.node().getBoundingClientRect();
        if (svgRect.getWidth() == 0.0 && svgRect.getHeight() == 0.0) {
            return;
        }
        this.badges.forEach((nodeId, count) -> {
            D3.Selection node = d3.select("#processDiagramDiv svg [bpmn2nodeid=" + nodeId + "]");
            D3.DOMRect bb = node.node().getBoundingClientRect();
            D3 group = node.append("g").attr("transform", (Object)("translate( " + (bb.getWidth() / 2.0 - 12.5) + ", " + (bb.getHeight() + 2.0) + ")")).attr("jbpm-node-badge", nodeId);
            group.append("rect").attr("x", (Object)"0").attr("y", (Object)"0").attr("width", (Object)"25").attr("height", (Object)"20").attr("rx", (Object)"5").attr("ry", (Object)"5").attr("fill", (Object)"grey").attr("opacity", (Object)"0.5");
            group.append("text").attr("font-size", (Object)"10pt").attr("font-weight", (Object)"normal").attr("font-family", (Object)"Open Sans").attr("font-style", (Object)"normal").attr("text-anchor", (Object)"middle").attr("fill", (Object)"white").attr("x", (Object)"12").attr("y", (Object)"15").text(String.valueOf(count));
        });
        this.showHideBadges();
        this.renderBadges = false;
    }

    @Override
    public void displayMessage(String message) {
        this.diagram.displayMessage(message);
    }

    public void showBusyIndicator(String message) {
        this.diagram.showBusyIndicator(message);
    }

    public void hideBusyIndicator() {
        this.diagram.hideBusyIndicator();
    }
}

